/*
 * Program:     $RCSfile: sound.c,v $  $Revision: 4.3 $
 *
 * Author:      H.Ariga     ariga@agusa.nuie.nagoya-u.ac.jp
 *              S.Yamamoto  yamamoto@nuie.nagoya-u.ac.jp
 *
 * Date:        1993/07/24
 * Modified:    $Date: 1995/04/08 10:58:31 $
 *
 * Copyright:   H.Ariga and S.Yamamoto  1993 - 1995
 *
 * The X Consortium, and any party obtaining a copy of these files from
 * the X Consortium, directly or indirectly, is granted, free of charge,
 * a full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and documentation
 * files (the "Software"), including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons who receive copies from any such
 * party to do so. This license includes without limitation a license to do
 * the foregoing actions under any patents of the party supplying this
 * software to the X Consortium.
 */

#ifndef lint
static char rcsid[] =
    "$Id: sound.c,v 4.3 1995/04/08 10:58:31 yamamoto Exp $";
#endif

/*
 * Sound facility: xyoubin on NEWS-OS and SunOS can play sound.
 *
 * Function play_sound():
 *     Return 0 if can play sound.
 *     Return 1 otherwise.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#ifdef sony_news
#include <sys/file.h>
#include <newsiodev/sound.h>
#include <soundlib.h>
#endif

#ifdef sony_news
#define AUDIO_DEVICE    "/dev/sb0"
#else
#define AUDIO_DEVICE    "/dev/audio"
#endif

#ifndef R_OK
#define R_OK            4                   /* Test for read permission. */
#endif /* R_OK */

#ifdef sony_news

int
play_sound(sound_file_name)
char    *sound_file_name;
{
    SFILE           *fin;
    int             fout;
    struct sbparam  savedparam;
    char            buf[256];
    int             c;

    if ((fin = OpenSoundFile(sound_file_name)) == NULL) {
        return (1);
    }
    if ((fout = open(AUDIO_DEVICE, O_RDWR)) == NULL) {
        close(fin);
        return (1);
    }
    
    ioctl(fout, SBIOCGETPARAM, &savedparam);
    ioctl(fout, SBIOCSETPARAM, SbparamOfSoundFile(fin));
    while (c = ReadSoundFile(buf, 1, 256, fin)) {
        write(fout, buf, c);
    }
    ioctl(fout, SBIOCSETPARAM, &savedparam);
    close(fout);
    CloseSoundFile(fin);

    return (0);
}

#endif /* sony_news */

/******************************************************************************/

#ifdef sun

int
play_sound(sound_file_name)
char    *sound_file_name;
{
    FILE            *fin, *fout;
    int             c;

    if ((fin = fopen(sound_file_name, "r")) == NULL) {
        return (1);
    }
    if ((fout = fopen(AUDIO_DEVICE, "w")) == NULL) {
        fclose(fin);
        return (1);
    }
    
    while ((c = fgetc(fin)) != EOF) {
        fputc(c, fout);
    }
    fclose(fout);
    fclose(fin);

    return (0);
}

#endif /* sun */
