/*
 * Program:     $RCSfile: protocol.c,v $  $Revision: 4.5 $
 *
 * Purpose:     Protocol routines of internet "youbin" service.
 *
 * Author:      K.Agusa     agusa@nuie.nagoya-u.ac.jp
 *              S.Yamamoto  yamamoto@nuie.nagoya-u.ac.jp
 *
 * Date:        1993/07/24
 * Modified:    $Date: 1995/01/07 10:35:34 $
 *
 * Copyright:   K.Agusa and S.Yamamoto  1993 - 94
 *
 * The X Consortium, and any party obtaining a copy of these files from
 * the X Consortium, directly or indirectly, is granted, free of charge,
 * a full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and documentation
 * files (the "Software"), including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons who receive copies from any such
 * party to do so. This license includes without limitation a license to do
 * the foregoing actions under any patents of the party supplying this
 * software to the X Consortium.
 */

#ifndef lint
static char rcsid[] =
    "$Id: protocol.c,v 4.5 1995/01/07 10:35:34 yamamoto Exp $";
#endif /* not lint */

#include <sys/types.h>          /* Must be included before "sys/socket.h". */
#include <sys/socket.h>         /* For struct sockaddr. */ 
#include <netinet/in.h>         /* For struct sockaddr_in. */
#include <arpa/inet.h>          /* For inet_ntoa(). */ 
#include <netdb.h>              /* For gethostbyname() and gethostbyaddr(). */
#include <stdio.h>

#include "youbin.h"
#include "server.h"

char *get_param( char *);
extern char *state_name[];

/* WAKE user_name AUTH=type VER=version */
void
do_Wakeup( char *mess )
{
  char    *params[3];
  char    buff[MESS_LEN + 1];
  StateP  id;                       /* User ID. */
  enum a_mode auth_mode;

  parse_mess( mess, "AUTH=\000VER=\000", params );
  if( strcmp( params[2], PROTOCOL_VERSION) != 0) {    /* Check protocol version. */
    strcpy( NAK_reason, "Invalid version");
    send_packet( NAK_buff, CA_ADDR );
    return;
  }
  if(( auth_mode = conv_a_mode( params[1] )) < 0 ){
    strcpy( NAK_reason, "Unknown authentification type" );
    send_packet(NAK_buff, CA_ADDR);
    return;
  }
  if(( id = make_user( mess, auth_mode )) != NULL) {
    if (debug_mode || trace_mode) {
      char            buff_log[LOG_LEN];  /* Only for log. */
      struct hostent  *hp;
      if ((hp = gethostbyaddr((char *)&ca.sin_addr,
			      sizeof(ca.sin_addr), ca.sin_family)) == NULL) {
	sys_error_log("gethostbyaddr");
      } 
      sprintf(buff_log, "Wakeup packet: %s [%ld]: host = %s, port = %d\n",
	      mess, (long)id,
	      ((hp != NULL) ? hp->h_name : inet_ntoa(ca.sin_addr)),
	      ntohs(ca.sin_port));
      debug_log("    %s", buff_log);
      trace(buff_log);
    }
    /*    if( auth_mode == PGP )      TO DO: The function to make key is required. */
    send_PREQ( id, "");               /* Normal answer PREQ ID KEY= */
  } else {                            /* Invalid user.      */
    send_packet( NAK_buff, CA_ADDR ); /* Send to global ca. */
  }
}

void do_Passwd( char *mess )
{   /* PASS user_ID PSWD=password HEAD=header_list KEEP_ALIVE=no */
  StateP  sp;
  char    *params[4];
  char    pass_decode[MESS_LEN];
  int     head;
  
  parse_mess( mess, "PSWD=\000HEAD=\000KEEP_ALIVE=\000", params );
  if(( sp = get_id( params[0] )) == NULL ){
    return;                               /* Invalid ID then can't help */
  }
  head = headers( params[2] );
  mimedecode( params[1], pass_decode );
  if( check_pass( sp, pass_decode, head ) == FAIL ){
    strcpy( NAK_reason, "Authentification error" );
    send_packet( NAK_buff, sp );
    del_state(sp);               /*    dispose_state(sp);*/
    return;
  }
  sp->mode.head_list = head;
  sp->option.no_KeepAlive = strcasecmp( params[3],"no") ? FALSE: TRUE;
  send_Registerd(sp);
  sp->state = WAIT;
  check_spool( sp->parent);                      /* Check spool file */
  send_Status(sp);
}

void
do_Thank( char * mess )
{
  StateP id;
  
  if ((id = get_id( mess )) == NULL ) { /* Invalid user. */
    warn_log("Invalid Thanks packet: THNQ %s\n", mess );
  } else {
    if( id->state < NOT_USED ){
      debug_log("    Thanks packet: %s [%ld]: %s\n",
		id->parent->name, (long)id, state_name[id->state]);
      id->state = ACKED;
    }
  }
}

void
do_Quit( char *mess )
{
  StateP id;
  
  if ((id = get_id( mess )) == NULL) { /* Invalid user. */
    warn_log("Invalid Quit packet: QUIT %s\n", mess );
  } else {
    char            buff_log[LOG_LEN];  /* Only for log. */
    sprintf(buff_log, "Quit packet: %s [%ld] will be deleted\n",
	    id->parent->name, (long)id);
    debug_log("    %s", buff_log);
    trace(buff_log);
    del_state(id);
  }
}

void
do_Update(mess)
char    *mess;
{
    /*
     * Value of mess is
     * packet = "UPDT user_ID"         format 1
     *          "UPDT 0 <user name>"   format 2
     */
    UserP   up;
    StateP  sp = 0L;                  /* for debug_log */

    if( *mess == '0' && *(mess + 1) == ' ' ){    /* format 2 */
      if(( up = find_user( mess + 2 )) == NULL ){
	warn_log("Invalid Update: Unknown User = %s\n", mess + 2 );
	return;
      }
    } else {                                     /* format 1 */
      if((sp = get_id(mess)) == NULL) {
	warn_log("Invalid Update: Non_ID=%s\n", mess );
	return;
      }
      up = sp->parent;
    }
    debug_log("    Update packet: %s [%ld]\n", up->name, (long)sp);
    check_spool(up);                      /* Check spool file */
    for (sp = up->stat; sp != NULL; sp = sp->next) {
      if( sp->state < NOT_USED )
	send_Status(sp);
    }
}

void parse_mess( char *mess, char *options, char *params[] )
{
  char *cptr, *messend;
  int  optlen;
  int  count;
  
  params[0] = mess;
  mess = get_param( mess );
  messend = mess + strlen( mess );
  for( count=1; *options; count++, options += optlen + 1 ){
    optlen = strlen( options );
    params[count] = "";
    for( cptr = mess; cptr <= messend - optlen; cptr++ ){
      if( strncmp( cptr, options, optlen ) == 0 ){
	if( *(cptr-1) == ' ' || *(cptr-1) == 0 ){
	  cptr += optlen;
	  get_param( cptr );
	  params[count] = cptr;
	  break;
	}
      }
    }
  }
}

char *get_param( char *mess )
{
  char *cptr;
  int  length;

  if(( cptr = index( mess, ' ' )) == NULL) {
    return mess+strlen(mess);
  }
  *cptr++ = 0;
  while( *cptr == ' ' ) cptr++;
  return cptr;
}

void
send_PREQ(sp, key)
StateP  sp;
char *key;
{
    char    buff[MESS_LEN + 1];

    sprintf(buff, "PREQ %ld", (long)sp );
    strcat( buff, key );
    send_packet(buff, sp);
}

void
send_Registerd(sp)
StateP  sp;
{
    char    buff[MESS_LEN + 1];

    sprintf(buff, "REGD %ld %d", (long)sp, CLIENT_TIME_OUT); 
    send_packet(buff, sp);
}

void
send_Status(sp)
StateP  sp;
{
    UserP   up;
    char    buff[MESS_LEN + 1];
    
    up = sp->parent;
#ifdef VER2_BC
    sprintf( buff, sp->option.ver2_user ? "S %d %d" : "STAT %d %d",
	    up->size, up->time );
    send_packet( buff, sp );
    return;
#endif    
    sprintf( buff, "STAT %d %d", up->size, up->time );
    send_packet(buff, sp);
}

void
send_Quit(reason)          /* send quit message and delete user/state */
char    *reason;
{
  StateP  sp;
  UserP   up;
  char    buff[MESS_LEN + 1];

#ifdef VER2_BC
  for (up = UserList.next; up != NULL; up = up->next) {
    for (sp = up->stat; sp != NULL; sp = sp->next) {
      sprintf( buff, sp->option.ver2_user ? "Q %s" : "QUIT %s", reason );
      send_packet(buff, sp);
    }
  }
  return;
#endif
  sprintf(buff, "QUIT %s", reason);
  for (up = UserList.next; up != NULL; up = up->next) {
    for (sp = up->stat; sp != NULL; sp = sp->next) {
      send_packet(buff, sp);
    }
  }
}
