/* userdata.c */
#include <windows.h>
#include <stdio.h>
#include "youbin.h"
#include "w_youbin.h"
#include "resource.h"

char s_user_name[USER_NAME_LEN + 1] = "";
char s_server_name[MAXHOSTNAMELEN + 1] ="localhost";
char s_password[16] = "";
int s_auth = AUTH_NONE;
int s_head_list_num = 0;
int s_dlg_check = 1;

void set_user_name(char *buf)
{
	strcpy(s_user_name, buf);
	return;
}

void set_server_name(char *buf)
{
	strcpy(s_server_name, buf);
	return;
}

void get_user_name(char *buf)
{
	strcpy(buf, s_user_name);
	return;
}

void get_server_name(char *buf)
{
	strcpy(buf, s_server_name);
	return;
}

void set_password(char *buf)
{
	strcpy(s_password, buf);
	return;
}

void get_password(char *buf)
{
	strcpy(buf, s_password);
	return;
}

void set_auth(int auth)
{
	s_auth = auth;
	return;
}

int check_auth()
{
	return s_auth;
}

void get_auth(char *buf)
{
	switch(s_auth)
	{
	case AUTH_NONE:
		sprintf(buf, "none");
		break;
	case AUTH_ROK:
		sprintf(buf, "rok");
		break;
	case AUTH_PLAIN:
		sprintf(buf, "plain");
		break;
	case AUTH_PGP:
		sprintf(buf, "pgp");
		break;
	default:
		sprintf(buf, "none");
	}
	return;
}

void set_head_list_num(int head)
{
	s_head_list_num = head;
}

int get_head_list_num()
{
	return s_head_list_num;
}

void reset_head_list()
{
	s_head_list_num = 0;
}

void set_head_list(int head)
{
	s_head_list_num |= (1 << head);
	return;
}

int check_head_list(int head)
{
	int i;
	i = 1 << head;
	if(i == (s_head_list_num & i)){
		return 1;
	}
	return 0;
}

void get_head_list(char *buf)
{
	if( check_head_list(HEAD_BODY) ){
		if(strcmp(buf, "")==0){
			strcat(buf, "Body");
		}else{
			strcat(buf, ",Body");
		}
	}
	if( check_head_list(HEAD_FROM) ){
		if(strcmp(buf, "")==0){
			strcat(buf, "From:");
		}else{
			strcat(buf, ",From:");
		}
	}
	if( check_head_list(HEAD_TO) ){
		if(strcmp(buf, "")==0){
			strcat(buf, "To:");
		}else{
			strcat(buf, ",To:");
		}
	}
	if( check_head_list(HEAD_SUBJECT) ){
		if(strcmp(buf, "")==0){
			strcat(buf, "Subject:");
		}else{
			strcat(buf, ",Subject:");
		}	}
	if( check_head_list(HEAD_CC) ){
		if(strcmp(buf, "")==0){
			strcat(buf, "cc:");
		}else{
			strcat(buf, ",cc:");
		}
	}
	if( check_head_list(HEAD_DATE) ){
		if(strcmp(buf, "")==0){
			strcat(buf, "Date:");
		}else{
			strcat(buf, ",Date:");
		}
	}
	return;
}

void set_dlg_check(int num)
{
	s_dlg_check = num;
}

int get_dlg_check()
{
	return s_dlg_check;
}
