
#include "imagebackg.h"

// sunsky, from 'A Practical Analytic Model For DayLight" by Preetham, Shirley & Smits.
// http://www.cs.utah.edu/vissim/papers/sunsky/
// based on the actual code by Brian Smits
// and a thread on gamedev.net on skycolor algorithms

using namespace std;

__BEGIN_YAFRAY

imageBackground_t::imageBackground_t(const char* fname, CFLOAT bri_adj):brightness_scale(bri_adj)
{
  img = new textureImage_t(fname);
  if (img->loadFailed()) {
    delete img;
    img = NULL;
  }
}

imageBackground_t::~imageBackground_t()
{
  if (img) delete img;
  img = NULL;
}

color_t imageBackground_t::operator() (const vector3d_t &dir,renderState_t &state) const
{
  if (!img) return color_t(0.0);
  PFLOAT u=0, v=0;
  spheremap(dir, u, v);
  return brightness_scale*img->getColor(point3d_t(u, v, 0));
}

background_t *imageBackground_t::factory(paramMap_t &params,renderEnvironment_t &render)
{
  string _filename;
  const string *filename=&_filename;
  CFLOAT pwr = 1.0;	// here just a brightness multiplier, same as for lights
  params.getParam("power", pwr);
  params.getParam("filename", filename);
  if (*filename=="") {
    cerr << "(background_image) Error,  No filename given\n";
    return NULL;
  }
  return new imageBackground_t(filename->c_str(), pwr);
}
__END_YAFRAY
