
/*
 * GLX Server Extension
 * Copyright (C) 1998, 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

#include "glx_swap.h"

void GLX_swapd_array(int length, double *data) {
   int i = 0;
   register int _n = 0;

   for (i = 0; i < length; i++) {
      swapd( (data+i), _n);
   }
}

void GLX_swapl_array(int length, GLuint *data) {
   int i = 0;
   register int _n = 0;

   for (i = 0; i < length; i++) {
      swapl( (data+i), _n);
   }
}

void GLX_swaps_array(int length, short *data) {
   int i = 0;
   register int _n = 0;

   for (i = 0; i < length; i++) {
      swaps( (data+i), _n);
   }
}

void GLX_swap_array(GLenum format, int length, void *data) {
   int format_size = GLX_data_size(format);

   switch (format_size) {
      case 4:
         GLX_swapl_array(length, (GLuint *) data);
         break;
      case 1:
         break;
      case 2:
         GLX_swaps_array(length, (short *) data);
         break;
      case 8:
         GLX_swapd_array(length, (double *) data);
         break;
   }
}
