/*
 * Functions for parsing a simple configuration file.
 * Copyright (C) 1999 Andreas Ehliar <ehliar@lysator.liu.se>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * ANDREAS EHLIAR, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef _GLX_CONFIG_H
#define _GLX_CONFIG_H

int glx_readconf(char *filename);
void glx_freeconfig(void);
char *glx_getvar(const char *varname);
int glx_getint(const char *varname);
char *glx_getvar_secure(const char *varname);
int glx_getint_secure(const char *varname);

#define CONFIG_NOERR 0 /* no error occured */
#define CONFIG_NOTREAD 1 /* The configuration file couldn't be opened */
#define CONFIG_FATAL 2 /* A fatal error occured while parsing the configuration file */

#endif


