#include "glx_symbols.h"

#include <dlfcn.h>
#include <stdio.h>

static pointer s3vMmioMem;
static void S3VPrintRegs( void ) {}


/* Hook up some empty storage to the glxsym struct for use in direct
 * mode.  
 *
 * Never used as there is no direct mode for this driver.
 */
void s3virgeInstallLocalSymbols( void )
{
   glxInstallLocalSVGASymbols();

   glxsym.s3vMmioMem = &s3vMmioMem;
   glxsym.S3VPrintRegs = &S3VPrintRegs;
}

static int any_error;
static void *my_dlsym(void *handle, const char *name)
{
   void *tmp = dlsym(handle, name);
   char *error;
   if ((error = dlerror()) != 0) {
      fputs(error, stderr);
      any_error = 1;
      return 0;
   }
   return tmp;
}

int s3virgeHookServerSymbols( void *handle )
{
   glxsym.s3vMmioMem = my_dlsym(handle, "s3vMmioMem");
   glxsym.S3VPrintRegs = my_dlsym(handle, "S3VPrintRegs");

   if (!any_error) 
      ErrorF("Sucessfully loaded s3virge driver\n");
   else
      ErrorF("S3virge driver disabled due to missing symbols\n");

   return !any_error;
}
