/*
 * GLX Hardware Device Driver for S3 ViRGE DX/GX/GX2
 * Copyright (C) 1999 Jim Duchek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Based on Mach64 driver: mach64dd.c
 *
 *    Jim Duchek <jimduchek@ou.edu>
 */

#include "s3virgeglx.h"
#include "glx_symbols.h"
#include "hw_buffer.h"

/***************************************
 * Mesa's Driver Functions
 ***************************************/


const GLubyte *s3virgeDDGetString( GLcontext *ctx, GLenum name )
{
    switch ( name )
    {
    case GL_VENDOR:
      	return "Utah GLX";
    case GL_RENDERER:
	return "GLX-S3ViRGE *** EARLY DEVELOPMENT ***";
    default:
	return 0;
    }
}


void s3virgeDDExtensionsInit( GLcontext *ctx )
{
    /* CVA only available for direct contexts.
     */
    if ( __glx_is_server ) {
	gl_extensions_disable( ctx, "GL_EXT_compiled_vertex_array" );
    }

    gl_extensions_disable( ctx, "GL_EXT_shared_texture_palette");
    gl_extensions_disable( ctx, "GL_EXT_paletted_texture");
    

   /* The ViRGE don't support a damned thing.... ;)
    */
    gl_extensions_disable( ctx, "GL_EXT_multitexture" );
    gl_extensions_disable( ctx, "GL_SGIS_multitexture" );
    gl_extensions_disable( ctx, "GL_ARB_multitexture" );
    gl_extensions_disable( ctx, "GL_EXT_point_parameters" );
    gl_extensions_disable( ctx, "ARB_imaging" );
    gl_extensions_disable( ctx, "GL_EXT_blend_minmax" );
    gl_extensions_disable( ctx, "GL_EXT_blend_logic_op" );
    gl_extensions_disable( ctx, "GL_EXT_blend_subtract" );
    gl_extensions_disable( ctx, "GL_INGR_blend_func_separate" );
}


static GLint s3virgeGetParameteri( const GLcontext *ctx, GLint param )
{
    switch ( param )
    {
    case DD_HAVE_HARDWARE_FOG:
	return 0; /* actually we have one but it doesn't work well. */
    default:
	s3virgeError( "s3virgeGetParameteri(): unknown parameter!\n" );
	return 0; /* Should I really return 0? */
    }
}


void s3virge_setup_DD_pointers( GLcontext *ctx )
{
    xsmesa_setup_DD_pointers( ctx );

    s3virgeError( "S3 Setting up pointers\n");
		
    s3virgeDDInitStatePointers( ctx );

    ctx->Driver.GetString = s3virgeDDGetString;
    ctx->Driver.UpdateState = s3virgeDDUpdateState;
    ctx->Driver.Clear = s3virgeClear;
    ctx->Driver.GetParameteri = s3virgeGetParameteri;

    ctx->Driver.TriangleCaps = 0;
    	/* ( DD_TRI_OFFSET ); */
    	 /* FIXME: not correct! */
	
	SetDriverBufferFunctions( ctx, s3virgeDmaFinish,
		s3virgeDB->backBuffer, s3virgeDB->pitch, s3virgeDB->height, CB_16BIT,
		s3virgeDB->depthBuffer, s3virgeDB->pitch, s3virgeDB->height, DB_16BIT );

    /* Also do the normal GL state-change checks. */
    s3virgeDDUpdateState( ctx );
}


/*
 * Local Variables:
 * mode: c
 * c-basic-offset: 4
 * End:
 */
