#include <stdlib.h>
#include <stdio.h>

#include "xsmesaP.h"
#include "mesaglx/types.h"
#include "vbrender.h"
#include "glx_log.h"


#include "mm.h"
#include "g200_mac.h"
#include "mgalib.h"
#include "mgadd.h"
#include "mgadirect.h"
#include "mgaglx.h"
#include "mgaclear.h"
#include "mgastate.h"
#include "hw_buffer.h"


/*
 * mgaClear
 * perform hardware accelerated clearing of the color and/or depth
 * buffer.  Software may still clear stencil buffers.
 * If all==GL_TRUE, clear whole buffer, else just clear region defined
 * by x,y,width,height
 */
#define MGA_CLEAR_COLOR 1
#define MGA_CLEAR_Z     2
#define MGA_CLEAR_ALL   MGA_CLEAR_COLOR|MGA_CLEAR_Z

GLbitfield mgaClear( GLcontext *ctx, GLbitfield mask, GLboolean all,
		     GLint x, GLint y, GLint width, GLint height ) 
{
	hwUI32	zval;
	DMALOCALS;
	hwUI32	cmd;
	
	hwMsg( 0, "mgaClear( %i, %i, %i, %i, %i )\n", mask, x, y, width, height );
	
	CHECK_CONTEXT(					\
		hwError("mgaDB is not valid in mgaClear().\n");	\
		return mask;					\
	);
	
	/* if we are software rendering, we must clear the buffer ourself.
	 * mesa doesn't handle it in the fallback.
	 */
	if ( !mgaDB->backBufferBlock ) {
		return FallbackBufferClear( ctx, mask, all, x, y, width, height );
	}

	if (all == GL_TRUE) {
		x = 0;
		y = 0;
		width = mgaDB->width;
		height = mgaDB->height;
	}
	
	if ( y + height > mgaDB->height ) {
		height = mgaDB->height - y;
	}
	if ( x + width > mgaDB->width ) {
		width = mgaDB->width - x;
	}
	if ( x < 0 ) {
		width += x;
		x = 0;
	}
	if ( y < 0 ) {
		height += y;
		y = 0;
	}
	if ( x >= mgaDB->width || y >= mgaDB->height || width < 1 || height < 1 ) {
		return 0;
	}

	
	/* make sure all triangles are flushed before we reprogram some regs */	
	mgaCtx->new_state |= MGA_NEW_CONTEXT;
	mgaDDUpdateHwState( ctx );
	
	/* flip top to bottom */
	y = mgaDB->height-y-height;
	
	MGADMAGETPTR( 32 );

	cmd = DC_opcod_trap | DC_arzero_enable | DC_sgnzero_enable | 
	  DC_shftzero_enable | (0xC << DC_bop_SHIFT) | DC_clipdis_enable | 
	  DC_solid_enable | DC_transc_enable;
	  
	/* use SGRAM block clears if possible */
	if ( mgaglx.nosgram || mgaDB->SystemMemory ) {
		cmd |= DC_atype_rstr;
	} else {
		cmd |= DC_atype_blk;
	}


	/* color buffer */
	if ( mask & GL_COLOR_BUFFER_BIT ) {
		int		r, g, b,a;

	hwMsg( 0, "color\n" );

		r = 255 * ctx->Color.ClearColor[0];
		g = 255 * ctx->Color.ClearColor[1];
		b = 255 * ctx->Color.ClearColor[2];
		a = 255 * ctx->Color.ClearColor[3];

		mask &= ~GL_COLOR_BUFFER_BIT;
	
		MGADMA_FCOL(mgaPackColor(r,g,b,a));
		MGADMA_YDSTLEN(y,height);
		MGADMA_FXBNDRY(x,x+width);
		MGADMA_DWGCTL_EXEC(cmd);
	}

	/* if depth mask is set, or we don't have a depth buffer,
	 * we don't need to clear it
	 */
	if ( !ctx->Depth.Mask || !mgaDB->depthBufferBlock ) {
		mask &= ~GL_DEPTH_BUFFER_BIT;
	}

	/* interleaved stencil , no depth */
	if( mgaDB->hasStencil && !(mask & GL_DEPTH_BUFFER_BIT) && (mask & GL_STENCIL_BUFFER_BIT))
	{
		hwUI32	maccess = mgaDB->Setup[MGA_SETUP_MACCESS];
		unsigned int i,j;
		hwUI32	writeMask;
		
	hwMsg( 0, "stencil\n" );
		cmd &= ~DC_solid_enable;
		cmd |= DC_linear_linear;
		writeMask = 0;
		if ( mask & GL_STENCIL_BUFFER_BIT ) {
			writeMask |= ( ctx->Stencil.WriteMask ) & 0xff;
			mask &= ~GL_STENCIL_BUFFER_BIT;
		}
		
		/* calculate what the entire 32 bit value would look like */
		// watch out for conversion precision!
		zval = ( ctx->Stencil.Clear & 0xff );

		j = 1;
		width *= 4;
		x*=4;
		while(width >= 4096)
		{
		  j++;
		  width /= 2;
		}
    	        DMAADVANCE();
		for(i = 0; i < height; i++)
		{
	          MGADMAGETPTR( 20 );
                /* however these are meant to work.. */
		  DMAOUTREG(MGAREG_SRC0,0x11111111);
		  DMAOUTREG(MGAREG_SRC1,0x11111111);
		  DMAOUTREG(MGAREG_SRC2,0x11111111);
		  DMAOUTREG(MGAREG_SRC3,0x11111111);
		  DMAOUTREG(MGAREG_DSTORG,mgaDB->Setup[MGA_SETUP_ZORG]+(mgaDB->pitch*(y+i)*4));
		  MGA_SET_FIELD(maccess,MA_pwidth_MASK,MA_pwidth_8);
		  DMAOUTREG(MGAREG_MACCESS,maccess);
		  MGADMA_FCOL(ctx->Stencil.Clear);
		  MGADMA_YDSTLEN(0,j);
		  MGADMA_FXBNDRY(x,x+width);
		  MGADMA_DWGCTL_EXEC(cmd);
		  DMAADVANCE();

		}
	}
	
        /* depth clear, no stencil clear.. */
	if( mgaDB->hasStencil && !(mask & GL_STENCIL_BUFFER_BIT) && (mask & GL_DEPTH_BUFFER_BIT))
	{
		hwUI32	maccess = mgaDB->Setup[MGA_SETUP_MACCESS];
		double	v;
		unsigned int i,j;
		hwUI32	writeMask;
		
		cmd &= ~DC_solid_enable;
		cmd |= DC_linear_linear;
		
		writeMask = 0;
		if ( mask & GL_DEPTH_BUFFER_BIT ) {
			writeMask |= 0xffffff00;
			mask &= ~GL_DEPTH_BUFFER_BIT;
		}
		
		v =  ctx->Depth.Clear * (double)0xffffffffu;
		zval = ( (hwUI32)v & ~0xff );

		j = 1;
		width *= 4;
		x*=4;
		while(width >= 4096)
		{
		  j++;
		  width /= 2;
		}

    	        DMAADVANCE();
                for(i = 0; i < height; i++)
		{
	          MGADMAGETPTR( 40 );
		  DMAOUTREG(MGAREG_SRC0,0x22222222);
		  DMAOUTREG(MGAREG_SRC1,0x22222222);
		  DMAOUTREG(MGAREG_SRC2,0x22222222);
		  DMAOUTREG(MGAREG_SRC3,0x22222222);
		  DMAOUTREG(MGAREG_DSTORG,mgaDB->Setup[MGA_SETUP_ZORG]+(mgaDB->pitch*(y+i)*4));
		  MGA_SET_FIELD(maccess,MA_pwidth_MASK,MA_pwidth_8);
		  DMAOUTREG(MGAREG_MACCESS,maccess);
		  MGADMA_FCOL(zval>>8);
		  MGADMA_YDSTLEN(0,j);
		  MGADMA_FXBNDRY(x,x+width);
		  MGADMA_DWGCTL_EXEC(cmd);

		  DMAOUTREG(MGAREG_SRC0,0x44444444);
		  DMAOUTREG(MGAREG_SRC1,0x44444444);
		  DMAOUTREG(MGAREG_SRC2,0x44444444);
		  DMAOUTREG(MGAREG_SRC3,0x44444444);
		  DMAOUTREG(MGAREG_DSTORG,mgaDB->Setup[MGA_SETUP_ZORG]+(mgaDB->pitch*(y+i)*4));
		  MGA_SET_FIELD(maccess,MA_pwidth_MASK,MA_pwidth_8);
		  DMAOUTREG(MGAREG_MACCESS,maccess);
		  MGADMA_FCOL(zval>>16);
		  MGADMA_YDSTLEN(0,j);
		  MGADMA_FXBNDRY(x,x+width);
		  MGADMA_DWGCTL_EXEC(cmd);

		  DMAOUTREG(MGAREG_SRC0,0x88888888);
		  DMAOUTREG(MGAREG_SRC1,0x88888888);
		  DMAOUTREG(MGAREG_SRC2,0x88888888);
		  DMAOUTREG(MGAREG_SRC3,0x88888888);
		  DMAOUTREG(MGAREG_DSTORG,mgaDB->Setup[MGA_SETUP_ZORG]+(mgaDB->pitch*(y+i)*4));
		  MGA_SET_FIELD(maccess,MA_pwidth_MASK,MA_pwidth_8);
		  DMAOUTREG(MGAREG_MACCESS,maccess);
		  MGADMA_FCOL(zval>>24);
		  MGADMA_YDSTLEN(0,j);
		  MGADMA_FXBNDRY(x,x+width);
		  MGADMA_DWGCTL_EXEC(cmd);
	          DMAADVANCE();

               }
	}
	
	if ( mgaDB->hasStencil && 
			(mask & ( GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT ) ) ) {
		hwUI32	maccess = mgaDB->Setup[MGA_SETUP_MACCESS];
		double	v;
		hwUI32	writeMask;
		
		writeMask = 0;
		if ( mask & GL_DEPTH_BUFFER_BIT ) {
			writeMask |= 0xffffff00;
			mask &= ~GL_DEPTH_BUFFER_BIT;
		}
		if ( mask & GL_STENCIL_BUFFER_BIT ) {
			writeMask |= ( ctx->Stencil.WriteMask ) & 0xff;
			mask &= ~GL_STENCIL_BUFFER_BIT;
		}
		
		/* calculate what the entire 32 bit value would look like */
		// watch out for conversion precision!
		v =  ctx->Depth.Clear * (double)0xffffffffu;
		zval = ( (hwUI32)v & ~0xff ) | ( ctx->Stencil.Clear & 0xff );

		DMAOUTREG(MGAREG_DSTORG,mgaDB->Setup[MGA_SETUP_ZORG]);
		MGA_SET_FIELD(maccess,MA_pwidth_MASK,MA_pwidth_32);
		DMAOUTREG(MGAREG_MACCESS,maccess);
		MGADMA_FCOL(zval);
		MGADMA_YDSTLEN(y,height);
		MGADMA_FXBNDRY(x,x+width);
		MGADMA_DWGCTL_EXEC(cmd);
	}

	/* depth buffer only */
	if ( mask & GL_DEPTH_BUFFER_BIT ) {
		hwUI32 maccess = mgaDB->Setup[MGA_SETUP_MACCESS];
		
		mask &= ~GL_DEPTH_BUFFER_BIT;

		DMAOUTREG(MGAREG_DSTORG,mgaDB->Setup[MGA_SETUP_ZORG]);
		
		if ( mgaDB->visual.DepthBits == 16 ) {
			MGA_SET_FIELD(maccess,MA_pwidth_MASK,MA_pwidth_16);
			zval = (hwUI32) (ctx->Depth.Clear * 0xffff);
		} else {
			double	v;
				
			MGA_SET_FIELD(maccess,MA_pwidth_MASK,MA_pwidth_32);
			// watch out for conversion precision!
			v =  ctx->Depth.Clear * (double)0xffffffffu;
			zval = (hwUI32)v;
		}	
		DMAOUTREG(MGAREG_MACCESS,maccess);
		MGADMA_FCOL(zval);
		MGADMA_YDSTLEN(y,height);
		MGADMA_FXBNDRY(x,x+width);
		MGADMA_DWGCTL_EXEC(cmd);
	}

	DMAADVANCE();

	/* we are NOT flushing the dma here.  if things are running smoothly,
	the only dma flush will be at swapbuffers time */

	/* restore DSTORG, MACCESS, DWGCTL, etc before drawing again */
	mgaCtx->new_state |= MGA_NEW_CONTEXT;

	hwMsg(10, "exiting mgaClear\n" );
	
	return mask;
}


