/*
 * GLX Hardware Device Driver for Intel i810
 * Copyright (C) 1999 Keith Whitwell
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * KEITH WHITWELL, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

/* $Id: i810context.c,v 1.4 2000/02/29 10:40:30 giles Exp $ */

#include <stdlib.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <GL/gl.h>

#include "xsmesaP.h"

#include "i810context.h"
#include "i810lib.h"
#include "i810log.h"
#include "i810dd.h"
#include "i810pipeline.h"
/*  #include "i810render.h" */
#include "i810state.h"
#include "i810tris.h"
#include "simple_list.h"



i810ContextPtr i810CreateContext(GLcontext *ctx)
{
   i810ContextPtr c;

   c = (i810ContextPtr) calloc(1,sizeof(i810Context));
   if (!c)
      return NULL;

   c->gl_ctx = ctx;

   c->renderindex = -1;		/* impossible value */
   c->new_state = ~0;
   c->reg_dirty = ~0;

   make_empty_list(&c->SwappedOut);
   make_empty_list(&c->TexObjList);
   
   c->TextureMode = ctx->Texture.Unit[0].EnvMode;

   c->CurrentTex0Obj = 0;
   c->CurrentTex1Obj = 0;
   ctx->Shared->DefaultD[2][0].DriverData = 0;

   if (ctx->VB) 
      i810DDRegisterVB( ctx->VB );

   if (ctx->NrPipelineStages)
      ctx->NrPipelineStages =
	 i810DDRegisterPipelineStages(ctx->PipelineStage,
				      ctx->PipelineStage,
				      ctx->NrPipelineStages);

   
   /* Ask mesa to clip fog coordinates for us.
    */
   ctx->TriangleCaps |= DD_CLIP_FOG_COORD;


#if 0
   ctx->Driver.BuildPrecalcPipeline = i810DDBuildPrecalcPipeline;

   i810DDRenderInit();
   i810DDFastPathInit();
#endif


   i810DDTrifuncInit();
   i810DDSetupInit();
   i810DDExtensionsInit( ctx );
   i810DDInitState( c );

   if (MESA_VERBOSE&VERBOSE_DRIVER)
      fprintf(stderr,"i810CreateContext(): successful.\n");

   return c;
}

int i810DestroyContext(i810ContextPtr ctx)
{
   i810TextureObjectPtr next_t, t;

   if (!ctx)
      return 0;

   if (--(ctx->refcount) > 0)
      return 0;

   foreach_s (t, next_t, &(ctx->TexObjList))
      i810DestroyTexObj(ctx, t);

   foreach_s (t, next_t, &(ctx->SwappedOut))
      i810DestroyTexObj(ctx, t);

   if ( ctx == i810Ctx ) 
      i810Ctx = 0;

   free(ctx);

   if (MESA_VERBOSE&VERBOSE_DRIVER)
      fprintf(stderr,"i810DestroyContext(): successfully destroyed.\n");

   return 0;
}
