# Changes

## 2.4

### Breaking changes

- `use-package` no longer requires `diminish` as a dependency, allowing people
  to decide whether they want to use diminish or delight. This means that if
  you do use diminish, you'll now need to pull it into your configuration
  before any use of the `:diminish` kewyord. For example:

  ``` elisp
      (use-package diminish :ensure t)
  ```

- Emacs 24.3 or higher is now a requirement.

- The `:defer-install` keyword has been removed. It may reappear as an add-on
  module for use-package in a future release. See issue #442 for more details.

- There is no longer a `use-package-debug` option, since `use-package-verbose`
  already has the possible value of `debug`.

- The ordering of several elements of `use-package-keywords` have changed; if
  you had previously customized this (or were an extension author adding to
  this list), you may need to rework your changes.

- For extension authors, `:commands` should no longer be propagated down for
  autoloading. See more below.

### Other changes

- Upgrade license to GPL 3.

- If `use-package-verbose` is set to the symbol `debug`, any evaluation errors
  during package configuration will cause a complete report to be written to a
  `*use-package*` buffer, including: the text of the error, the `use-package`
  declaration that caused the error, the post-normalized form of this
  declaration, and the macro-expanded version (without verbosity-related
  code). Note that this still does not help if there are parsing errors, which
  cause Emacs to register a Lisp error at startup time.

- New customization variable `use-package-deferring-keywords`, mainly intended
  for use by extension packages, indicates keywords that, if used without
  `:demand`, cause deferred loading (as if `:defer t` had been specified).

- The `:ensure` keyword now accepts a specific pinning sub-keyword. For
  example:

  ``` elisp
  (use-package foo
    :pin "elpa")
  ```

  This ensure the package `foo` is installed from `"elpa"`.

  ``` elisp
  (use-package foo
    :ensure bar
    :ensure (quux :pin "melpa"))
  ```

  This says that `foo` ensures that `bar` is installed, as well as `quux` from
  `"melpa"`. It does *not* ensure that `foo` is installed, because explicit
  `:ensure` keywords were given.

- New `:hook` keyword.

- New `:catch` keyword. If `t` or `nil`, it enables (the default, see
  `use-package-defaults`) or disables catching errors at load time in
  use-package expansions. It can also be a function taking two arguments: the
  keyword being processed at the time the error was encountered, and the error
  object (as generated by `condition-case`).

- New keywords `:custom (foo1 bar1) (foo2 bar2)` etc., and `:custom-face`.

  NOTE: These are only for people who wish to keep customizations with their
  accompanying use-package declarations. Functionally, the only benefit over
  using `setq` in a `:config` block is that customizations might execute code
  when values are assigned. If you currently use `M-x customize-option` and
  save to a settings file, you do not want to use this option.

- New `:magic` and `:magic-fallback` keywords.

- New `:defer-install` keyword.

- New customization variable `use-package-enable-imenu-support`.

- New customization variable `use-package-hook-name-suffix`. Any symbols named
  in `:hook`, or in the CAR of cons cells passed to `:hook`, have this text
  appended to them as a convenience. If you find yourself using this keyword
  to add to hooks of different names, or just don't want such appending done,
  you can change the text to an empty string.

- New customization variable `use-package-compute-statistics`, and an
  accompanying command `M-x use-package-report`. See the README for more
  details.

- Allow `:diminish` to take no arguments.

- Support multiple symbols passed to `:after`, and a mini-DSL using `:all` and
  `:any`.

- `:mode` and `:interpreter` can now accept `(rx ...)` forms.

- Using `:load-path` without also using `:ensure` now implies `:ensure nil`.

- `:bind (:map foo-map ...)` now defers binding in the map until the package
  has been loaded.

- Print key bindings for keymaps in `describe-personal-keybindings`.

- When `use-package-inject-hooks` is non-nil, always fire `:init` and
  `:config` hooks.

- Documentation added for the `:after`, `:defer-install`, `:delight`,
  `:requires`, `:when` and `:unless` keywords.

- `:requires SYM` is subtly different from `:if (featurep SYM)`, in that it
  happens before the `:preface`. This means that using `:requires` will cause
  definitions in the `:preface` to not be visible to the byte-compiler,
  leading to possible warnings about unknown functions, or functions that may
  not be available at run-time (which can generally be ignored, since
  `:requires` is intended as a check for basic system functionality; `:after`
  should be used to check for the presence of other modules).

- New undocumented (and currently experimental) keyword `:load` may be used to
  change the name of the actual package loaded, rather than the package name,
  and may even add other names. For example: `(use-package auctex :load
  tex-site)`. This keyword is used internally to generate the `require` for a
  package, so that deferral is simply a matter of not generating this keyword.

- The source code is now broken into several files, so that certain optional
  features (diminish, delight, ensure) may be maintained separately from the
  core functionality.

- When using the `:after` keyword, now even autoloadeds keybinding are
  deferred until after that other package has loaded, in order to allow
  convenient `:bind` to maps only present in that other package. Consider the
  following:

  ``` elisp
  (use-package helm-descbinds
    :load-path "site-lisp/helm-descbinds"
    :after helm
    :bind ("C-h b" . helm-descbinds)
    :init
    (fset 'describe-bindings 'helm-descbinds))
  ```

  The binding of `C-h b` here will not occur until helm is loaded; and after
  it is loaded, `helm-descbinds` itself is not loaded until the user presses
  `C-h b`.

- For extension authors, if you add a keyword to `use-package-keywords` whose
  presence should indicate deferred loading, please also add it to
  `use-package-deferring-keywords`. Note that this is a bit of a sledgehammer,
  in that the mere presence of these keywords implies deferred loading. For a
  more subtle approach, see the new `use-package-autoloads/<KEYWORD>` support
  mentioned in the next bullet.

- For extension authors, if you wish deferred loading to possibly occur,
  create functions named `use-package-autoloads/<KEYWORD>` for each keyword
  that you define, returning an alist of the form `(SYMBOL . TYPE)` of symbols
  to be autoloaded. `SYMBOL` should be an interactive function, and `TYPE` the
  smybol `command`, but this functionality may be extended in future. These
  autoloads are established if deferred loading is to happen.

- If you specify a lambda form rather than a function symbol in any of the
  constructs that *might* introduce autoloads: `:bind`, `:bind*`,
  `:interpreter`, `:mode`, `:magic`, `:magic-fallback`, and `:hook`: then
  deferred loading will no longer be implied, since there's nothing to
  associate an autoload with that could later load the module. In these cases,
  it will be as if you'd specified `:demand t`, in order to ensure the lambda
  form is able to execute in the context of the loaded package.

- For extension authors, there is a new customization variable
  `use-package-merge-key-alist` that specifies how values passed to multiple
  occurences of the same key should be merged into a single value, during
  normalization of the `use-package` declaration into a proper plist. The
  default behavior is to simply append the values together (since they are
  always normalized to lists).

### Bug fixes

- Repeating a bind no longer causes duplicates in personal-keybindings.
- When byte-compiling, correctly output declare-function directives.
- Append to *use-package* when debugging, don't clear it.
- Don't allow :commands, :bind, etc., to be given an empty list.
- Explicit :defer t should override use-package-always-demand.
