/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <stdlib.h>
#include <string.h>

#include "labels.h"

static Label *labels = NULL;

void LABELS_add(Label *l)
{
	l->next=labels;
	labels=l;
}

Label *LABELS_new(char *name, SourceLine *pos)
{
	Label *i;
	i = (Label *) malloc(sizeof(Label));
	i->name=strdup(name);
	i->pos=pos;
	i->next=NULL;
	LABELS_add(i);
	return i;
}
	
Label *LABELS_find(char *name)
{
	Label *i;
	for (i=labels; i; i=i->next)
		if (!strcmp(i->name,name))
			return i;
	//return LABELS_new(name);
	return NULL;
}

char *LABELS_name(Label *l)
{
	return l->name;
}

SourceLine *LABELS_source_line(Label *l)
{	return l->pos; }

