/* ========================================================================== */
/* === umfpack_timer ======================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

double umfpack_timer ( void ) ;

/*
Syntax (for both int and long versions):

    #include "umfpack.h"
    double t ;
    t = umfpack_timer ( ) ;

Purpose:

    Returns the CPU time used by the process.  Includes both "user" and "system"
    time (the latter is time spent by the system on behalf of the process, and
    is thus charged to the process).

    This routine uses the Unix getrusage ( ) routine, if available.  It is not
    subject to overflow.  If getrusage ( ) is not available, the portable ANSI
    C clock ( ) routine is used instead.  Unfortunately, clock ( ) overflows
    if the CPU time exceeds 2147 seconds (about 36 minutes) when
    sizeof (clock_t) is 4 bytes.  If you have getrusage ( ), be sure to compile
    UMFPACK with the -DGETRUSAGE flag set; see umf_config.h and the User Guide
    for details.

Arguments:

    None.
*/

