/* ========================================================================== */
/* === UMFPACK_defaults ===================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/*
    User-callable.  Sets default control parameters.
    See UMFPACK_defaults.h for details.
*/

#include "umf_internal.h"

GLOBAL void UMFPACK_defaults
(
    double Control [UMFPACK_CONTROL]
)
{
    Int i ;

    if (!Control)
    {
	/* silently return if no Control array */
	return ;
    }

    for (i = 0 ; i < UMFPACK_CONTROL ; i++)
    {
	Control [i] = 0 ;
    }

    /* ---------------------------------------------------------------------- */
    /* default control settings: can be modified at run-time */
    /* ---------------------------------------------------------------------- */

    /* used in UMFPACK_report_* routines: */
    Control [UMFPACK_PRL] = UMFPACK_DEFAULT_PRL ;

    /* used in UMFPACK_*symbolic: */
    Control [UMFPACK_DENSE_ROW] = UMFPACK_DEFAULT_DENSE_ROW ;
    Control [UMFPACK_DENSE_COL] = UMFPACK_DEFAULT_DENSE_COL ;

    /* used in UMFPACK_numeric: */
    Control [UMFPACK_PIVOT_TOLERANCE] = UMFPACK_DEFAULT_PIVOT_TOLERANCE ;
    Control [UMFPACK_BLOCK_SIZE] = UMFPACK_DEFAULT_BLOCK_SIZE ;
    Control [UMFPACK_RELAXED_AMALGAMATION] = UMFPACK_DEFAULT_RELAXED_AMALGAMATION ;
    Control [UMFPACK_RELAXED2_AMALGAMATION] = UMFPACK_DEFAULT_RELAXED2_AMALGAMATION ;
    Control [UMFPACK_RELAXED3_AMALGAMATION] = UMFPACK_DEFAULT_RELAXED3_AMALGAMATION ;
    Control [UMFPACK_ALLOC_INIT] = UMFPACK_DEFAULT_ALLOC_INIT ;
    Control [UMFPACK_PIVOT_OPTION] = UMFPACK_DEFAULT_PIVOT_OPTION ;

    /* used in UMFPACK_*solve: */
    Control [UMFPACK_IRSTEP] = UMFPACK_DEFAULT_IRSTEP ;

    /* ---------------------------------------------------------------------- */
    /* compile-time settings: cannot be modified at run-time */
    /* ---------------------------------------------------------------------- */

#ifndef NBLAS
    /* use externally-provided BLAS (only dgemm, dger, and dgemv) */
    Control [UMFPACK_COMPILED_WITH_BLAS] = 1 ;
#else
    /* do not use the BLAS - use in-line C code instead */
    Control [UMFPACK_COMPILED_WITH_BLAS] = 0 ;
#endif

#ifdef MATLAB_MEX_FILE
    /* use mxMalloc, mxFree, mxRealloc, and mexPrintf */
    /* use mxAssert if debugging is enabled */
    Control [UMFPACK_COMPILED_FOR_MATLAB] = 1 ;
#else
#ifdef MATHWORKS
    /* use internal utMalloc, utFree, utRealloc, and utPrintf routines. */
    /* use assert if debugging is enabled */
    Control [UMFPACK_COMPILED_FOR_MATLAB] = 2 ;
#else
    /* use ANSI C malloc, free, realloc, and print */
    /* use ANSI C assert if debugging is enabled */
    Control [UMFPACK_COMPILED_FOR_MATLAB] = 0 ;
#endif
#endif

#ifdef GETRUSAGE
    /* uses the non-standard getrusage to get CPU time (Solaris) */
    Control [UMFPACK_COMPILED_WITH_GETRUSAGE] = 1 ;
#else
    /* uses the ANSI standard clock routine to get CPU time */
    /* this may wrap around */
    Control [UMFPACK_COMPILED_WITH_GETRUSAGE] = 0 ;
#endif

#ifndef NDEBUG
    /* UMFPACK is compiled in debug mode */
    PRINTF (("UMFPACK is running in debug mode.  This is very slow!\n")) ;
    Control [UMFPACK_COMPILED_IN_DEBUG_MODE] = 1 ;
#else
    /* all printing disabled, including error messages */
    Control [UMFPACK_COMPILED_IN_DEBUG_MODE] = 0 ;
#endif

}

