/* ========================================================================== */
/* === UMF_mem_alloc_head_block ============================================= */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/* The UMF_mem_* routines manage the Numeric->Memory memory space. */

/* allocate n units from head of Numeric->Memory.  No header allocated. */
/* Returns the index into Numeric->Memory if successful, or 0 on failure. */

#include "umf_internal.h"

GLOBAL Int UMF_mem_alloc_head_block
(
    NumericType *Numeric,
    Int n
)
{
    Int p, usage ;
    DEBUG2 (("GET  BLOCK: from head, size "ID" ", n)) ;

    ASSERT (Numeric) ;
    ASSERT (Numeric->Memory) ;

    if (n > (Numeric->itail - Numeric->ihead))
    {
	DEBUG2 ((" failed\n")) ;
	return (0) ;
    }

    /* return p as an offset from Numeric->Memory */
    p = Numeric->ihead ;
    Numeric->ihead += n ;

    DEBUG2 ((ID"\n", p)) ;
    usage = Numeric->ihead + Numeric->tail_usage ;
    Numeric->max_usage = MAX (Numeric->max_usage, usage) ;
    return (p) ;
}

