/* Glyphs.

   Copyright (C) 2000 Daiki Ueno <ueno@unixuser.org>

   Author: Daiki Ueno <ueno@unixuser.org>
   Created: 2000-05-16

   This file is part of UltraPoint.

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)  
   any later version.                                                   

   This program is distributed in the hope that it will be useful,      
   but WITHOUT ANY WARRANTY; without even the implied warranty of       
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the        
   GNU General Public License for more details.                         

   You should have received a copy of the GNU General Public License    
   along with GNU Emacs; see the file COPYING.  If not, write to the    
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
   Boston, MA 02111-1307, USA.                                          

*/

#include "glyph.h"

static void glyph_free (UptGlyph *glyph);

UptGlue *
upt_glue_new (linewrap_cost, expand_cost, contract_cost,
	      min_width, max_width)
     gint linewrap_cost, expand_cost, contract_cost;
     gdouble min_width, max_width;
{
  UptGlue *glue;

  glue = g_new0 (UptGlue, 1);
  g_assert (glue != NULL);

  glue->linewrap_cost = linewrap_cost;;
  glue->expand_cost = expand_cost;
  glue->contract_cost = contract_cost;
  glue->min_width = min_width;
  glue->max_width = max_width;
  glue->free = g_free;

  return glue;
}

static void
glyph_free (glyph)
     UptGlyph *glyph;
{
  if (glyph->bm)
    VF_FreeBitmap (glyph->bm);
  if (glyph->right_glue)
    upt_object_unref (glyph->right_glue);
  if (glyph->font)
    upt_object_unref (glyph->font);
  g_free (glyph);
}

UptGlyph *
upt_glyph_new (font, codepoint)
     UptFont *font;
     glong codepoint;
{
  UptGlyph *glyph;

  glyph = g_new0 (UptGlyph, 1);
  g_assert (glyph != NULL);

  glyph->font = font;
  upt_object_ref (font);

  glyph->codepoint = codepoint;
  glyph->free = (GFreeFunc)glyph_free;

  return glyph;
}

void
upt_glyph_instantiate (glyph)
     UptGlyph *glyph;
{
  if (!glyph->bm)
    glyph->bm = VF_GetBitmap2 (glyph->font->id, glyph->codepoint, 1, 1);
  g_assert (glyph->bm != NULL);
}
