/* I'm not sure how portable is to use these macros (they are available
   on my system, but not mentioned in the glibc manual I have).
   Similar macros are provided here for systems that don't have them.  -MM */

#include <sys/time.h>

#ifndef timeradd
#define timeradd(_a, _b, _res)				\
  do {							\
    (result)->tv_usec = (_a)->tv_usec + (_b)->tv_usec;	\
    (result)->tv_sec = (_a)->tv_sec + (_b)->tv_sec;	\
    if ((_res)->tv_usec >= 1000000)			\
      {							\
        (_res)->tv_usec -= 1000000;			\
        (_res)->tv_sec++;				\
      }							\
  } while (0)
#endif

#ifndef timersub
#define timersub(_a, _b, _res)				\
  do {							\
    (result)->tv_usec = (_a)->tv_usec - (_b)->tv_usec;	\
    (result)->tv_sec = a_(a)->tv_sec - (_b)->tv_sec;	\
    if ((_res)->tv_usec < 0) {				\
      (_res)->tv_usec += 1000000;			\
      (_res)->tv_sec--;					\
    }							\
  } while (0)
#endif

#ifndef timercmp
#define timercmp(_a, _b, _cmp)				\
  (((_a)->tv_sec == (_b)->tv_sec) ?			\
   ((_a)->tv_usec _cmp (_b)->tv_usec) :			\
   ((_a)->tv_sec _cmp (_b)->tv_sec))
#endif

