/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.caseditor.ui.property;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FileElementFilter extends ViewerFilter {

  @Override
  public boolean select(Viewer viewer, Object parentElement, Object element) {

    if (element instanceof IFile) {
      return true;
    }
    else if (element instanceof IFolder) {
      try {
        return containsFile((IFolder) element);
      } catch (CoreException e) {
        return false;
      }
    }

    return false;
  }

  /**
   * Checks if the given folder contains an {@link IFile} or one
   * of its subfolders.
   */
  private boolean containsFile(IFolder folder) throws CoreException {

    for (IResource resource : folder.members()) {
      if (resource instanceof IFile) {
        return true;
      }
      else if (resource instanceof IFolder) {
        return containsFile((IFolder) resource);
      }
    }

    return false;
  }
}
