/*

 Copyright (c) 2003,2004,2005 uim Project http://uim.freedesktop.org/

 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. Neither the name of authors nor the names of its contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

*/
#ifndef _QUIM_HELPER_TOOLBAR_H_
#define _QUIM_HELPER_TOOLBAR_H_

#include <qhbox.h>
#include <qevent.h>
#include <qpopupmenu.h>
#include <qpixmap.h>

class QUimHelperToolbar : public QHBox
{
    Q_OBJECT

public:
    QUimHelperToolbar( QWidget *parent = 0, const char *name = 0, WFlags f = 0 );
    ~QUimHelperToolbar();


protected:
    // right click
    virtual void contextMenuEvent ( QContextMenuEvent * e );

protected:
    void addExecImSwitcherButton();
    void addExecPrefButton();
    void addExecDictButton();
    void addExecInputPadButton();
    void addExecHandwritingInputPadButton();
    void addExecHelpButton();    

    
protected slots:
    void slotExecImSwitcher();
    void slotExecPref();
    void slotExecDict();
    void slotExecInputPad();
    void slotExecHandwritingInputPad();
    void slotExecHelp();    

signals:
    void quitToolbar();

protected:
    QPixmap m_swicon;
    QPixmap m_preficon;
    QPopupMenu *m_contextMenu;
};


#endif
