/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef UDAV_H
#define UDAV_H
//-----------------------------------------------------------------------------
#include <qmainwindow.h>
//-----------------------------------------------------------------------------
#ifndef UDAV_VERSION
#define UDAV_VERSION	5.2
#endif

#ifndef WIN32
#define USE_HDF5	// Enable HDF "projects"
#endif

#ifndef MGL_DOC_DIR
#ifdef WIN32
#define MGL_DOC_DIR ""
#else
#define MGL_DOC_DIR "/usr/local/share/doc/udav/"
#endif
#endif
//-----------------------------------------------------------------------------
class QTextEdit;
class QFont;
class QSplitter;
class QScrollArea;
class QMGLCanvas;
class FindDialog;
class OptionDialog;
class StyleDialog;
class QMenu;
class QSpinBox;
class QTimer;
class QPopupMenu;
class AnimParam;
class QTableWidget;
class SetupDialog;
class QTabWidget;
class InfoDialog;
class HintDialog;
//-----------------------------------------------------------------------------
extern int MaxRecentFiles;
extern int animDelay;
//-----------------------------------------------------------------------------
class ScriptWindow: public QMainWindow
{
Q_OBJECT
public:
	ScriptWindow(QWidget *wp=0);
	~ScriptWindow();
	void load(const QString &fileName, bool noNewWnd=false);
	void writeSettings();

public slots:
	void refresh();		///< refresh list of variables
	void setEditorFont(QFont *f=0);
	void setMGLFont(QString path);
	void setEditPos(bool bottom);
	void editPosChanged();

signals:
	void gotoLine(int n,int i);

protected:
	void closeEvent ( QCloseEvent* );

private slots:
	void newDoc();
	void choose();
	void save();
	void saveAs();
	void printText();
	void printPlot();
	void find();
	void about();
	void aboutQt();
	void openRecentFile();
	bool findText(const QString &str="", bool cs=false, bool fw=true);
	void replText(const QString &str, const QString &txt, bool cs=false, bool fw=true);
	void showHelp();
	void addOptions();
	void addStyle();
	void nextSlide();
	void prevSlide();
	void animStart(bool st);
	void animSetup();
	void addSetup();
	void animPutText(const QString &);

	void newTable();
	void editData(int n=-1);
	void infoData();
	void delAllData();
	void delData();
	void messClicked();
	void tableClicked(int row, int col);
	void properties();
	void setAsterix();
	void setCursorPosition(int,int);
	void pressF5();

	void adjust();
	void warnChanged();

private:
	static int num_wnd;
	bool gifOn, jpgOn;
	QString gifName;
	QMGLCanvas *mgl;
	QScrollArea* sv;
	QSplitter *split, *splitG;
	QPrinter *printer;
	QTextEdit *edit;
	QTextEdit *mess;	///< messages and warnings
	QString filename;
	FindDialog *findDialog;
	OptionDialog *optDialog;
	StyleDialog *stlDialog;
	QMenu *fileMenu;
	QSpinBox *tet, *phi;
	// animation
	QString animParam;
	int animPos;
	QTimer *timer;
	AnimParam *animDialog;
	QMenu *popup;
	QTableWidget *tab;
	SetupDialog *setupDlg;
	QTabWidget *info;
	QAction *ainfo;
	InfoDialog *infoDlg;	///< Data preview and information

	void updateRecentFileItems();
	void updateRecent();
	void setCurrentFile(const QString &fileName);
	void makeMenu();
	void readSettings();
	void animParseText();
	QTabWidget *setupInfo(QWidget *par);
	void saveHDF5(const QString &fileName);
	void loadHDF5(const QString &fileName);
};
//-----------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------
