//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 1994
// 
// Migrate.cc -- Test migrating of tasks among clusters.
// 
// Author           : Peter Buhr
// Created On       : Tue Jun 28 10:23:11 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Jul 31 17:24:16 2005
// Update Count     : 34
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::endl;

unsigned int uDefaultPreemption() {
    return 1;
} // uDefaultPreemption

_Task dummy {
    uCluster &c1, &c2, &c3;

    void main() {
	const int NoOfTimes = 10000;

        for ( int i = 0; i < NoOfTimes; i += 1 ) {
	    migrate( c3 );
	    migrate( c2 );
	    migrate( c1 );
        } // for
    } // dummy::main
  public:
    dummy( uCluster &c1, uCluster &c2, uCluster &c3 ) : uBaseTask( c1 ), c1( c1 ), c2( c2 ), c3( c3 ) {
    } // dummy::dummy
}; // dummy

uCluster c1;
uProcessor p1(c1);

uCluster c2;
uProcessor p2(c2);

void uMain::main() {
    {
	dummy d1( uThisCluster(), c1, c2 ), d2( c2, uThisCluster(), c1 ), d3( c1, c2, uThisCluster() );
    }
    cout << "successful completion" << endl;
} // uMain::main

// Local Variables: //
// compile-command: "u++ Migrate.cc" //
// End: //
