//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uOStream.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:55:15 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Sep  9 20:04:48 2003
// Update Count     : 46
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_OSTREAM_H__
#define __U_OSTREAM_H__


#include <uFilebuf.h>
#include <uIos.h>

#pragma __U_NOT_USER_CODE__


class uOStream;						// forward

uOStream &endl( uOStream &os );
uOStream &ends( uOStream &os );
uOStream &flush( uOStream &os );

uOStream &boolalpha( uOStream &os );
uOStream &noboolalpha( uOStream &os );
uOStream &showbase( uOStream &os );
uOStream &noshowbase( uOStream &os );
uOStream &showpoint( uOStream &os );
uOStream &noshowpoint( uOStream &os );
uOStream &showpos( uOStream &os );
uOStream &noshowpos( uOStream &os );
uOStream &skipws( uOStream &os );
uOStream &noskipws( uOStream &os );
uOStream &uppercase( uOStream &os );
uOStream &nouppercase( uOStream &os );
uOStream &unitbuf( uOStream &os );
uOStream &nounitbuf( uOStream &os );

uOStream &internal( uOStream &os );
uOStream &left( uOStream &os );
uOStream &right( uOStream &os );

uOStream &dec( uOStream &os );
uOStream &hex( uOStream &os );
uOStream &oct( uOStream &os );

uOStream &fixed( uOStream &os );
uOStream &scientific( uOStream &os );

uOStream &uAcquire( uOStream &os );
uOStream &uRelease( uOStream &os );

uOStream &operator << ( uOStream &os, char c );
uOStream &operator << ( uOStream &os, signed char c );
uOStream &operator << ( uOStream &os, unsigned char c );
uOStream &operator << ( uOStream &os, const char *s );
uOStream &operator << ( uOStream &os, const signed char *s );
uOStream &operator << ( uOStream &os, const unsigned char *s );


class uOStream : public uIos {
    friend uOStream &endl( uOStream &os );
    friend uOStream &ends( uOStream &os );
    friend uOStream &flush( uOStream &os );
    friend uOStream &boolalpha( uOStream &os );
    friend uOStream &noboolalpha( uOStream &os );
    friend uOStream &showbase( uOStream &os );
    friend uOStream &noshowbase( uOStream &os );
    friend uOStream &showpoint( uOStream &os );
    friend uOStream &noshowpoint( uOStream &os );
    friend uOStream &showpos( uOStream &os );
    friend uOStream &noshowpos( uOStream &os );
    friend uOStream &skipws( uOStream &os );
    friend uOStream &noskipws( uOStream &os );
    friend uOStream &uppercase( uOStream &os );
    friend uOStream &nouppercase( uOStream &os );
    friend uOStream &unitbuf( uOStream &os );
    friend uOStream &nounitbuf( uOStream &os );
    friend uOStream &internal( uOStream &os );
    friend uOStream &left( uOStream &os );
    friend uOStream &right( uOStream &os );
    friend uOStream &dec( uOStream &os );
    friend uOStream &hex( uOStream &os );
    friend uOStream &oct( uOStream &os );
    friend uOStream &fixed( uOStream &os );
    friend uOStream &scientific( uOStream &os );
    friend uOStream &uAcquire( uOStream &os );
    friend uOStream &uRelease( uOStream &os );

    friend uOStream &operator << ( uOStream &os, char c );
    friend uOStream &operator << ( uOStream &os, signed char c );
    friend uOStream &operator << ( uOStream &os, unsigned char c );
    friend uOStream &operator << ( uOStream &os, const char *s );
    friend uOStream &operator << ( uOStream &os, const signed char *s );
    friend uOStream &operator << ( uOStream &os, const unsigned char *s );

    uOStream( uOStream & );				// no copy
    uOStream &operator=( uOStream & );			// no assignment
  private:
    // Could not use public inheritance because of mutual exclusion problems
    // and cascading (contra-variance).

    std::ostream ofile;
  protected:
    int deletebuf;					// should the buffer be deleted on termination ?
  public:
    uOStream();
    uOStream( std::streambuf *buf );
    virtual ~uOStream();

    uOStream &put( std::streambuf::char_type c );
    uOStream &write( const std::streambuf::char_type *s, std::streamsize n );
    uOStream &flush();
    std::streambuf::pos_type tellp();
    uOStream &seekp( std::streambuf::pos_type );
    uOStream &seekp( std::streambuf::off_type off, std::ios_base::seekdir dir );

    uOStream &operator << ( uOStream &( *f )( uOStream & ) );
    uOStream &operator << ( bool n);
    uOStream &operator << ( short n );
    uOStream &operator << ( unsigned short n );
    uOStream &operator << ( int n );
    uOStream &operator << ( unsigned int n );
    uOStream &operator << ( long n );
    uOStream &operator << ( unsigned long n );
    uOStream &operator << ( float n );
    uOStream &operator << ( double n );
    uOStream &operator << ( long double n );
    uOStream &operator << ( const void *p );
    uOStream &operator << ( long long n );
    uOStream &operator << ( unsigned long long n );

    std::ostream &stream();
}; // uOStream


//######################### uOStreamModule #########################


class uOStreamModule {
  public:
    static uFilebuf *uCoutFilebuf;
    static uOStream *uCoutStream;
    static uFilebuf *uCerrFilebuf;
    static uOStream *uCerrStream;
    static uFilebuf *uClogFilebuf;
    static uOStream *uClogStream;			// buffered errors
}; // uOStreamModule


#define uCout (*uOStreamModule::uCoutStream)
#define uCerr (*uOStreamModule::uCerrStream)
#define uClog (*uOStreamModule::uClogStream)


//######################### uOStream Boot #########################


class uOStreamBoot {
    static int uCount;

    static void startup();
    static void finishup();
  public:
    uOStreamBoot() {
	uCount += 1;
	if ( uCount == 1 ) {
	    startup();
	} // if
    } // uOStreamBoot::uOStreamBoot

    ~uOStreamBoot() {
	if ( uCount == 1 ) {
	    finishup();
	} // if
	uCount -= 1;
    } // uOStreamBoot::uOStreamBoot
}; // uOStreamBoot


// Create an instance in each translation unit, but only the first instance to
// execute performs the system bootstrap. Do not include instances in the
// kernel modules.

#ifndef __U_KERNEL__
static uOStreamBoot uBootuOStream;
#endif // __U_KERNEL__


#pragma __U_USER_CODE__

#endif // __U_OSTREAM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
