//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uIos.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:53:37 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Aug  6 12:10:41 2004
// Update Count     : 47
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_IOS_H__
#define __U_IOS_H__

#pragma __U_NOT_USER_CODE__

#include <iostream>


class uIos;						// forward declaration
class uFilebuf;						// forward declaration


//######################### uIosWrapper ########################


class uIosWrapper {
  private:
    uIos &stream;
  public:
    uIosWrapper( uIos &stream );
    ~uIosWrapper();
};


//######################### uIos ########################


uIos &setbase( uIos &os, int b );
uIos &setfill( uIos &os, int f );
uIos &setprecision( uIos &os, int p );
uIos &setw( uIos &os, int w );
uIos &setiosflags( uIos &os, std::ios::fmtflags f );
uIos &resetiosflags( uIos &os, std::ios::fmtflags f );


class uIos {
    friend class uIosWrapper;
    friend uIos &setbase( uIos &os, int b );
    friend uIos &setfill( uIos &os, int f );
    friend uIos &setprecision( uIos &os, int p );
    friend uIos &setw( uIos &os, int w );
    friend uIos &setiosflags( uIos &os, std::ios::fmtflags f );
    friend uIos &resetiosflags( uIos &os, std::ios::fmtflags f );

    uIos( uIos & );					// no copy
    uIos &operator=( uIos & );				// no assignment
  protected:
    std::ios *iofile;					// can't seem to make this a reference
    uOwnerLock ownerlock;

    void uEnter();
    void uLeave();
  public:
    uIos();

    // ios_base routines not requiring mutual exclusion

    std::ios_base::fmtflags flags() const;
    std::streamsize precision() const;
    std::streamsize width() const;
    std::locale getloc() const;

    // ios_base routines requiring mutual exclusion

    std::ios_base::fmtflags flags( std::ios_base::fmtflags fmtfl );
    std::ios_base::fmtflags setf( std::ios_base::fmtflags fmtfl );
    std::ios_base::fmtflags setf( std::ios_base::fmtflags fmtfl, std::ios_base::fmtflags mask );
    void unsetf( std::ios_base::fmtflags mask );
    std::streamsize precision( std::streamsize prec );
    std::streamsize width( std::streamsize wide );
    std::locale imbue( const std::locale &loc );
    //static int xalloc();
    long &iword( int index );
    void *&pword( int index );

    //typedef void (*event_callback)( std::ios_base::event, std::ios_base &, int index );
    //void register_callback( event_callback fn, int index );
    //static bool sync_with_stdio( bool sync = true );

    // ios routines not requiring mutual exclusion

    operator void*() const;
    bool operator!() const;
    std::ios_base::iostate rdstate() const;
    //uIos tie() const;
    bool good() const;
    bool eof() const;
    bool fail() const;
    bool bad() const;
    std::ios_base::iostate exceptions() const;
    std::streambuf::char_type fill() const;
    uFilebuf *rdbuf() const;
    char narrow( std::streambuf::char_type c, char dfault ) const;
    std::streambuf::char_type widen( char c ) const;

    // ios routines requiring mutual exclusion

    void clear( std::ios_base::iostate state = std::ios_base::goodbit );
    void setstate( std::ios_base::iostate state );
    void exceptions( std::ios_base::iostate except );
    uIos *tie( uIos *tiestr );
    uFilebuf *rdbuf( uFilebuf *sb );
    uIos &copyfmt( const uIos &rhs );
    std::streambuf::char_type fill( std::streambuf::char_type ch );

    // additional concurrent routines

    uBaseTask *owner();
}; // uIos


#pragma __U_USER_CODE__

#endif // __U_IOS_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
