//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uIStream.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:52:34 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jul 19 23:01:32 2004
// Update Count     : 58
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uOStream.h>
#include <uIStream.h>


uIStream &ws( uIStream &is ) {
    uIosWrapper wrapper( is );

    ws( is.ifile );
    return is;
} // endl

uIStream &boolalpha( uIStream &os ) {
    uIosWrapper wrapper( os );

    boolalpha( os.ifile );
    return os;
} // boolalpha

uIStream &noboolalpha( uIStream &os ) {
    uIosWrapper wrapper( os );

    noboolalpha( os.ifile );
    return os;
} // noboolalpha

uIStream &showbase( uIStream &os ) {
    uIosWrapper wrapper( os );

    showbase( os.ifile );
    return os;
} // showbase

uIStream &noshowbase( uIStream &os ) {
    uIosWrapper wrapper( os );

    noshowbase( os.ifile );
    return os;
} // noshowbase

uIStream &showpoint( uIStream &os ) {
    uIosWrapper wrapper( os );

    showpoint( os.ifile );
    return os;
} // showpoint

uIStream &noshowpoint( uIStream &os ) {
    uIosWrapper wrapper( os );

    showpoint( os.ifile );
    return os;
} // noshowpoint

uIStream &showpos( uIStream &os ) {
    uIosWrapper wrapper( os );

    showpos( os.ifile );
    return os;
} // showpos

uIStream &noshowpos( uIStream &os ) {
    uIosWrapper wrapper( os );

    showpos( os.ifile );
    return os;
} // noshowpos

uIStream &skipws( uIStream &os ) {
    uIosWrapper wrapper( os );

    skipws( os.ifile );
    return os;
} // skipws

uIStream &noskipws( uIStream &os ) {
    uIosWrapper wrapper( os );

    skipws( os.ifile );
    return os;
} // noskipws

uIStream &uppercase( uIStream &os ) {
    uIosWrapper wrapper( os );

    uppercase( os.ifile );
    return os;
} // uppercase

uIStream &nouppercase( uIStream &os ) {
    uIosWrapper wrapper( os );

    uppercase( os.ifile );
    return os;
} // nouppercase

uIStream &unitbuf( uIStream &os ) {
    uIosWrapper wrapper( os );

    unitbuf( os.ifile );
    return os;
} // unitbuf

uIStream &nounitbuf( uIStream &os ) {
    uIosWrapper wrapper( os );

    unitbuf( os.ifile );
    return os;
} // nounitbuf

uIStream &internal( uIStream &os ) {
    uIosWrapper wrapper( os );

    internal( os.ifile );
    return os;
} // internal

uIStream &left( uIStream &os ) {
    uIosWrapper wrapper( os );

    left( os.ifile );
    return os;
} // left

uIStream &right( uIStream &os ) {
    uIosWrapper wrapper( os );

    right( os.ifile );
    return os;
} // right

uIStream &dec( uIStream &is ) {
    uIosWrapper wrapper( is );

    dec( is.ifile );
    return is;
} // dec

uIStream &hex( uIStream &is ) {
    uIosWrapper wrapper( is );

    hex( is.ifile );
    return is;
} // hex

uIStream &oct( uIStream &is ) {
    uIosWrapper wrapper( is );

    oct( is.ifile );
    return is;
} // oct

uIStream &fixed( uIStream &os ) {
    uIosWrapper wrapper( os );

    fixed( os.ifile );
    return os;
} // fixed

uIStream &scientific( uIStream &os ) {
    uIosWrapper wrapper( os );

    scientific( os.ifile );
    return os;
} // scientific

uIStream &uAcquire( uIStream &is ) {
    is.ownerlock.acquire();
    return is;
} // uAcquire

uIStream &uRelease( uIStream &is ) {
    is.ownerlock.release();
    return is;
} // uRelease


uIStream &operator >> ( uIStream &is, char &c ) {
    uIosWrapper wrapper( is );

    is.ifile >> c;
    return is;
}

uIStream &operator >> ( uIStream &is, signed char &c ) {
    uIosWrapper wrapper( is );

    is.ifile >> c;
    return is;
}

uIStream &operator >> ( uIStream &is, unsigned char &c ) {
    uIosWrapper wrapper( is );

    is.ifile >> c;
    return is;
}

uIStream &operator >> ( uIStream &is, char *s ) {
    uIosWrapper wrapper( is );

    is.ifile >> s;
    return is;
}

uIStream &operator >> ( uIStream &is, signed char *s ) {
    uIosWrapper wrapper( is );

    is.ifile >> s;
    return is;
}

uIStream &operator >> ( uIStream &is, unsigned char *s ) {
    uIosWrapper wrapper( is );

    is.ifile >> s;
    return is;
}


uIStream::uIStream( std::streambuf *buf, uOStream *tied ) : ifile( buf ) {
    iofile = &ifile;
    tied_to = tied;
    deletebuf = 0;
} // uIStream::uIStream

uIStream::~uIStream() {
    uIosWrapper wrapper( *this );

    if ( deletebuf ) {
	delete rdbuf();
    } // if
} // uIStream::~uIStream


std::streamsize uIStream::gcount() {
    uIosWrapper wrapper( *this );

    return ifile.gcount();
} // uIStream::gcount

std::streambuf::int_type uIStream::get() {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    return ifile.get();
} // uIStream::get

uIStream &uIStream::get( std::streambuf::char_type &c ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( c );
    return *this;
} // uIStream::get

uIStream &uIStream::get( std::streambuf::char_type *ptr, std::streamsize len, std::streambuf::char_type delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( ptr, len, delim );
    return *this;
} // uIStream::get

uIStream &uIStream::get( std::streambuf &sb, std::streambuf::char_type delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.get( sb, delim );
    return *this;
} // uIStream::get

uIStream &uIStream::getline( std::streambuf::char_type *ptr, std::streamsize len, std::streambuf::char_type delim ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.getline( ptr, len, delim );
    return *this;
} // uIStream::getline

uIStream &uIStream::ignore( std::streamsize n, std::streambuf::int_type delim ) {
    uIosWrapper wrapper( *this );

    ifile.ignore( n, delim );
    return *this;
} // uIStream::ignore

std::streambuf::int_type uIStream::peek() {
    uIosWrapper wrapper( *this );

    return ifile.peek();
} // uIStream::peek

uIStream &uIStream::read( std::streambuf::char_type *ptr, std::streamsize n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile.read( ptr, n );
    return *this;
} // uIStream::read

std::streamsize uIStream::readsome( std::streambuf::char_type *ptr, std::streamsize n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    return ifile.readsome( ptr, n );
} // uIStream::readsome

uIStream &uIStream::putback( std::streambuf::char_type c ) {
    uIosWrapper wrapper( *this );

    ifile.putback( c );
    return *this;
} // uIStream::putback

uIStream &uIStream::unget() {
    uIosWrapper wrapper( *this );

    ifile.unget();
    return *this;
} //  uIStream::unget

int uIStream::sync() {
    uIosWrapper wrapper( *this );

    return ifile.sync();
} // uIStream::sync

std::streambuf::pos_type uIStream::tellg() {
    uIosWrapper wrapper( *this );

    return ifile.tellg();
} // uIStream::tellg

uIStream &uIStream::seekg( std::streambuf::pos_type pos ) {
    uIosWrapper wrapper( *this );

    ifile.seekg( pos );
    return *this;
} // uIStream::seekg

uIStream &uIStream::seekg( std::streambuf::off_type off, std::ios_base::seekdir dir ) {
    uIosWrapper wrapper( *this );

    ifile.seekg( off, dir );
    return *this;
} // uIStream::seekg


uIStream &uIStream::operator >> ( uIStream &( *f )( uIStream & ) ) {
    return (*f)( *this );
} // uIStream::operator >>

uIStream &uIStream::operator >> ( bool &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( short &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( unsigned short &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( int &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( unsigned int &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( long &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( unsigned long &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( float &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( double &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( long double &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( void *&p ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> p;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( long long &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>

uIStream &uIStream::operator >> ( unsigned long long &n ) {
    uIosWrapper wrapper( *this );

    if ( tied_to != 0 ) tied_to->flush();
    ifile >> n;
    return *this;
} // uIStream::operator >>


uOStream *uIStream::tie() {
    return tied_to;
} // uIStream::tie

uOStream *uIStream::tie( uOStream *os ) {
    uIosWrapper wrapper( *this );

    uOStream* was = tied_to;
    tied_to = os;
    return was;
} // uIStream::tie

std::istream &uIStream::stream() {
    return ifile;
} // uIStream::stream


//######################### uIStreamModule #########################


int uIStreamBoot::uCount = 0;
uFilebuf *uIStreamModule::uCinFilebuf = NULL;
uIStream *uIStreamModule::uCinStream = NULL;


//######################### uIStream Boot #########################


void uIStreamBoot::startup() {
    uIStreamModule::uCinFilebuf = new uFilebuf( 0, std::ios_base::in );
    uIStreamModule::uCinStream  = new uIStream( uIStreamModule::uCinFilebuf, uOStreamModule::uCoutStream );
} // uIStreamBoot::startup

void uIStreamBoot::finishup() {
    delete uIStreamModule::uCinStream;
    delete uIStreamModule::uCinFilebuf;
} // uIStreamBoot::finishup


// Local Variables: //
// compile-command: "gmake install" //
// End: //
