//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uFStream.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:36:16 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 15 16:42:49 2003
// Update Count     : 19
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_FSTREAM_H__
#define __U_FSTREAM_H__


#include <uIOStream.h>

#pragma __U_NOT_USER_CODE__


//######################### uIFStream #########################


class uIFStream : public uIStream {
    uIFStream( uIFStream & );				// no copy
    uIFStream &operator=( uIFStream & );		// no assignment
  public:
    uIFStream();
    uIFStream( const char *name, std::ios_base::openmode mode = std::ios_base::in );
    bool is_open();
    void open( const char *name, std::ios_base::openmode mode = std::ios_base::in );
    void close();
    uFilebuf *rdbuf() const;
}; // uIFStream


//######################### uOFStream #########################


class uOFStream : public uOStream {
    uOFStream( uOFStream & );				// no copy
    uOFStream &operator=( uOFStream & );		// no assignment
  public:
    uOFStream();
    uOFStream( const char *name, std::ios_base::openmode mode = std::ios_base::out );
    void open( const char *name, std::ios_base::openmode mode = std::ios_base::out );
    void close();
    uFilebuf *rdbuf();
}; // uOFStream


#pragma __U_USER_CODE__

#endif // __U_FSTREAM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
