//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uHeap.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Jul 20 00:07:05 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Aug  7 10:02:48 2004
// Update Count     : 114
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_HEAPMANAGER_H__
#define __U_HEAPMANAGER_H__


bool uTraceHeapOn();					// forward declarations
bool uTraceHeapOff();

class uMemoryInfoEntry;					// for profiler

extern "C" void *malloc( size_t size );
extern "C" void *calloc( size_t noOfElems, size_t elemSize );
extern "C" void *realloc( void *addr, size_t size );
extern "C" void *memalign( size_t alignment, size_t size );
extern "C" void free( void *addr );


class uHeapManager {
    friend bool uTraceHeapOn();				// access: uTraceAlloc
    friend bool uTraceHeapOff();			// access: uTraceAlloc
    friend class uKernelBoot;				// access: uHeap
    friend void *malloc( size_t size );			// access: boot
    friend void *calloc( size_t noOfElems, size_t elemSize ); // access: boot
    friend void *realloc( void *addr, size_t size );	// access: boot
    friend void *memalign( size_t alignment, size_t size ); // access: boot
    friend void free( void *addr );			// access: uDoFree

    static uHeapManager *uHeapManagerInstance;		// pointer to heap manager object
    static ptrdiff_t PreAlloc;				// allocations before start of uC++
    static bool uTraceAlloc;				// trace allocations and deallocations

    static void uNoMemory();				// called by "builtin_new" when malloc returns 0

    struct uStorage;					// forward declaration

    struct uFreeHeader {
	size_t blockSize __attribute__(( aligned (64) )); // size of cache line to prevent false sharing
	uSpinLock lock;
	uStorage *freeList;
    }; // uFreeHeader

    struct uStorage {
	struct uHeader {				// header
	    union {
		uFreeHeader *home;			// allocated block points back to home locations
		uStorage *next;				// freed block points next freed block of same size
	    } uVar;
	    // Used by uProfiler to find matching allocation data-structure for
	    // a deallocation.
	    uMemoryInfoEntry *uProfileMallocEntry;
	} uHdr; // uHeader
	char uData[0];					// storage
    }; // uStorage

    // These variables are protected by individual spin locks in the elements.
    // The first 3 elements of the array are not used (2**0 to 2**3), i.e., the
    // smallest allocation is 16 bytes (2**4). Each element of the array is the
    // size of a cache line to prevent false sharing among CPU caches during
    // bursts of allocations/deallocations.
    uFreeHeader freeLists[32];

    // These variables are protected by the extension spin lock.
    uSpinLock extlock;
    void *uHeapBegin;					// start of heap
    void *uHeapEnd;					// logical end of heap
    size_t uHeapRemaining;				// amount of storage not allocated in the current chunk

    static void boot();

    void uHeaders( char *name, void *addr, uStorage *&block, uFreeHeader *&freeElem, size_t &alignment );
    void *uExtend( size_t size );
    void *uDoMalloc( size_t size );
    void uDoFree( void *addr );
    size_t uCheckFree();
    uHeapManager();
    ~uHeapManager();

    void *operator new( size_t, void *storage );
    void *operator new( size_t size );
  public:
}; // uHeapManager


#endif // __U_HEAPMANAGER_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
