//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Philipp E. Lim and Ashif S. Harji 1995, 1997
// 
// uAlarm.h -- 
// 
// Author           : Philipp E. Lim
// Created On       : Thu Dec 21 14:01:24 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Aug 25 23:39:01 2004
// Update Count     : 155
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_ALARM_H__
#define __U_ALARM_H__


class uSignalHandler;					// forward declaration


//######################### uEventNode #########################


class uEventNode : public uSeqable {
    friend class uEventList;				// access: everything
    friend class uEventListPop;				// access: everything
    friend uCoroutine uProcessorKernel;			// access: timerT, private constructor
    friend class uBaseTask;				// access: everything
    friend class uSerial;				// access: everything
    friend class uNBIO;					// access: everything
    friend class uKernelBoot;                           // access: new
    friend class uProcessor;                            // access: new
    friend class uCondLock;				// access: everything

    uTime timerT;					// time when alarm goes off (in internal clock time)
    uDuration timerD;					// if periodic, timerD contains period of alarm (after timerT)
    uSignalHandler *SigHandler;				// signal handler function when timer goes up
    uBaseTask *uWho;					// task that created the event
    bool uExecuteLocked;				// indicates if handler is executed with uEventlock acquired

    uEventNode();
    uEventNode( uBaseTask &t, uSignalHandler &sig, uTime tT, uDuration tD = 0 );
    uEventNode( uSignalHandler &sig );
}; // uEventNode


//######################### uEventList #########################


class uEventList {
    friend uCoroutine uProcessorKernel;			// access: new
    friend class uSerial;				// access: uAddEvent, uRemoveEvent
    friend class uCondLock;				// access: uAddEvent, uRemoveEvent
    friend class uNBIO;					// access: uAddEvent, uRemoveEvent, uNextAlarm
    friend class uBaseTask;				// access: uAddEvent
    friend class uCluster;				// access: uNextAlarm
    friend class uKernelBoot;				// access: new
    friend class uProcessor;				// access: new
    friend class uEventListPop;				// access: uL

    uSequence<uEventNode> uL;
    uSpinLock uEventLock;				// protect EventQueue

    void *operator new( size_t, void *storage );
    void *operator new( size_t size );
    void uAddEvent( uEventNode &newAlarm, uProcessor &processor = uThisProcessor(), bool block = false );
    void uRemoveEvent( uEventNode &oldNode, uProcessor &processor = uThisProcessor() );
    void uPauseEvents();
    void uRestartEvents();
    uEventNode *uNextEvent();
    uTime uNextAlarm();
    bool uUserEventPresent();
    void uAcquireEventLock();
    void uReleaseEventLock();
    void uAcquireEventLockNoRF();
    void uReleaseEventLockNoRF();
  public:
}; // uEventList


class uEventListPop {
    uEventList *uEL;
    uTime curTime;
    uSignalHandler *uCxtSwHandler;                      // ContextSwitch encountered?
    bool uInKernel;
  public:
    uEventListPop();
    uEventListPop( uEventList &e, bool inKernel );
    ~uEventListPop();
    void uOver( uEventList &e, bool inKernel );
    bool operator>>( uEventNode *&node );
}; // uEventListPop


#endif // __U_ALARM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
