//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Ashif S. Harji 2000
// 
// SRC3.cc -- 
// 
// Author           : Ashif S. Harji
// Created On       : Fri Dec 22 14:58:38 2000
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jan  3 14:28:11 2001
// Update Count     : 15
// 

#include <uC++.h>
#include <uOStream.h>


uMonitor SRC {
	const unsigned int MaxItems;						// maximum items in the resource pool
	int Free, Taken, Need;
	bool Locked;										// allocates blocked at this time
  public:
	SRC( unsigned int MaxItems );
	~SRC();
	uNoMutex unsigned int Max();
	void Hold();
	void Resume();
	void Deallocate();
	void Allocate( unsigned int N );
}; // SRC

SRC::SRC( unsigned int MaxItems = 5 ) : MaxItems( MaxItems ) {
	Free = MaxItems;
	Taken = 0;
	Need = -1;
	Locked = false;
} // SRC::SRC

SRC::~SRC() {
} // SRC::SRC

unsigned int SRC::Max() {
	return MaxItems;
} // SRC::Max

void SRC::Hold() {
	while ( Locked ) {
		uAccept( Resume, Deallocate );
	} // while
	uCerr << uAcquire << &uThisTask() << " Hold,       Free:" << Free << " Taken:" << Taken << endl << uRelease;
	Locked = true;
} // SRC::Hold

void SRC::Resume() {
	while ( ! Locked ) {								// assume Resume never accepted if outstanding allocate
		uAccept( Hold ) {
		} uOr uWhen( Free > 0 ) uAccept( Allocate ) {
		} uOr uAccept( Deallocate ) {
		} //uAccept
	} // while
	uCerr << uAcquire << &uThisTask() << " Resume,     Free:" << Free << " Taken:" << Taken << endl << uRelease;
	Locked = false;
} // SRC::Resume

void SRC::Deallocate() {
	if ( Taken <= 0 ) uAbort( "problem 2" );
	Free += 1;
	Taken -= 1;
	uAssert( Free >= 0 && Taken <= MaxItems );
	uCerr << uAcquire << &uThisTask() << " Deallocate, Free:" << Free << " Taken:" << Taken << " Locked:" << Locked << " Need:" << Need << endl << uRelease;
} // SRC::Deallocate

void SRC::Allocate( unsigned int N = 1 ) {
	if ( N > MaxItems ) uAbort( "problem 3" );
	uCerr << uAcquire << &uThisTask() << " Allocate(" << N << "), enter, Free:" << Free << " Taken:" << Taken << endl << uRelease;
	while ( Locked || ! Free > 0 ) {
		uWhen ( ! Locked ) uAccept( Hold ) {
		} uOr uWhen ( Locked ) uAccept( Resume ) {
		} uOr uAccept( Deallocate ) {
		} //uAccept
	} // while	
	Free -= N;
	Taken += N;
	uAssert( ! Locked && Free >= 0 && Taken <= MaxItems );
	uCerr << uAcquire << &uThisTask() << " Allocate(" << N << "), exit, Free:" << Free << " Taken:" << Taken << endl << uRelease;
} // SRC::Allocate


SRC src;												// global: used by all workers

uTask worker {
	void main() {
		for ( int i = 0; i < 20; i += 1 ) {
			if ( random() % 10 < 2 ) {					// M out of N calls are Hold/Resume
				src.Hold();
				uYield( 50 );							// pretend to do something
				src.Resume();
			} else {
				src.Allocate();
				uYield( 3 );							// pretend to do something
				src.Deallocate();
			} // if
		} // for
		uCerr << uAcquire << &uThisTask() << " worker, exit" << endl << uRelease;
	} // worker::main
}; // worker


void uMain::main() {
	{
		worker workers[10];
	} // wait for workers to complete
	uCerr << uAcquire << "successful completion" << endl << uRelease;
} // uMain::main


// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work SRC3.cc" //
// End: //
