#include "query.h"
#include "mdiwindow.h"
#include "mainwindow.h"

#include <qmessagebox.h>
#include <qstatusbar.h>

void Query::slot_database()
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	QString text = database->currentText();

	database->clear();

	result = mysql_list_dbs(mysql,NULL);

	if(result == NULL)
	{
		return;
	}

	while((row = mysql_fetch_row(result)))
	{
		database->insertItem(row[0]);
	}

	mysql_free_result(result);

	slot_current_database(text);
}

void Query::slot_close()
{
	parentWidget()->close();
}

void Query::slot_clear()
{
	sql->clear();				
	query->slot_clear();
}

void Query::slot_undo()
{
	sql->undo();
}

void Query::slot_redo()
{
	sql->redo();
}

void Query::slot_cut()
{
	sql->cut();
}

void Query::slot_copy()
{
	sql->copy();
}

void Query::slot_paste()
{
	sql->paste();
}

void Query::slot_select_all()
{
	sql->selectAll();
}

void Query::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is a query window."));
}

void Query::slot_fire()
{
	query->set_sql(database->currentText(), sql->text());
	if(query->execute() == SQL_SCHEMA)
	{
		//debug("sql schema");
		emit signal_schema();
	}

	((QMainWindow *)parentWidget())->statusBar()->message(tr("Fields: ") + QString::number(query->columns()) + " , " + tr("Records: ") + QString::number(query->childCount()));
}

void Query::slot_current_database(const QString &text)
{
	for(int l = 0; l < database->count(); l++)
		if(text == database->text(l))
		{
			database->setCurrentItem(l);
			break;
		}
}
