/* $Header: /home/cvsroot/MyPasswordSafe/src/smartptr.cpp,v 1.5 2004/11/01 21:34:58 nolan Exp $
 * Copyright (c) 2004, Semantic Gap (TM)
 * http://www.semanticgap.com/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <map>
#include <assert.h>
#include "smartptr.hpp"
#include "myutil.hpp"

typedef std::map<void *, int> PointerMap;
PointerMap SmartPtr_pointers;

void SmartPtr_incRef(void *ptr)
{
  if(ptr == NULL)
    return;

  DBGOUT("incRef: " << ptr);
  PointerMap::iterator iter = SmartPtr_pointers.find(ptr);
  if(iter != SmartPtr_pointers.end()) {
    iter->second++;
    DBGOUT("cnt: " << iter->second);
  }
  else
    SmartPtr_pointers[ptr] = 1;
}


bool SmartPtr_decRef(void *ptr)
{
  if(ptr == NULL)
    return false;

  DBGOUT("decRef: " << ptr);
  PointerMap::iterator iter = SmartPtr_pointers.find(ptr);
  assert(iter != SmartPtr_pointers.end());

  iter->second--;
  DBGOUT("cnt: " << iter->second);
  if(iter->second <= 0) {
    DBGOUT("deleting " << ptr);
    SmartPtr_pointers.erase(iter);
    return true;
  }

  return false;
}
