/* Copyright (C) 2000-2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   There are special exceptions to the terms and conditions of the GPL as it
   is applied to this software. View the full text of the exception in file
   EXCEPTIONS in the directory of this software distribution.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "MYODBCSetupDataSourceTab3a.h"

MYODBCSetupDataSourceTab3a::MYODBCSetupDataSourceTab3a( QWidget *pwidgetParent )
    : QWidget( pwidgetParent, "MYODBCSetupDataSourceTab3a" )
{
    QVBoxLayout *playoutFields = new QVBoxLayout( this );
    playoutFields->setMargin( 20 );
    playoutFields->setSpacing( 5 );

    playoutFields->addStretch( 10 );

    pcheckboxDontOptimizeColumnWidth = new MYODBCSetupCheckBox( "Don't Optimize Column Width", this );
    pcheckboxDontOptimizeColumnWidth->setAssistText( "The client can't handle that MyODBC returns the real width of a column." );
    QToolTip::add( pcheckboxDontOptimizeColumnWidth, "The client can't handle that MyODBC returns the real width of a column." );
    playoutFields->addWidget( pcheckboxDontOptimizeColumnWidth );

    pcheckboxReturnMatchingRows = new MYODBCSetupCheckBox( "Return Matching Rows", this );
    pcheckboxReturnMatchingRows->setAssistText( "The client can't handle that MySQL returns the true value of affected rows. If this flag is set, MySQL returns ``found rows'' instead. You must have MySQL 3.21.14 or newer to get this to work." );
    QToolTip::add( pcheckboxReturnMatchingRows, "The client can't handle that MySQL returns the true value of affected rows. If this flag is set, MySQL returns ``found rows'' instead. You must have MySQL 3.21.14 or newer to get this to work." );
    playoutFields->addWidget( pcheckboxReturnMatchingRows );

    pcheckboxAllowBigResults = new MYODBCSetupCheckBox( "Allow Big Results", this );
    pcheckboxAllowBigResults->setAssistText( "Don't set any packet limit for results and parameters." );
    QToolTip::add( pcheckboxAllowBigResults, "Don't set any packet limit for results and parameters." );
    playoutFields->addWidget( pcheckboxAllowBigResults );

    pcheckboxUseCompressedProtocol = new MYODBCSetupCheckBox( "Use Compressed Protocol", this );
    pcheckboxUseCompressedProtocol->setAssistText( "Use the compressed client/server protocol." );
    QToolTip::add( pcheckboxUseCompressedProtocol, "Use the compressed client/server protocol." );
    playoutFields->addWidget( pcheckboxUseCompressedProtocol );

    pcheckboxChangeBIGINTColumnsToInt = new MYODBCSetupCheckBox( "Change BIGINT Columns To Int", this );
    pcheckboxChangeBIGINTColumnsToInt->setAssistText( "Change LONGLONG columns to INT columns (some applications can't handle LONGLONG)." );
    QToolTip::add( pcheckboxChangeBIGINTColumnsToInt, "Change LONGLONG columns to INT columns (some applications can't handle LONGLONG)." );
    playoutFields->addWidget( pcheckboxChangeBIGINTColumnsToInt );

    pcheckboxSafe = new MYODBCSetupCheckBox( "Safe", this );
    pcheckboxSafe->setAssistText( "Add some extra safety checks (should not be needed but...)." );
    QToolTip::add( pcheckboxSafe, "Add some extra safety checks (should not be needed but...)." );
    playoutFields->addWidget( pcheckboxSafe );

    playoutFields->addStretch( 10 );
}


