// outputfunction.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "outputfunction.h"
#include "data.h"

int
OutputFunction::doApply(Data *data) {
	return data->apply(*this);
}

////////

QueuedOutputFunction::QueuedOutputFunction(Data* output, int queueSize, bool needsUndo) 
	: OutputFunction(output, needsUndo), outputQueue(queueSize) {}

void
QueuedOutputFunction::restoreState() {
	outputQueue.reset();
}

void
QueuedOutputFunction::setOutQueueSize(int size) {
	outputQueue.setQueueSize(size);
}

int
QueuedOutputFunction::addToOutQueue(double *values, int count) {
	BUG("OutputFunction::addToOutQueue()");
	int n = 0;
	while (n < count && !outputQueue.full())
		outputQueue.addTo(values[n++]);
	return n;
}

int
QueuedOutputFunction::takeFromOutQueue(double *values, int count) {
	BUG("OutputFunction::takeFromOutQueue()");
	int n = 0;
	while (n < count && !outputQueue.empty())
	    values[n++] = outputQueue.takeFrom();
	return n;
}

// this is called by Data::apply() -- it returns status of runProcess()
// if Run or Error, and checks the out queue to determine status otherwise

int
QueuedOutputFunction::operator () (double *signal, int len, RunStatus* outStatus) {
	BUG("QueuedOutputFunction::operator ()");
	RunStatus procStatus = Run;
	while (outQueueEmpty() && procStatus == Run)
		procStatus = runProcess();
	*outStatus = (procStatus != Stop)? procStatus : outQueueEmpty()? Stop : Run;
	return (*outStatus == Run) ? takeFromOutQueue(signal, len) : 0;
}

// this routine is overridden in all InputOutputFunction subclasses

RunStatus
QueuedOutputFunction::runProcess() {
	int status = true;
	while((status = doProcessing()) == true) {	/* loop */ }
	return (status == true) ? Run : (status == false) ? Stop : Error;
}
