// ellipfilt.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// An elliptical filter processing object class.  The actual filter is a
// C-language function defined in ellipse.c.

#ifndef ELLIPFILT_H
#ifdef __GNUG__
#pragma interface
#endif
#define ELLIPFILT_H

#include "processfun.h"

class Controller;

class EllipticalFilter : public SimpleFunction {
	typedef SimpleFunction Super;
	friend class EllipticalRequester;
public:
	EllipticalFilter(Data* output, double pband, double stopband,
		double bpstopband=0, double ripple=1, double atten=60, double amp=1);
	EllipticalFilter(Data* output);
	static Modifier* newEllipticalFilter(Data* output) {
		return new EllipticalFilter(output);
	}
	virtual ~EllipticalFilter();
	redefined const char* message() { return "Filtering..."; }
	redefined void operator () (double *input, int count);
	redefined void restoreState();
protected:
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void saveConfig();
private:
	float* array;
	double past[10][4];
	float coeff[10][4];
	double normalizer;
	long numberOfSections;
	
	double passbandCutoff;
	double stopbandCutoff;
	double bandpassStopband;
	double passbandRipple;
	double stopbandAttenuation;
	double gain;
	int srate;
private:
	static double _savedPassbandCutoff;
	static double _savedStopbandCutoff;
	static double _savedBandpassStopband;
	static double _savedPassbandRipple;
	static double _savedStopbandAttenuation;
	static double _savedGain;
};

#endif
