/***************************************************************************
                          gnunode.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#if !defined(__GNUNODE_H_INCLUDED__)
#define __GNUNODE_H_INCLUDED__

/////////////////////////////////////////////////////////////////////////////
// MGnuNode

class MGnuPreferences;
class MGnuCache;
class MGnuShare;
class MGnuDirector;

struct QueuedPacket
{
	int   size;
	char* pData;
};

struct SGnuNode {
	int     m_nStatus;
	CString m_sHost;
	IP      m_ipHost;
	u_int   m_nPort;
	bool    m_bInbound;
	DWORD   m_dwUptime;
	DWORD   m_dwVersion;

	DWORD   m_dwFriendsTotal;
	long long m_llLibraryTotal;
	DWORD	m_dwFilesTotal;
	DWORD	m_dwSharingTotal;

	DWORD   m_dwFriends[MAX_TTL_SELF];
	DWORD   m_dwLibrary[MAX_TTL_SELF];
	DWORD   m_dwFiles[MAX_TTL_SELF];

	// Bandwidth, [0] is Received, [1] is Sent
	u_long  m_nTotalPackets[2];     // Packets received/sent
	long long m_nllTotalBytes[2];   // Bytes received/sent
	double m_dRate[2]; // receive/send rate in bytes/sec
	
	u_long m_nSecPackets[2];   // Packets received/sent during last second
	u_long m_nSecBytes[2];     // Bytes received/sent during last second
	
	u_long m_nSendQueueSize;
	u_long m_nDroppedPackets;
	u_long m_nBadPackets;
	u_long m_nRoutingErrors;
	u_long m_nLoopBackErrors;
	u_long m_nDuplicatePackets;
	//
	DWORD m_dwID;
};

class MGnuNode : public MAsyncSocket, public SGnuNode
{
friend class MGnuSock;
public:
	MGnuNode(MGnuDirector* pComm, CString Host, UINT Port, bool bInbound, bool bForceV4);
	virtual ~MGnuNode();

	// New connections
	bool ParseHandshake(const CString& Data, BYTE* pStream, int StreamLength);
	void Send_ConnectOK(bool bVersion6, bool bReply);
	void Send_Hello(bool bVersion6);
	void SetConnected();
	//void Recieve_ConnectOK();

	// Sending packets
	void Send_Ping(int);
	void Send_Pong(GUID, int);
	void Send_QueryHit(QueryComp*, BYTE*, DWORD &, BYTE &);
	void Send_HostCache();
	void Send_Host(Node);

	// Misc functions
	void ForceDisconnect();
	void OnTimer();
    inline bool IsConnected() const {return m_nStatus == SOCK_CONNECTED;}
    inline const CString& GetHost() const {return m_sHost;}
    inline DWORD GetID() const {return m_dwID;}
    // tricky function
    inline const SGnuNode& GetSGnuNode() const {return *this;}
// Overrides
public:
	virtual int Send(const void* lpBuf, int nBufLen, int nFlags = 0);
protected:
	virtual void OnSend(int nErrorCode);
	virtual void OnConnect(int nErrorCode);
	virtual void OnReceive(int nErrorCode);
	virtual void OnClose(int nErrorCode);
protected:
	MGnuNode();                      // no implementation
	MGnuNode(const MGnuNode& rSrc);  // no implementation
protected:
	// packet.handlers
	DWORD SplitBundle(BYTE*, DWORD);
	void  HandlePacket(packet_Header*, DWORD);
	bool  InspectPacket(packet_Header*);

	// Receiving packets
	void Recieve_Ping(packet_Ping*, int);
	void Recieve_Pong(packet_Pong*, int);
	void Recieve_Push(packet_Push*, int);
	void Recieve_Query(packet_Query*, int);
	void Recieve_QueryHit(packet_QueryHit*, DWORD);
	void Recieve_Unknown(BYTE*, DWORD);

	DWORD GetOurSpeed();
	void  NodeManagement(int nLastSecPackets);

	MGnuPreferences* m_pPrefs;
	MGnuDirector*  m_pDirector;
	MGnuCache*	  m_pCache;
	MGnuShare*	  m_pShare;
	//
	std::queue<QueuedPacket> m_sendQueue;
	MMutex                   m_sendQueueMutex;
	// Connected Node's info
	int	m_nSecsTrying;
	int	m_nSecsDead;
    //
	CString m_sHandshake; // why do we store this crap?
	
	// Bandwidth, [0] is Received, [1] is Sent
	DWORD	m_dwAvgPackets[2][60];  // history for last 60 seconds
	DWORD	m_dwAvgBytes[2][60];    // history for last 60 seconds
	
	bool m_bForceV4;
	//	family business
	int m_nSecCounter;	       // Counter of seconds since the connection start
	bool m_bHaveReceivedPongs;
	bool m_bHaveReceivedPings;

	DWORD m_dwExtraLength;
	BYTE* m_pReceiveBuffer;
	BYTE* m_pExtraBuffer;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // __GNUNODE_H_INCLUDED__
