/***************************************************************************
                          gnuhash.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#if !defined(__GNUHASH_H_INCLUDED__)
#define __GNUHASH_H_INCLUDED__

class MGnuNode;

struct key_Value
{
	GUID      Guid;
	MGnuNode* Origin;
	time_t    time;
	key_Value(const GUID& g, MGnuNode* p, time_t t){Guid = g; Origin=p; time = t;}
};

#define HASH_SIZE	  5000	// Size of each hash table
#define REHASH_VALUE	37	// Offset for rehashing
#define MAX_REHASH		10	// How many rehashes we try before we consider
							// the table being too full

class MGnuHash
{
public:
	MGnuHash();
	virtual ~MGnuHash();

	void Insert(GUID *, MGnuNode *);
	key_Value* FindValue(GUID *);
	void  ClearUpTable(int nSeconds);

private:
	DWORD CreateKey(GUID *);
	bool  CompareGuid(GUID *, GUID *);
	
	key_Value* m_Table[HASH_SIZE];
	int m_nHashEntries;
	MMutex m_mutex;	
protected:
	MGnuHash(const MGnuHash& rSrc);  // no implementation
};

#endif // __GNUHASH_H_INCLUDED__
