//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: metronome.cpp,v 1.2 2004/01/16 00:43:07 franky Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include "metronome.h"
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include "globals.h"

//---------------------------------------------------------
//   MetronomeConfig
//---------------------------------------------------------

MetronomeConfig::MetronomeConfig(QWidget* parent, const char* name)
   : MetronomeConfigBase(parent, name)
      {
      connect(buttonApply, SIGNAL(clicked()), SLOT(apply()));
      connect(midiClick, SIGNAL(toggled(bool)), SLOT(midiClickChanged(bool)));
      connect(precountEnable, SIGNAL(toggled(bool)), SLOT(precountEnableChanged(bool)));
      connect(precountFromMastertrack, SIGNAL(toggled(bool)),
         SLOT(precountFromMastertrackChanged(bool)));

      measureNote->setValue(measureClickNote);
      measureVelocity->setValue(measureClickVelo);
      beatNote->setValue(beatClickNote);
      beatVelocity->setValue(beatClickVelo);
      midiChannel->setValue(clickChan+1);
      midiPort->setValue(clickPort+1);
      precountBars->setValue(preMeasures);
      precountEnable->setChecked(precountEnableFlag);
      precountFromMastertrack->setChecked(precountFromMastertrackFlag);
      precountSigZ->setValue(::precountSigZ);
      precountSigN->setValue(::precountSigN);
      precountPrerecord->setChecked(::precountPrerecord);
      precountPreroll->setChecked(::precountPreroll);
      midiClick->setChecked(midiClickFlag);
      audioBeep->setChecked(audioClickFlag);
      }

//---------------------------------------------------------
//   accept
//---------------------------------------------------------

void MetronomeConfig::accept()
      {
      apply();
      MetronomeConfigBase::accept();
      }

//---------------------------------------------------------
//   apply
//---------------------------------------------------------

void MetronomeConfig::apply()
      {
      measureClickNote   = measureNote->value();
      measureClickVelo   = measureVelocity->value();
      beatClickNote      = beatNote->value();
      beatClickVelo      = beatVelocity->value();
      clickChan          = midiChannel->value() - 1;
      clickPort          = midiPort->value() - 1;
      preMeasures        = precountBars->value();
      precountEnableFlag = precountEnable->isChecked();
      precountFromMastertrackFlag = precountFromMastertrack->isChecked();
      ::precountSigZ     = precountSigZ->value();
      ::precountSigN     = precountSigN->value();
      ::precountPrerecord = precountPrerecord->isChecked();
      ::precountPreroll  = precountPreroll->isChecked();
      midiClickFlag      = midiClick->isChecked();
      audioClickFlag     = audioBeep->isChecked();
      }

//---------------------------------------------------------
//   reject
//---------------------------------------------------------

void MetronomeConfig::reject()
      {
      MetronomeConfigBase::reject();
      }

//---------------------------------------------------------
//   midiClickChanged
//---------------------------------------------------------

void MetronomeConfig::midiClickChanged(bool flag)
      {
      measureNote->setEnabled(flag);
      measureVelocity->setEnabled(flag);
      beatNote->setEnabled(flag);
      beatVelocity->setEnabled(flag);
      midiChannel->setEnabled(flag);
      midiPort->setEnabled(flag);
      }

void MetronomeConfig::precountEnableChanged(bool flag)
      {
      precountBars->setEnabled(flag);
      precountFromMastertrack->setEnabled(flag);
      precountSigZ->setEnabled(flag && !precountFromMastertrack->isChecked());
      precountSigN->setEnabled(flag && !precountFromMastertrack->isChecked());
      }

void MetronomeConfig::precountFromMastertrackChanged(bool flag)
      {
      precountSigZ->setEnabled(!flag);
      precountSigN->setEnabled(!flag);
      }


