//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: strip.cpp,v 1.6 2004/04/17 11:30:43 wschweer Exp $
//
//  (C) Copyright 2000-2004 Werner Schweer (ws@seh.de)
//=========================================================

#include <qtoolbutton.h>
#include <qlabel.h>
#include <qlayout.h>

#include "globals.h"
#include "gconfig.h"
#include "app.h"
#include "audio.h"
#include "song.h"
#include "track.h"
#include "strip.h"
#include "meter.h"

//---------------------------------------------------------
//   setRecordFlag
//---------------------------------------------------------

void Strip::setRecordFlag(bool flag)
      {
      if (record) {
            record->blockSignals(true);
            record->setOn(flag);
            record->blockSignals(false);
            }
      }

//---------------------------------------------------------
//   resetPeaks
//---------------------------------------------------------

void Strip::resetPeaks()
      {
      track->resetPeaks();
      }

//---------------------------------------------------------
//   recordToggled
//---------------------------------------------------------

void Strip::recordToggled(bool val)
      {
      if (track->type() == Track::AUDIO_OUTPUT) {
            if (val && track->recordFlag() == false) {
                  muse->bounceToFile();
                  audio->msgSetRecord((AudioOutput*)track, val);
                  }
            audio->msgSetRecord((AudioOutput*)track, val);
            if (!((AudioOutput*)track)->recFile())
                  record->setOn(false);
            return;
            }
      song->setRecordFlag(track, val);
      }

//---------------------------------------------------------
//   heartBeat
//---------------------------------------------------------

void Strip::heartBeat()
      {
      for (int ch = 0; ch < track->channels(); ++ch) {
            if (meter[ch]) {
                  int meterVal = track->meter(ch);
                  int peak  = track->peak(ch);
                  meter[ch]->setVal(meterVal, peak, false);
                  }
            }
      }

//---------------------------------------------------------
//   setLabelText
//---------------------------------------------------------

void Strip::setLabelText()
      {
      label->setText(track->name());
      switch(track->type()) {
            case Track::AUDIO_OUTPUT:
                  label->setBackgroundColor(white);
                  break;
            case Track::AUDIO_GROUP:
                  label->setBackgroundColor(yellow);
                  break;
            case Track::AUDIO_AUX:
                  label->setBackgroundColor(cyan);
                  break;
            case Track::WAVE:
                  label->setBackgroundColor(green);
                  break;
            case Track::AUDIO_INPUT:
                  label->setBackgroundColor(red);
                  break;
            case Track::AUDIO_SOFTSYNTH:
                  label->setBackgroundColor(blue);
                  break;
            case Track::MIDI:
            case Track::DRUM:
                  {
                  MidiTrack* mt = (MidiTrack*)track;
                  int port = mt->outPort();
                  int channel = mt->outChannel();
                  QString s;
                  s.sprintf("%d-%d", port + 1, channel + 1);
                  label->setText(s);
                  label->setBackgroundColor(gray);
                  }
                  break;
            }
      }

//---------------------------------------------------------
//   muteToggled
//---------------------------------------------------------

void Strip::muteToggled(bool val)
      {
      track->setMute(val);
      song->update(SC_MUTE);
      }

//---------------------------------------------------------
//   soloToggled
//---------------------------------------------------------

void Strip::soloToggled(bool val)
      {
      track->setSolo(val);
      song->update(SC_SOLO);
      }

//---------------------------------------------------------
//   Strip
//    create mixer strip
//---------------------------------------------------------

Strip::Strip(QWidget* parent, Track* t)
   : QFrame(parent, "Strip", Qt::WDestructiveClose)
      {
      setBackgroundMode(PaletteMid);
      setFrameStyle(Panel | Raised);
      setLineWidth(2);

      track    = t;
      meter[0] = 0;
      meter[1] = 0;
      setFixedWidth(STRIP_WIDTH);
      layout = new QVBoxLayout(this);
      layout->setMargin(3);

      //---------------------------------------------
      //    label
      //---------------------------------------------

      label = new QLabel(this);
      setLabelText();
      label->setFont(config.fonts[1]);
      label->setAlignment(AlignCenter);
      label->setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed));
      layout->addWidget(label);
      }

//---------------------------------------------------------
//   Strip
//---------------------------------------------------------

Strip::~Strip()
      {
      }

//---------------------------------------------------------
//   setAutomationType
//---------------------------------------------------------

void Strip::setAutomationType(int t,int)
      {
      track->setAutomationType(AutomationType(t));
      song->update(SC_AUTOMATION);
      }


