//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audiodev.h,v 1.5 2004/06/28 21:13:16 wschweer Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIODEV_H__
#define __AUDIODEV_H__

#include <qstring.h>
#include <list>

//---------------------------------------------------------
//   AudioDevice
//---------------------------------------------------------

class AudioDevice {

   public:
      AudioDevice() {}
      virtual ~AudioDevice() {}

      virtual void start() = 0;
      virtual void stop () = 0;
      virtual int framePos() const = 0;

      virtual float* getBuffer(void* port, unsigned long nframes) = 0;

      virtual std::list<QString> outputPorts() = 0;
      virtual std::list<QString> inputPorts() = 0;

      virtual void registerClient() = 0;

      virtual void* registerOutPort(const char* name) = 0;
      virtual void* registerInPort(const char* name) = 0;
      virtual void unregisterPort(void*) = 0;
      virtual void connect(void*, void*) = 0;
      virtual void disconnect(void*, void*) = 0;
      virtual void setPortName(void* p, const char* n) = 0;
      virtual void* findPort(const char* name) = 0;
      virtual QString portName(void* port) = 0;
      virtual int getState() = 0;
      virtual unsigned getCurFrame() = 0;
      virtual bool isRealtime() = 0;
      virtual void startTransport() = 0;
      virtual void stopTransport() = 0;
      virtual void seekTransport(unsigned frame) = 0;
      virtual void setFreewheel(bool f) = 0;
      virtual void graphChanged() {}
      };

#endif

