//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: comment.h,v 1.1.1.1 2003/10/29 10:06:21 wschweer Exp $
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __COMMENT_H__
#define __COMMENT_H__

#include <qwidget.h>
#include "commentbase.h"

class Xml;
class Track;

//---------------------------------------------------------
//   Comment
//---------------------------------------------------------

class Comment : public CommentBase {
      Q_OBJECT

   private:
      virtual void setText(const QString& s) = 0;

   private slots:
      void textChanged();

   public:
      Comment(QWidget* parent, const char* name = 0);
      };

//---------------------------------------------------------
//   TrackComment
//---------------------------------------------------------

class TrackComment : public Comment {
      Track* track;
      int trackId;
      Q_OBJECT

   private:
      virtual void setText(const QString& s);

   private slots:
      void songChanged(int);

   public:
      TrackComment(Track*, QWidget*, const char* name = 0);
      };

#endif

