//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: sig.h,v 1.1.1.1 2003/10/29 10:05:00 wschweer Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SIG_H__
#define __SIG_H__

#include <map>

#ifndef MAX_TICK
#define MAX_TICK (0x7fffffff/100)
#endif

class Xml;

//---------------------------------------------------------
//   Signature Event
//---------------------------------------------------------

struct SigEvent {
      int z, n;            // takt signatur
      int tick;            // ab dieser Position gilt signatur
      int bar;             // precomputed

      int read(Xml&);
      void write(int, Xml&, int) const;

      SigEvent() { }
      SigEvent(int Z, int N, int tk) {
            z = Z;
            n = N;
            tick = tk;
            bar = 0;
            }
      };

//---------------------------------------------------------
//   SigList
//---------------------------------------------------------

typedef std::map<int, SigEvent*, std::less<int> >::iterator iSigEvent;
typedef std::map<int, SigEvent*, std::less<int> >::const_iterator ciSigEvent;
typedef std::map<int, SigEvent*, std::less<int> >::reverse_iterator riSigEvent;
typedef std::map<int, SigEvent*, std::less<int> >::const_reverse_iterator criSigEvent;

class SigList : public std::map<int, SigEvent*, std::less<int> > {
      int ticks_beat(int N) const;
      void normalize();
      int ticksMeasure(int z, int n) const;

   public:
      SigList();
      void clear();
      void add(int tick, int z, int n);
      void del(int tick);

      void read(Xml&);
      void write(int, Xml&) const;
      void dump() const;

      void timesig(int tick, int& z, int& n) const;
      void tickValues(int t, int* bar, int* beat, int* tick) const;
      int bar2tick(int bar, int beat, int tick) const;

      int ticksMeasure(int tick) const;   // fr score
      int ticksBeat(int tick) const;      // fr score
      int raster(int tick, int raster) const;
      int raster1(int tick, int raster) const;
      int raster2(int tick, int raster) const;
      int rasterStep(int tick, int raster) const;
      };

extern SigList sigmap;
#endif
