//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: dcanvas.h,v 1.2 2003/11/18 18:43:05 lunar_shuttle Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __DCANVAS_H__
#define __DCANVAS_H__

#include "ecanvas.h"
#include "song.h"

#define TH 18

class MidiEvent;
class MidiEditor;

//---------------------------------------------------------
//   DEvent
//    ''visual'' Drum Event
//---------------------------------------------------------

class DEvent : public CItem {
   public:
      DEvent(MidiEvent* e, Part* p);
      };

class ScrollScale;
class PianoRoll;
class QTextDrag;

//---------------------------------------------------------
//   DrumCanvas
//---------------------------------------------------------

class DrumCanvas : public EventCanvas {

      Q_OBJECT
      virtual void drawCanvas(QPainter&, const QRect&);
      virtual void drawItem(QPainter&, const CItem*, const QRect&) const;
      virtual bool moveItem(CItem*, const QPoint&, DragType);
      virtual CItem* newItem(const QPoint&, int);
      virtual void resizeItem(CItem*, bool);
      virtual void newItem(CItem*, bool);
      virtual bool deleteItem(CItem*);

      int y2pitch(int y) const;
      int pitch2y(int pitch) const;
      QTextDrag* getTextDrag(QWidget* parent);
      void copy();
      int pasteAt(const QString& pt, int pos);
      void paste();
      void startDrag(CItem*, bool copymode);
      void dragEnterEvent(QDragEnterEvent* event);
      void dragMoveEvent(QDragMoveEvent*);
      void dragLeaveEvent(QDragLeaveEvent*);
      void viewDropEvent(QDropEvent* event);
      virtual void addItem(Part*, Event*);
      virtual void resizeEvent(QResizeEvent*);

   signals:
      void newWidth(int);

   public slots:
      void mapChanged(int, int);
      void keyPressed(int, bool);
      void keyReleased(int, bool);

   public:
      enum {CMD_CUT, CMD_COPY, CMD_PASTE, CMD_SAVE, CMD_LOAD,
         CMD_SELECT_ALL, CMD_SELECT_NONE, CMD_SELECT_INVERT,
         CMD_SELECT_ILOOP, CMD_SELECT_OLOOP, CMD_DEL, 
         CMD_FIXED_LEN 
         };
      DrumCanvas(MidiEditor*, QWidget*, int, int,
         const char* name = 0);
      void cmd(int);
      };
#endif

