//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: ctrledit.cpp,v 1.1.1.1 2003/10/29 10:05:21 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include "ctrledit.h"
#include "ctrlcanvas.h"
#include "midieditor.h"
#include "xml.h"
#include "vscale.h"
#include "ctrlpanel.h"
#include "globals.h"

#include <qlayout.h>
#include <qpainter.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qlabel.h>

//---------------------------------------------------------
//   setTool
//---------------------------------------------------------

void CtrlEdit::setTool(int t)
      {
      canvas->setTool(t);
      }

//---------------------------------------------------------
//   CtrlEdit
//---------------------------------------------------------

CtrlEdit::CtrlEdit(QWidget* parent, MidiEditor* e, int xmag,
   bool expand, const char* name) : QWidget(parent, name)
      {
      QHBoxLayout* hbox = new QHBoxLayout(this);
      panel             = new CtrlPanel(this, e, "panel");
      canvas            = new CtrlCanvas(e, this, xmag, "ctrlcanvas");
      QWidget* vscale   = new VScale(this);

      canvas->setOrigin(-(division/4), 0);

      canvas->setMinimumHeight(50);
      panel->setFixedWidth(40);

      hbox->addWidget(panel,  expand ? 100 : 0, AlignRight);
      hbox->addWidget(canvas, 100);
      hbox->addWidget(vscale, 0);

      connect(panel, SIGNAL(destroyPanel()), SLOT(destroy()));
      connect(panel, SIGNAL(controllerChanged(const MidiController&)),
         canvas, SLOT(setController(const MidiController&)));
      connect(canvas, SIGNAL(xposChanged(int)), SIGNAL(timeChanged(int)));
      connect(canvas, SIGNAL(yposChanged(int)), SIGNAL(yposChanged(int)));
      }

//---------------------------------------------------------
//   writeStatus
//---------------------------------------------------------

void CtrlEdit::writeStatus(int level, Xml& xml)
      {
      xml.tag(level++, "ctrledit");
      canvas->controller().write(level, xml);
      xml.tag(level, "/ctrledit");
      }

//---------------------------------------------------------
//   readStatus
//---------------------------------------------------------

void CtrlEdit::readStatus(Xml& xml)
      {
      for (;;) {
            Xml::Token token = xml.parse();
            const QString& tag = xml.s1();
            switch (token) {
                  case Xml::Error:
                  case Xml::End:
                        return;
                  case Xml::TagStart:
                        if (tag == "mctrl") {
                              MidiController ctrl;
                              ctrl.read(xml);
                              canvas->setController(ctrl);
                              }
                        else
                              xml.unknown("CtrlEdit");
                        break;
                  case Xml::TagEnd:
                        if (tag == "ctrledit")
                              return;
                  default:
                        break;
                  }
            }
      }

//---------------------------------------------------------
//   destroy
//---------------------------------------------------------

void CtrlEdit::destroy()
      {
      emit destroyedCtrl(this);
      close(true);      // close and destroy widget
      }


