//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: undo.h,v 1.2 2001/11/20 15:19:32 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __UNDO_H__
#define __UNDO_H__

#include <list>

class Track;
class TEvent;
class SigEvent;
class Event;
class Part;

//---------------------------------------------------------
//   UndoOp
//---------------------------------------------------------

struct UndoOp {
      enum UndoType {
            AddTrack, DeleteTrack, ModifyTrack,
            AddPart,  DeletePart,  ModifyPart,
            AddEvent, DeleteEvent, ModifyEvent,
            AddTempo, DeleteTempo,
            AddSig,
            SwapTrack, ModifyController
            };
      UndoType type;

      union xxx {
            struct {
                  int a;
                  int b;
                  int c;
                  } i;
            struct {
                  Track* track;
                  int trackno;
                  } t;
            struct {
                  Part* oPart;
                  Part* nPart;
                  } p;
            struct {
                  Event* oEvent;
                  Event* nEvent;
                  Part* part;
                  } e;
            struct {
                  SigEvent* nSignature;
                  SigEvent* oSignature;
                  } s;
            struct {
                  int channel;
                  int ctrl;
                  int oVal;
                  int nVal;
                  } c;
            } xxx;
      };

class Undo : public std::list<UndoOp> {
      void undoOp(UndoOp::UndoType, int data);
      };

typedef Undo::iterator iUndoOp;
typedef Undo::reverse_iterator riUndoOp;

class UndoList : public std::list<Undo> {
   public:
      };

typedef UndoList::iterator iUndo;


#endif // __UNDO_H__
