/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 3.1 2001/10/29 17:56:53 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"env.h"

MU_net_config_t config;

static void
get_info_net(void)
{
	if (get_interface(&config) == INVALID)
		exit(1);
}

static void
end_net(struct mu_op *opp)
{
	free(((MU_net_config_t *)opp->config)->name);
}

struct mu_op mu_op = {
	command: MU_NET,
	mappath: NULL,
	default_mapname: NULL,
	config: &config,
	get_info: get_info_net,
	run: execute,
	end: end_net,
};
