/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: action.c,v 3.3 2001/10/29 17:11:03 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"murasaki.h"
#include	"env.h"

#if defined(MURASAKI_NET)	/* net */
#define	MU_STRING_ADD		"register"
#define	MU_STRING_REMOVE	"unregister"
#else	/* usb, pci, ieee1394 */
#define	MU_STRING_ADD		"add"
#define	MU_STRING_REMOVE	"remove"
#endif


int
get_action(void)
{
	char *ptr;

	ptr = getenv("ACTION");
	if (ptr == NULL)
		return INVALID;
	else if (strcmp(ptr,MU_STRING_ADD) == 0) {
		syslog(LOG_LEVEL,"device is %sed",ptr);
		return ACTION_ADD;
	} else if (strcmp(ptr,MU_STRING_REMOVE) == 0) {
		syslog(LOG_LEVEL,"device is %sd",ptr);
		return ACTION_REMOVE;
	}
	return INVALID;
}
