#ifndef DNOTIFY_WATCHERPARTIAL_H
#define DNOTIFY_WATCHERPARTIAL_H

#include <fcntl.h>

#include <string>

#include "compat.h"
#include "watcher.h"
#include "state.h"

// Watches a directory that could become a Maildir and creates a
// watcher_maildir if this happens
class watcher_partial : public watcher
{
  public:
	watcher_partial(struct dnotify_state* state, const std::string& partial_maildir);
	virtual ~watcher_partial();

	virtual void process_event(int fd);

  private:
	// watcher_base will delete us if 'partial_maildir' is deleted

	// Watch for cur/ and new/ to come into existance
	static const long cn_notify = DN_CREATE | DN_RENAME | DN_DELETE | DN_MULTISHOT;

	struct dnotify_state* state;
	const std::string partial_maildir;

	int fd;

	void transition_to_maildir();
	int start_watch(const char* dir);
	void stop_watch(int fd);
};

#endif // DNOTIFY_WATCHERPARTIAL_H
