/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdlib.h>
#include <stdio.h>

#include "MRW_Private.h"

char *progname;

void
Usage ()
{
	fprintf (stderr, "Usage: %s < mrwfile\n", progname);
	exit (1);
}

typedef struct {
	int	offset;
	char	*name;
} OFFSET_ENTRY;

OFFSET_ENTRY Settings1Table[] = {
	{ 0x04, "Exposure Mode" },	/* 0=P, 1=A, 2=S, 3=M */
	{ 0x08, "Flash Mode" },		/* 0=Fill, 1=RedEye, 2 = RSync */
	{ 0x0C, "Color Mode" },
	{ 0x10, "Image Size" },		/* 0=Full Size */
	{ 0x14, "Image Quality" },	/* 0=Raw. */
	{ 0x18, "Drive Mode" },		/* 0=Single, 2=SelfTimer, 5=Interval */
	{ 0x1C, "Meter Mode" },		/* 0=Multi, 1=Cntr, 2=Spot */
	{ 0x20, "Actual ISO Code" },	/* 2^((code-32)/8) * 25 */
	{ 0x24, "Actual Exposure Code" },
	{ 0x28, "Actual F Number Code" },
	{ 0x2C, "Macro" },
	{ 0x30, "Digital Zoom" },
	{ 0x34, "EV Compensation Code" }, /* (code-6) / 3  */
	{ 0x38, "Exposure Bracket" },	/* 0=.3ev, 1=.5ev, 2=1ev */
	{ 0x40, "Interval" },		/* value+1 minutes */
	{ 0x44, "Frame count" },	/* value frames */
	{ 0x48, "Zoom" },
	{ 0x4c, "Focus" },
	{ 0x50, "Flash" },
	{ 0x54, "Day Code" },		/* 16 bit Year, 8 bit Mnth, 8 bit Day */
	{ 0x58, "Time Code" },		/* 16 bit Hr, 8 bit Min, 8 bit Sec */
	{ 0x5C, "Max Aperture Code" },	/* 32=F2.8, 36=F3.5, or 2^((val-20)/8) */
	{ 0x68, "File memory" },
	{ 0x6C, "Last stored picture" },
	{ 0x70, "Red gain" },
	{ 0x74, "Green gain" },
	{ 0x78, "Blue gain" },
	{ 0x7C, "Color" },
	{ 0x80, "Contrast" },
	{ 0x84, "Sharpness" },		/* 0=Soft, 1=Normal, 2=Hard */
	{ 0x88, "Exposure Program" },
	{ 0x8c, "Flash Compensation Code" }, /* (code-6) / 3  */
	{ 0x90, "ISO Setting" },
	{ 0x94, "Camera Model Code" },
	{ -1, NULL },
};

static void
PrintEntry (int offset, int value, OFFSET_ENTRY *tab)
{
	while (tab->offset >= 0 && tab->offset != offset)
		tab++;
	if (tab->offset < 0)
		printf ("          Unknown 0x%03x: %d\n", offset, value);
	else
		printf ("%23.23s: %d\n", tab->name, value);
}

int
main (int argc, char *argv[])
{
	mrw_header	hdr;
	char		*errmsg;
	int		i, settings_length;

	progname = argv[0];
	if (!LoadMRW (&hdr, stdin, &errmsg)) {
		fprintf (stderr, "%s: Error: Unable to load MRW file from stdin\n", progname);
		fprintf (stderr, "    %s\n", errmsg);
		Usage();
	}
	settings_length = IFD_GetUndefinedLength (hdr.manu_ifd, MANUTAG_CAMERASETTINGS);
	if (settings_length == 0)
		settings_length = IFD_GetUndefinedLength (hdr.manu_ifd, MANUTAG_CAMERASETTINGS2);
	printf ("Settings length = %d\n", settings_length);

	for (i = 0; i < settings_length; i+=4)
		PrintEntry (i, mrw_val (hdr.settings, i, 4), Settings1Table);

	exit (0);
}
