/*
    Copyright 2008 Brain Research Institute, Melbourne, Australia

    Written by J-Donald Tournier, 27/06/08.

    This file is part of MRtrix.

    MRtrix is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    MRtrix is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MRtrix.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "file/dicom/element.h"

namespace MR {
  namespace File {
    namespace Dicom {

      UnorderedMap<guint32, const gchar*>::Type Element::dict;


      void Element::init_dict()
      {
        info ("initialising DICOM dictionary");

        /* the following was generated by running the following command on the SPM2 dicom dictionary file:

           awk '{ print "dict[0x"$1$2"UL] =  \""$4$3"\";" }' spm_dicom_dict.txt 


           need to remove all 0x60xx... and 0x50xx... entries
           */

        dict[0x00020000UL] =  "ULGroupLength";
        dict[0x00020001UL] =  "OBFileMetaInformationVersion";
        dict[0x00020002UL] =  "UIMediaStorageSOPClassUID";
        dict[0x00020003UL] =  "UIMediaStorageSOPInstanceUID";
        dict[0x00020010UL] =  "UITransferSyntaxUID";
        dict[0x00020012UL] =  "UIImplementationClassUID";
        dict[0x00020013UL] =  "SHImplementationVersionName";
        dict[0x00020016UL] =  "AESourceApplicationEntityTitle";
        dict[0x00020100UL] =  "UIPrivateInformationCreatorUID";
        dict[0x00020102UL] =  "OBPrivateInformation";
        dict[0x00040000UL] =  "ULGroupLength";
        dict[0x00041130UL] =  "CSFilesetID";
        dict[0x00041141UL] =  "CSFilesetDescriptorFileID";
        dict[0x00041142UL] =  "CSSpecificCharacterSetofFilesetDescriptorFile";
        dict[0x00041200UL] =  "ULOffsetoftheFirstDirectoryRecordoftheRootDirectoryEntity";
        dict[0x00041202UL] =  "ULOffsetoftheLastDirectoryRecordoftheRootDirectoryEntity";
        dict[0x00041212UL] =  "USFilesetConsistencyFlag";
        dict[0x00041220UL] =  "SQDirectoryRecordSequence";
        dict[0x00041400UL] =  "ULOffsetoftheNextDirectoryRecord";
        dict[0x00041410UL] =  "USRecordInuseFlag";
        dict[0x00041420UL] =  "ULOffsetofReferencedLowerLevelDirectoryEntity";
        dict[0x00041430UL] =  "CSDirectoryRecordType";
        dict[0x00041432UL] =  "UIPrivateRecordUID";
        dict[0x00041500UL] =  "CSReferencedFileID";
        dict[0x00041504UL] =  "ULMRDRDirectoryRecordOffset";
        dict[0x00041510UL] =  "UIReferencedSOPClassUIDinFile";
        dict[0x00041511UL] =  "UIReferencedSOPInstanceUIDinFile";
        dict[0x00041512UL] =  "UIReferencedTransferSyntaxUIDinFile";
        dict[0x00041600UL] =  "ULNumberofReferences";
        dict[0x00080005UL] =  "CSSpecificCharacterSet";
        dict[0x00080008UL] =  "CSImageType";
        dict[0x00080012UL] =  "DAInstanceCreationDate";
        dict[0x00080013UL] =  "TMInstanceCreationTime";
        dict[0x00080014UL] =  "UIInstanceCreatorUID";
        dict[0x00080016UL] =  "UISOPClassUID";
        dict[0x00080018UL] =  "UISOPInstanceUID";
        dict[0x00080020UL] =  "DAStudyDate";
        dict[0x00080021UL] =  "DASeriesDate";
        dict[0x00080022UL] =  "DAAcquisitionDate";
        dict[0x00080023UL] =  "DAContentDate";
        dict[0x00080024UL] =  "DAOverlayDate";
        dict[0x00080025UL] =  "DACurveDate";
        dict[0x0008002AUL] =  "DTAcquisitionDatetime";
        dict[0x00080030UL] =  "TMStudyTime";
        dict[0x00080031UL] =  "TMSeriesTime";
        dict[0x00080032UL] =  "TMAcquisitionTime";
        dict[0x00080033UL] =  "TMContentTime";
        dict[0x00080034UL] =  "TMOverlayTime";
        dict[0x00080035UL] =  "TMCurveTime";
        dict[0x00080050UL] =  "SHAccessionNumber";
        dict[0x00080052UL] =  "CSQueryRetrieveLevel";
        dict[0x00080054UL] =  "AERetrieveAETitle";
        dict[0x00080056UL] =  "CSInstanceAvailability";
        dict[0x00080058UL] =  "UIFailedSOPInstanceUIDList";
        dict[0x00080060UL] =  "CSModality";
        dict[0x00080061UL] =  "CSModalitiesinStudy";
        dict[0x00080064UL] =  "CSConversionType";
        dict[0x00080068UL] =  "CSPresentationIntentType";
        dict[0x00080070UL] =  "LOManufacturer";
        dict[0x00080080UL] =  "LOInstitutionName";
        dict[0x00080081UL] =  "STInstitutionAddress";
        dict[0x00080082UL] =  "SQInstitutionCodeSequence";
        dict[0x00080090UL] =  "PNReferringPhysiciansName";
        dict[0x00080092UL] =  "STReferringPhysiciansAddress";
        dict[0x00080094UL] =  "SHReferringPhysiciansTelephoneNumbers";
        dict[0x00080100UL] =  "SHCodeValue";
        dict[0x00080102UL] =  "SHCodingSchemeDesignator";
        dict[0x00080103UL] =  "SHCodingSchemeVersion";
        dict[0x00080104UL] =  "LOCodeMeaning";
        dict[0x00080105UL] =  "CSMappingResource";
        dict[0x00080106UL] =  "DTContextGroupVersion";
        dict[0x00080107UL] =  "DTContextGroupLocalVersion";
        dict[0x0008010BUL] =  "CSCodeSetExtensionFlag";
        dict[0x0008010CUL] =  "UIPrivateCodingSchemeCreatorUID";
        dict[0x0008010DUL] =  "UICodeSetExtensionCreatorUID";
        dict[0x0008010FUL] =  "CSContextIdentifier";
        dict[0x00080201UL] =  "SHTimezoneOffsetFromUTC";
        dict[0x00081010UL] =  "SHStationName";
        dict[0x00081030UL] =  "LOStudyDescription";
        dict[0x00081032UL] =  "SQProcedureCodeSequence";
        dict[0x0008103EUL] =  "LOSeriesDescription";
        dict[0x00081040UL] =  "LOInstitutionalDepartmentName";
        dict[0x00081048UL] =  "PNPhysiciansofRecord";
        dict[0x00081050UL] =  "PNPerformingPhysiciansName";
        dict[0x00081060UL] =  "PNNameofPhysiciansReadingStudy";
        dict[0x00081070UL] =  "PNOperatorsName";
        dict[0x00081080UL] =  "LOAdmittingDiagnosesDescription";
        dict[0x00081084UL] =  "SQAdmittingDiagnosesCodeSequence";
        dict[0x00081090UL] =  "LOManufacturersModelName";
        dict[0x00081100UL] =  "SQReferencedResultsSequence";
        dict[0x00081110UL] =  "SQReferencedStudySequence";
        dict[0x00081111UL] =  "SQReferencedStudyComponentSequence";
        dict[0x00081115UL] =  "SQReferencedSeriesSequence";
        dict[0x00081120UL] =  "SQReferencedPatientSequence";
        dict[0x00081125UL] =  "SQReferencedVisitSequence";
        dict[0x00081130UL] =  "SQReferencedOverlaySequence";
        dict[0x0008113AUL] =  "SQReferencedWaveformSequence";
        dict[0x00081140UL] =  "SQReferencedImageSequence";
        dict[0x00081145UL] =  "SQReferencedCurveSequence";
        dict[0x0008114AUL] =  "SQReferencedInstanceSequence";
        dict[0x00081150UL] =  "UIReferencedSOPClassUID";
        dict[0x00081155UL] =  "UIReferencedSOPInstanceUID";
        dict[0x0008115AUL] =  "UISOPClassesSupported";
        dict[0x00081160UL] =  "ISReferencedFrameNumber";
        dict[0x00081195UL] =  "UITransactionUID";
        dict[0x00081197UL] =  "USFailureReason";
        dict[0x00081198UL] =  "SQFailedSOPSequence";
        dict[0x00081199UL] =  "SQReferencedSOPSequence";
        dict[0x00082111UL] =  "STDerivationDescription";
        dict[0x00082112UL] =  "SQSourceImageSequence";
        dict[0x00082120UL] =  "SHStageName";
        dict[0x00082122UL] =  "ISStageNumber";
        dict[0x00082124UL] =  "ISNumberofStages";
        dict[0x00082127UL] =  "SHViewName";
        dict[0x00082128UL] =  "ISViewNumber";
        dict[0x00082129UL] =  "ISNumberofEventTimers";
        dict[0x0008212AUL] =  "ISNumberofViewsinStage";
        dict[0x00082130UL] =  "DSEventElapsedTimes";
        dict[0x00082132UL] =  "LOEventTimerNames";
        dict[0x00082142UL] =  "ISStartTrim";
        dict[0x00082143UL] =  "ISStopTrim";
        dict[0x00082144UL] =  "ISRecommendedDisplayFrameRate";
        dict[0x00082218UL] =  "SQAnatomicRegionSequence";
        dict[0x00082220UL] =  "SQAnatomicRegionModifierSequence";
        dict[0x00082228UL] =  "SQPrimaryAnatomicStructureSequence";
        dict[0x00082229UL] =  "SQAnatomicStructureSpaceorRegionSequence";
        dict[0x00082230UL] =  "SQPrimaryAnatomicStructureModifierSequence";
        dict[0x00082240UL] =  "SQTransducerPositionSequence";
        dict[0x00082242UL] =  "SQTransducerPositionModifierSequence";
        dict[0x00082244UL] =  "SQTransducerOrientationSequence";
        dict[0x00082246UL] =  "SQTransducerOrientationModifierSequence";
        dict[0x00100010UL] =  "PNPatientsName";
        dict[0x00100020UL] =  "LOPatientID";
        dict[0x00100021UL] =  "LOIssuerofPatientID";
        dict[0x00100030UL] =  "DAPatientsBirthDate";
        dict[0x00100032UL] =  "TMPatientsBirthTime";
        dict[0x00100040UL] =  "CSPatientsSex";
        dict[0x00100050UL] =  "SQPatientsInsurancePlanCodeSequence";
        dict[0x00100101UL] =  "SQPatientsPrimaryLanguageCodeSequence";
        dict[0x00100102UL] =  "SQPatientsPrimaryLanguageCodeModifierSequence";
        dict[0x00101000UL] =  "LOOtherPatientIDs";
        dict[0x00101001UL] =  "PNOtherPatientNames";
        dict[0x00101005UL] =  "PNPatientsBirthName";
        dict[0x00101010UL] =  "ASPatientsAge";
        dict[0x00101020UL] =  "DSPatientsSize";
        dict[0x00101030UL] =  "DSPatientsWeight";
        dict[0x00101040UL] =  "LOPatientsAddress";
        dict[0x00101060UL] =  "PNPatientsMothersBirthName";
        dict[0x00101080UL] =  "LOMilitaryRank";
        dict[0x00101081UL] =  "LOBranchofService";
        dict[0x00101090UL] =  "LOMedicalRecordLocator";
        dict[0x00102000UL] =  "LOMedicalAlerts";
        dict[0x00102110UL] =  "LOContrastAllergies";
        dict[0x00102150UL] =  "LOCountryofResidence";
        dict[0x00102152UL] =  "LORegionofResidence";
        dict[0x00102154UL] =  "SHPatientsTelephoneNumbers";
        dict[0x00102160UL] =  "SHEthnicGroup";
        dict[0x00102180UL] =  "SHOccupation";
        dict[0x001021A0UL] =  "CSSmokingStatus";
        dict[0x001021B0UL] =  "LTAdditionalPatientHistory";
        dict[0x001021C0UL] =  "USPregnancyStatus";
        dict[0x001021D0UL] =  "DALastMenstrualDate";
        dict[0x001021F0UL] =  "LOPatientsReligiousPreference";
        dict[0x00104000UL] =  "LTPatientComments";
        dict[0x00180010UL] =  "LOContrastBolusAgent";
        dict[0x00180012UL] =  "SQContrastBolusAgentSequence";
        dict[0x00180014UL] =  "SQContrastBolusAdministrationRouteSequence";
        dict[0x00180015UL] =  "CSBodyPartExamined";
        dict[0x00180020UL] =  "CSScanningSequence";
        dict[0x00180021UL] =  "CSSequenceVariant";
        dict[0x00180022UL] =  "CSScanOptions";
        dict[0x00180023UL] =  "CSMRAcquisitionType";
        dict[0x00180024UL] =  "SHSequenceName";
        dict[0x00180025UL] =  "CSAngioFlag";
        dict[0x00180026UL] =  "SQInterventionDrugInformationSequence";
        dict[0x00180027UL] =  "TMInterventionDrugStopTime";
        dict[0x00180028UL] =  "DSInterventionDrugDose";
        dict[0x00180029UL] =  "SQInterventionDrugCodeSequence";
        dict[0x0018002AUL] =  "SQAdditionalDrugSequence";
        dict[0x00180031UL] =  "LORadiopharmaceutical";
        dict[0x00180034UL] =  "LOInterventionDrugName";
        dict[0x00180035UL] =  "TMInterventionDrugStartTime";
        dict[0x00180036UL] =  "SQInterventionalTherapySequence";
        dict[0x00180037UL] =  "CSTherapyType";
        dict[0x00180038UL] =  "CSInterventionalStatus";
        dict[0x00180039UL] =  "CSTherapyDescription";
        dict[0x00180040UL] =  "ISCineRate";
        dict[0x00180050UL] =  "DSSliceThickness";
        dict[0x00180060UL] =  "DSKVP";
        dict[0x00180070UL] =  "ISCountsAccumulated";
        dict[0x00180071UL] =  "CSAcquisitionTerminationCondition";
        dict[0x00180072UL] =  "DSEffectiveSeriesDuration";
        dict[0x00180073UL] =  "CSAcquisitionStartCondition";
        dict[0x00180074UL] =  "ISAcquisitionStartConditionData";
        dict[0x00180075UL] =  "ISAcquisitionTerminationConditionData";
        dict[0x00180080UL] =  "DSRepetitionTime";
        dict[0x00180081UL] =  "DSEchoTime";
        dict[0x00180082UL] =  "DSInversionTime";
        dict[0x00180083UL] =  "DSNumberofAverages";
        dict[0x00180084UL] =  "DSImagingFrequency";
        dict[0x00180085UL] =  "SHImagedNucleus";
        dict[0x00180086UL] =  "ISEchoNumbers";
        dict[0x00180087UL] =  "DSMagneticFieldStrength";
        dict[0x00180088UL] =  "DSSpacingBetweenSlices";
        dict[0x00180089UL] =  "ISNumberofPhaseEncodingSteps";
        dict[0x00180090UL] =  "DSDataCollectionDiameter";
        dict[0x00180091UL] =  "ISEchoTrainLength";
        dict[0x00180093UL] =  "DSPercentSampling";
        dict[0x00180094UL] =  "DSPercentPhaseFieldofView";
        dict[0x00180095UL] =  "DSPixelBandwidth";
        dict[0x00181000UL] =  "LODeviceSerialNumber";
        dict[0x00181004UL] =  "LOPlateID";
        dict[0x00181010UL] =  "LOSecondaryCaptureDeviceID";
        dict[0x00181011UL] =  "LOHardcopyCreationDeviceID";
        dict[0x00181012UL] =  "DADateofSecondaryCapture";
        dict[0x00181014UL] =  "TMTimeofSecondaryCapture";
        dict[0x00181016UL] =  "LOSecondaryCaptureDeviceManufacturer";
        dict[0x00181017UL] =  "LOHardcopyDeviceManufacturer";
        dict[0x00181018UL] =  "LOSecondaryCaptureDeviceManufacturersModelName";
        dict[0x00181019UL] =  "LOSecondaryCaptureDeviceSoftwareVersions";
        dict[0x0018101AUL] =  "LOHardcopyDeviceSoftwareVersion";
        dict[0x0018101BUL] =  "LOHardcopyDeviceManfuacturersModelName";
        dict[0x00181020UL] =  "LOSoftwareVersions";
        dict[0x00181022UL] =  "SHVideoImageFormatAcquired";
        dict[0x00181023UL] =  "LODigitalImageFormatAcquired";
        dict[0x00181030UL] =  "LOProtocolName";
        dict[0x00181040UL] =  "LOContrastBolusRoute";
        dict[0x00181041UL] =  "DSContrastBolusVolume";
        dict[0x00181042UL] =  "TMContrastBolusStartTime";
        dict[0x00181043UL] =  "TMContrastBolusStopTime";
        dict[0x00181044UL] =  "DSContrastBolusTotalDose";
        dict[0x00181045UL] =  "ISSyringeCounts";
        dict[0x00181046UL] =  "DSContrastFlowRates";
        dict[0x00181047UL] =  "DSContrastFlowDurations";
        dict[0x00181048UL] =  "CSContrastBolusIngredient";
        dict[0x00181049UL] =  "DSContrastBolusIngredientConcentration";
        dict[0x00181050UL] =  "DSSpatialResolution";
        dict[0x00181060UL] =  "DSTriggerTime";
        dict[0x00181061UL] =  "LOTriggerSourceorType";
        dict[0x00181062UL] =  "ISNominalInterval";
        dict[0x00181063UL] =  "DSFrameTime";
        dict[0x00181064UL] =  "LOFramingType";
        dict[0x00181065UL] =  "DSFrameTimeVector";
        dict[0x00181066UL] =  "DSFrameDelay";
        dict[0x00181067UL] =  "DSImageTriggerDelay";
        dict[0x00181068UL] =  "DSMultiplexGroupTimeOffset";
        dict[0x00181069UL] =  "DSTriggerTimeOffset";
        dict[0x0018106AUL] =  "CSSynchronizationTrigger";
        dict[0x0018106CUL] =  "USSynchronizationChannel";
        dict[0x0018106EUL] =  "ULTriggerSamplePosition";
        dict[0x00181070UL] =  "LORadiopharmaceuticalRoute";
        dict[0x00181071UL] =  "DSRadiopharmaceuticalVolume";
        dict[0x00181072UL] =  "TMRadiopharmaceuticalStartTime";
        dict[0x00181073UL] =  "TMRadiopharmaceuticalStopTime";
        dict[0x00181074UL] =  "DSRadionuclideTotalDose";
        dict[0x00181075UL] =  "DSRadionuclideHalfLife";
        dict[0x00181076UL] =  "DSRadionuclidePositronFraction";
        dict[0x00181077UL] =  "DSRadiopharmaceuticalSpecificActivity";
        dict[0x00181080UL] =  "CSBeatRejectionFlag";
        dict[0x00181081UL] =  "ISLowRRValue";
        dict[0x00181082UL] =  "ISHighRRValue";
        dict[0x00181083UL] =  "ISIntervalsAcquired";
        dict[0x00181084UL] =  "ISIntervalsRejected";
        dict[0x00181085UL] =  "LOPVCRejection";
        dict[0x00181086UL] =  "ISSkipBeats";
        dict[0x00181088UL] =  "ISHeartRate";
        dict[0x00181090UL] =  "ISCardiacNumberofImages";
        dict[0x00181094UL] =  "ISTriggerWindow";
        dict[0x00181100UL] =  "DSReconstructionDiameter";
        dict[0x00181110UL] =  "DSDistanceSourcetoDetector";
        dict[0x00181111UL] =  "DSDistanceSourcetoPatient";
        dict[0x00181114UL] =  "DSEstimatedRadiographicMagnificationFactor";
        dict[0x00181120UL] =  "DSGantryDetectorTilt";
        dict[0x00181121UL] =  "DSGantryDetectorSlew";
        dict[0x00181130UL] =  "DSTableHeight";
        dict[0x00181131UL] =  "DSTableTraverse";
        dict[0x00181134UL] =  "CSTableMotion";
        dict[0x00181135UL] =  "DSTableVerticalIncrement";
        dict[0x00181136UL] =  "DSTableLateralIncrement";
        dict[0x00181137UL] =  "DSTableLongitudinalIncrement";
        dict[0x00181138UL] =  "DSTableAngle";
        dict[0x0018113AUL] =  "CSTableType";
        dict[0x00181140UL] =  "CSRotationDirection";
        dict[0x00181141UL] =  "DSAngularPosition";
        dict[0x00181142UL] =  "DSRadialPosition";
        dict[0x00181143UL] =  "DSScanArc";
        dict[0x00181144UL] =  "DSAngularStep";
        dict[0x00181145UL] =  "DSCenterofRotationOffset";
        dict[0x00181147UL] =  "CSFieldofViewShape";
        dict[0x00181149UL] =  "ISFieldofViewDimensions";
        dict[0x00181150UL] =  "ISExposureTime";
        dict[0x00181151UL] =  "ISXrayTubeCurrent";
        dict[0x00181152UL] =  "ISExposure";
        dict[0x00181153UL] =  "ISExposureinuAs";
        dict[0x00181154UL] =  "DSAveragePulseWidth";
        dict[0x00181155UL] =  "CSRadiationSetting";
        dict[0x00181156UL] =  "CSRectificationType";
        dict[0x0018115AUL] =  "CSRadiationMode";
        dict[0x0018115EUL] =  "DSImageAreaDoseProduct";
        dict[0x00181160UL] =  "SHFilterType";
        dict[0x00181161UL] =  "LOTypeofFilters";
        dict[0x00181162UL] =  "DSIntensifierSize";
        dict[0x00181164UL] =  "DSImagerPixelSpacing";
        dict[0x00181166UL] =  "CSGrid";
        dict[0x00181170UL] =  "ISGeneratorPower";
        dict[0x00181180UL] =  "SHCollimatorgridName";
        dict[0x00181181UL] =  "CSCollimatorType";
        dict[0x00181182UL] =  "ISFocalDistance";
        dict[0x00181183UL] =  "DSXFocusCenter";
        dict[0x00181184UL] =  "DSYFocusCenter";
        dict[0x00181190UL] =  "DSFocalSpots";
        dict[0x00181191UL] =  "CSAnodeTargetMaterial";
        dict[0x001811A0UL] =  "DSBodyPartThickness";
        dict[0x001811A2UL] =  "DSCompressionForce";
        dict[0x00181200UL] =  "DADateofLastCalibration";
        dict[0x00181201UL] =  "TMTimeofLastCalibration";
        dict[0x00181210UL] =  "SHConvolutionKernel";
        dict[0x00181242UL] =  "ISActualFrameDuration";
        dict[0x00181243UL] =  "ISCountRate";
        dict[0x00181244UL] =  "USPreferredPlaybackSequencing";
        dict[0x00181250UL] =  "SHReceivingCoil";
        dict[0x00181251UL] =  "SHTransmittingCoil";
        dict[0x00181260UL] =  "SHPlateType";
        dict[0x00181261UL] =  "LOPhosphorType";
        dict[0x00181300UL] =  "DSScanVelocity";
        dict[0x00181301UL] =  "CSWholeBodyTechnique";
        dict[0x00181302UL] =  "ISScanLength";
        dict[0x00181310UL] =  "USAcquisitionMatrix";
        dict[0x00181312UL] =  "CSPhaseEncodingDirection";
        dict[0x00181314UL] =  "DSFlipAngle";
        dict[0x00181315UL] =  "CSVariableFlipAngleFlag";
        dict[0x00181316UL] =  "DSSAR";
        dict[0x00181318UL] =  "DSdBdt";
        dict[0x00181400UL] =  "LOAcquisitionDeviceProcessingDescription";
        dict[0x00181401UL] =  "LOAcquisitionDeviceProcessingCode";
        dict[0x00181402UL] =  "CSCassetteOrientation";
        dict[0x00181403UL] =  "CSCassetteSize";
        dict[0x00181404UL] =  "USExposuresonPlate";
        dict[0x00181405UL] =  "ISRelativeXrayExposure";
        dict[0x00181450UL] =  "CSColumnAngulation";
        dict[0x00181460UL] =  "DSTomoLayerHeight";
        dict[0x00181470UL] =  "DSTomoAngle";
        dict[0x00181480UL] =  "DSTomoTime";
        dict[0x00181490UL] =  "CSTomoType";
        dict[0x00181491UL] =  "CSTomoClass";
        dict[0x00181495UL] =  "ISNumberofTomosynthesisSourceImages";
        dict[0x00181500UL] =  "CSPositionerMotion";
        dict[0x00181508UL] =  "CSPositionerType";
        dict[0x00181510UL] =  "DSPositionerPrimaryAngle";
        dict[0x00181511UL] =  "DSPositionerSecondaryAngle";
        dict[0x00181520UL] =  "DSPositionerPrimaryAngleIncrement";
        dict[0x00181521UL] =  "DSPositionerSecondaryAngleIncrement";
        dict[0x00181530UL] =  "DSDetectorPrimaryAngle";
        dict[0x00181531UL] =  "DSDetectorSecondaryAngle";
        dict[0x00181600UL] =  "CSShutterShape";
        dict[0x00181602UL] =  "ISShutterLeftVerticalEdge";
        dict[0x00181604UL] =  "ISShutterRightVerticalEdge";
        dict[0x00181606UL] =  "ISShutterUpperHorizontalEdge";
        dict[0x00181608UL] =  "ISShutterLowerHorizontalEdge";
        dict[0x00181610UL] =  "ISCenterofCircularShutter";
        dict[0x00181612UL] =  "ISRadiusofCircularShutter";
        dict[0x00181620UL] =  "ISVerticesofthePolygonalShutter";
        dict[0x00181622UL] =  "USShutterPresentationValue";
        dict[0x00181623UL] =  "USShutterOverlayGroup";
        dict[0x00181700UL] =  "CSCollimatorShape";
        dict[0x00181702UL] =  "ISCollimatorLeftVerticalEdge";
        dict[0x00181704UL] =  "ISCollimatorRightVerticalEdge";
        dict[0x00181706UL] =  "ISCollimatorUpperHorizontalEdge";
        dict[0x00181708UL] =  "ISCollimatorLowerHorizontalEdge";
        dict[0x00181710UL] =  "ISCenterofCircularCollimator";
        dict[0x00181712UL] =  "ISRadiusofCircularCollimator";
        dict[0x00181720UL] =  "ISVerticesofthePolygonalCollimator";
        dict[0x00181800UL] =  "CSAcquisitionTimeSynchronized";
        dict[0x00181801UL] =  "SHTimeSource";
        dict[0x00181802UL] =  "CSTimeDistributionProtocol";
        dict[0x00182001UL] =  "ISPageNumberVector";
        dict[0x00182002UL] =  "SHFrameLabelVector";
        dict[0x00182003UL] =  "DSFramePrimaryAngleVector";
        dict[0x00182004UL] =  "DSFrameSecondaryAngleVector";
        dict[0x00182005UL] =  "DSSliceLocationVector";
        dict[0x00182006UL] =  "SHDisplayWindowLabelVector";
        dict[0x00182010UL] =  "DSNominalScannedPixelSpacing";
        dict[0x00182020UL] =  "CSDigitizingDeviceTransportDirection";
        dict[0x00182030UL] =  "DSRotationofScannedFilm";
        dict[0x00183100UL] =  "CSIVUSAcquisition";
        dict[0x00183101UL] =  "DSIVUSPullbackRate";
        dict[0x00183102UL] =  "DSIVUSGatedRate";
        dict[0x00183103UL] =  "ISIVUSPullbackStartFrameNumber";
        dict[0x00183104UL] =  "ISIVUSPullbackStopFrameNumber";
        dict[0x00183105UL] =  "ISLesionNumber";
        dict[0x00185000UL] =  "SHOutputPower";
        dict[0x00185010UL] =  "LOTransducerData";
        dict[0x00185012UL] =  "DSFocusDepth";
        dict[0x00185020UL] =  "LOProcessingFunction";
        dict[0x00185021UL] =  "LOPostprocessingFunction";
        dict[0x00185022UL] =  "DSMechanicalIndex";
        dict[0x00185024UL] =  "DSThermalIndex";
        dict[0x00185026UL] =  "DSCranialThermalIndex";
        dict[0x00185027UL] =  "DSSoftTissueThermalIndex";
        dict[0x00185028UL] =  "DSSoftTissuefocusThermalIndex";
        dict[0x00185029UL] =  "DSSoftTissuesurfaceThermalIndex";
        dict[0x00185050UL] =  "ISDepthofScanField";
        dict[0x00185100UL] =  "CSPatientPosition";
        dict[0x00185101UL] =  "CSViewPosition";
        dict[0x00185104UL] =  "SQProjectionEponymousNameCodeSequence";
        dict[0x00185210UL] =  "DSImageTransformationMatrix";
        dict[0x00185212UL] =  "DSImageTranslationVector";
        dict[0x00186000UL] =  "DSSensitivity";
        dict[0x00186011UL] =  "SQSequenceofUltrasoundRegions";
        dict[0x00186012UL] =  "USRegionSpatialFormat";
        dict[0x00186014UL] =  "USRegionDataType";
        dict[0x00186016UL] =  "ULRegionFlags";
        dict[0x00186018UL] =  "ULRegionLocationMinX0";
        dict[0x0018601AUL] =  "ULRegionLocationMinY0";
        dict[0x0018601CUL] =  "ULRegionLocationMaxX1";
        dict[0x0018601EUL] =  "ULRegionLocationMaxY1";
        dict[0x00186020UL] =  "SLReferencePixelX0";
        dict[0x00186022UL] =  "SLReferencePixelY0";
        dict[0x00186024UL] =  "USPhysicalUnitsXDirection";
        dict[0x00186026UL] =  "USPhysicalUnitsYDirection";
        dict[0x00186028UL] =  "FDReferencePixelPhysicalValueX";
        dict[0x0018602AUL] =  "FDReferencePixelPhysicalValueY";
        dict[0x0018602CUL] =  "FDPhysicalDeltaX";
        dict[0x0018602EUL] =  "FDPhysicalDeltaY";
        dict[0x00186030UL] =  "ULTransducerFrequency";
        dict[0x00186031UL] =  "CSTransducerType";
        dict[0x00186032UL] =  "ULPulseRepetitionFrequency";
        dict[0x00186034UL] =  "FDDopplerCorrectionAngle";
        dict[0x00186036UL] =  "FDSteeringAngle";
        dict[0x00186038UL] =  "ULDopplerSampleVolumeXPosition";
        dict[0x0018603AUL] =  "ULDopplerSampleVolumeYPosition";
        dict[0x0018603CUL] =  "ULTMLinePositionX0";
        dict[0x0018603EUL] =  "ULTMLinePositionY0";
        dict[0x00186040UL] =  "ULTMLinePositionX1";
        dict[0x00186042UL] =  "ULTMLinePositionY1";
        dict[0x00186044UL] =  "USPixelComponentOrganization";
        dict[0x00186046UL] =  "ULPixelComponentMask";
        dict[0x00186048UL] =  "ULPixelComponentRangeStart";
        dict[0x0018604AUL] =  "ULPixelComponentRangeStop";
        dict[0x0018604CUL] =  "USPixelComponentPhysicalUnits";
        dict[0x0018604EUL] =  "USPixelComponentDataType";
        dict[0x00186050UL] =  "ULNumberofTableBreakPoints";
        dict[0x00186052UL] =  "ULTableofXBreakPoints";
        dict[0x00186054UL] =  "FDTableofYBreakPoints";
        dict[0x00186056UL] =  "ULNumberofTableEntries";
        dict[0x00186058UL] =  "ULTableofPixelValues";
        dict[0x0018605AUL] =  "FLTableofParameterValues";
        dict[0x00187000UL] =  "CSDetectorConditionsNominalFlag";
        dict[0x00187001UL] =  "DSDetectorTemperature";
        dict[0x00187004UL] =  "CSDetectorType";
        dict[0x00187005UL] =  "CSDetectorConfiguration";
        dict[0x00187006UL] =  "LTDetectorDescription";
        dict[0x00187008UL] =  "LTDetectorMode";
        dict[0x0018700AUL] =  "SHDetectorID";
        dict[0x0018700CUL] =  "DADateofLastDetectorCalibration";
        dict[0x0018700EUL] =  "TMTimeofLastDetectorCalibration";
        dict[0x00187010UL] =  "ISExposuresonDetectorSinceLastCalibration";
        dict[0x00187011UL] =  "ISExposuresonDetectorSinceManufactured";
        dict[0x00187012UL] =  "DSDetectorTimeSinceLastExposure";
        dict[0x00187014UL] =  "DSDetectorActiveTime";
        dict[0x00187016UL] =  "DSDetectorActivationOffsetFromExposure";
        dict[0x0018701AUL] =  "DSDetectorBinning";
        dict[0x00187020UL] =  "DSDetectorElementPhysicalSize";
        dict[0x00187022UL] =  "DSDetectorElementSpacing";
        dict[0x00187024UL] =  "CSDetectorActiveShape";
        dict[0x00187026UL] =  "DSDetectorActiveDimensions";
        dict[0x00187028UL] =  "DSDetectorActiveOrigin";
        dict[0x00187030UL] =  "DSFieldofViewOrigin";
        dict[0x00187032UL] =  "DSFieldofViewRotation";
        dict[0x00187034UL] =  "CSFieldofViewHorizontalFlip";
        dict[0x00187040UL] =  "LTGridAbsorbingMaterial";
        dict[0x00187041UL] =  "LTGridSpacingMaterial";
        dict[0x00187042UL] =  "DSGridThickness";
        dict[0x00187044UL] =  "DSGridPitch";
        dict[0x00187046UL] =  "ISGridAspectRatio";
        dict[0x00187048UL] =  "DSGridPeriod";
        dict[0x0018704CUL] =  "DSGridFocalDistance";
        dict[0x00187050UL] =  "CSFilterMaterial";
        dict[0x00187052UL] =  "DSFilterThicknessMinimum";
        dict[0x00187054UL] =  "DSFilterThicknessMaximum";
        dict[0x00187060UL] =  "CSExposureControlMode";
        dict[0x00187062UL] =  "LTExposureControlModeDescription";
        dict[0x00187064UL] =  "CSExposureStatus";
        dict[0x00187065UL] =  "DSPhototimerSetting";
        dict[0x00188150UL] =  "DSExposureTime";
        dict[0x00188151UL] =  "DSXRayTubeCurrent";
        dict[0x0020000DUL] =  "UIStudyInstanceUID";
        dict[0x0020000EUL] =  "UISeriesInstanceUID";
        dict[0x00200010UL] =  "SHStudyID";
        dict[0x00200011UL] =  "ISSeriesNumber";
        dict[0x00200012UL] =  "ISAcquisitionNumber";
        dict[0x00200013UL] =  "ISInstanceNumber";
        dict[0x00200019UL] =  "ISItemNumber";
        dict[0x00200020UL] =  "CSPatientOrientation";
        dict[0x00200022UL] =  "ISOverlayNumber";
        dict[0x00200024UL] =  "ISCurveNumber";
        dict[0x00200026UL] =  "ISLookupTableNumber";
        dict[0x00200032UL] =  "DSImagePositionPatient";
        dict[0x00200037UL] =  "DSImageOrientationPatient";
        dict[0x00200052UL] =  "UIFrameofReferenceUID";
        dict[0x00200060UL] =  "CSLaterality";
        dict[0x00200062UL] =  "CSImageLaterality";
        dict[0x00200100UL] =  "ISTemporalPositionIdentifier";
        dict[0x00200105UL] =  "ISNumberofTemporalPositions";
        dict[0x00200110UL] =  "DSTemporalResolution";
        dict[0x00200200UL] =  "UISynchronizationFrameofReferenceUID";
        dict[0x00201000UL] =  "ISSeriesinStudy";
        dict[0x00201002UL] =  "ISImagesinAcquisition";
        dict[0x00201004UL] =  "ISAcquisitionsinStudy";
        dict[0x00201040UL] =  "LOPositionReferenceIndicator";
        dict[0x00201041UL] =  "DSSliceLocation";
        dict[0x00201070UL] =  "ISOtherStudyNumbers";
        dict[0x00201200UL] =  "ISNumberofPatientRelatedStudies";
        dict[0x00201202UL] =  "ISNumberofPatientRelatedSeries";
        dict[0x00201204UL] =  "ISNumberofPatientRelatedInstances";
        dict[0x00201206UL] =  "ISNumberofStudyRelatedSeries";
        dict[0x00201208UL] =  "ISNumberofStudyRelatedInstances";
        dict[0x00201209UL] =  "ISNumberofSeriesRelatedInstances";
        dict[0x00204000UL] =  "LTImageComments";
        dict[0x00280002UL] =  "USSamplesperPixel";
        dict[0x00280004UL] =  "CSPhotometricInterpretation";
        dict[0x00280006UL] =  "USPlanarConfiguration";
        dict[0x00280008UL] =  "ISNumberofFrames";
        dict[0x00280009UL] =  "ATFrameIncrementPointer";
        dict[0x00280010UL] =  "USRows";
        dict[0x00280011UL] =  "USColumns";
        dict[0x00280012UL] =  "USPlanes";
        dict[0x00280014UL] =  "USUltrasoundColorDataPresent";
        dict[0x00280030UL] =  "DSPixelSpacing";
        dict[0x00280031UL] =  "DSZoomFactor";
        dict[0x00280032UL] =  "DSZoomCenter";
        dict[0x00280034UL] =  "ISPixelAspectRatio";
        dict[0x00280051UL] =  "CSCorrectedImage";
        dict[0x00280100UL] =  "USBitsAllocated";
        dict[0x00280101UL] =  "USBitsStored";
        dict[0x00280102UL] =  "USHighBit";
        dict[0x00280103UL] =  "USPixelRepresentation";
        dict[0x00280106UL] =  "USSSSmallestImagePixelValue";
        dict[0x00280107UL] =  "USSSLargestImagePixelValue";
        dict[0x00280108UL] =  "USSSSmallestPixelValueinSeries";
        dict[0x00280109UL] =  "USSSLargestPixelValueinSeries";
        dict[0x00280110UL] =  "USSSSmallestImagePixelValueinPlane";
        dict[0x00280111UL] =  "USSSLargestImagePixelValueinPlane";
        dict[0x00280120UL] =  "USSSPixelPaddingValue";
        dict[0x00280300UL] =  "CSQualityControlImage";
        dict[0x00280301UL] =  "CSBurnedInAnnotation";
        dict[0x00281040UL] =  "CSPixelIntensityRelationship";
        dict[0x00281041UL] =  "SSPixelIntensityRelationshipSign";
        dict[0x00281050UL] =  "DSWindowCenter";
        dict[0x00281051UL] =  "DSWindowWidth";
        dict[0x00281052UL] =  "DSRescaleIntercept";
        dict[0x00281053UL] =  "DSRescaleSlope";
        dict[0x00281054UL] =  "LORescaleType";
        dict[0x00281055UL] =  "LOWindowCenterWidthExplanation";
        dict[0x00281090UL] =  "CSRecommendedViewingMode";
        dict[0x00281101UL] =  "USSSRedPaletteColorLookupTableDescriptor";
        dict[0x00281102UL] =  "USSSGreenPaletteColorLookupTableDescriptor";
        dict[0x00281103UL] =  "USSSBluePaletteColorLookupTableDescriptor";
        dict[0x00281199UL] =  "UIPaletteColorLookupTableUID";
        dict[0x00281201UL] =  "OWRedPaletteColorLookupTableData";
        dict[0x00281202UL] =  "OWGreenPaletteColorLookupTableData";
        dict[0x00281203UL] =  "OWBluePaletteColorLookupTableData";
        dict[0x00281221UL] =  "OWSegmentedRedPaletteColorLookupTableData";
        dict[0x00281222UL] =  "OWSegmentedGreenPaletteColorLookupTableData";
        dict[0x00281223UL] =  "OWSegmentedBluePaletteColorLookupTableData";
        dict[0x00281300UL] =  "CSImplantPresent";
        dict[0x00281350UL] =  "CSPartialView";
        dict[0x00281351UL] =  "STPartialViewDescription";
        dict[0x00282110UL] =  "CSLossyImageCompression";
        dict[0x00282112UL] =  "DSLossyImageCompressionRatio";
        dict[0x00283000UL] =  "SQModalityLUTSequence";
        dict[0x00283002UL] =  "USSSLUTDescriptor";
        dict[0x00283003UL] =  "LOLUTExplanation";
        dict[0x00283004UL] =  "LOModalityLUTType";
        dict[0x00283006UL] =  "USSSOWLUTData";
        dict[0x00283010UL] =  "SQVOILUTSequence";
        dict[0x00283110UL] =  "SQSoftcopyVOILUTSequence";
        dict[0x00285000UL] =  "SQBiPlaneAcquisitionSequence";
        dict[0x00286010UL] =  "USRepresentativeFrameNumber";
        dict[0x00286020UL] =  "USFrameNumbersofInterestFOI";
        dict[0x00286022UL] =  "LOFramesofInterestDescription";
        dict[0x00286030UL] =  "USMaskPointers";
        dict[0x00286040UL] =  "USRWavePointer";
        dict[0x00286100UL] =  "SQMaskSubtractionSequence";
        dict[0x00286101UL] =  "CSMaskOperation";
        dict[0x00286102UL] =  "USApplicableFrameRange";
        dict[0x00286110UL] =  "USMaskFrameNumbers";
        dict[0x00286112UL] =  "USContrastFrameAveraging";
        dict[0x00286114UL] =  "FLMaskSubpixelShift";
        dict[0x00286120UL] =  "SSTIDOffset";
        dict[0x00286190UL] =  "STMaskOperationExplanation";
        dict[0x0032000AUL] =  "CSStudyStatusID";
        dict[0x0032000CUL] =  "CSStudyPriorityID";
        dict[0x00320012UL] =  "LOStudyIDIssuer";
        dict[0x00320032UL] =  "DAStudyVerifiedDate";
        dict[0x00320033UL] =  "TMStudyVerifiedTime";
        dict[0x00320034UL] =  "DAStudyReadDate";
        dict[0x00320035UL] =  "TMStudyReadTime";
        dict[0x00321000UL] =  "DAScheduledStudyStartDate";
        dict[0x00321001UL] =  "TMScheduledStudyStartTime";
        dict[0x00321010UL] =  "DAScheduledStudyStopDate";
        dict[0x00321011UL] =  "TMScheduledStudyStopTime";
        dict[0x00321020UL] =  "LOScheduledStudyLocation";
        dict[0x00321021UL] =  "AEScheduledStudyLocationAETitles";
        dict[0x00321030UL] =  "LOReasonforStudy";
        dict[0x00321032UL] =  "PNRequestingPhysician";
        dict[0x00321033UL] =  "LORequestingService";
        dict[0x00321040UL] =  "DAStudyArrivalDate";
        dict[0x00321041UL] =  "TMStudyArrivalTime";
        dict[0x00321050UL] =  "DAStudyCompletionDate";
        dict[0x00321051UL] =  "TMStudyCompletionTime";
        dict[0x00321055UL] =  "CSStudyComponentStatusID";
        dict[0x00321060UL] =  "LORequestedProcedureDescription";
        dict[0x00321064UL] =  "SQRequestedProcedureCodeSequence";
        dict[0x00321070UL] =  "LORequestedContrastAgent";
        dict[0x00324000UL] =  "LTStudyComments";
        dict[0x00380004UL] =  "SQReferencedPatientAliasSequence";
        dict[0x00380008UL] =  "CSVisitStatusID";
        dict[0x00380010UL] =  "LOAdmissionID";
        dict[0x00380011UL] =  "LOIssuerofAdmissionID";
        dict[0x00380016UL] =  "LORouteofAdmissions";
        dict[0x0038001AUL] =  "DAScheduledAdmissionDate";
        dict[0x0038001BUL] =  "TMScheduledAdmissionTime";
        dict[0x0038001CUL] =  "DAScheduledDischargeDate";
        dict[0x0038001DUL] =  "TMScheduledDischargeTime";
        dict[0x0038001EUL] =  "LOScheduledPatientInstitutionResidence";
        dict[0x00380020UL] =  "DAAdmittingDate";
        dict[0x00380021UL] =  "TMAdmittingTime";
        dict[0x00380030UL] =  "DADischargeDate";
        dict[0x00380032UL] =  "TMDischargeTime";
        dict[0x00380040UL] =  "LODischargeDiagnosisDescription";
        dict[0x00380044UL] =  "SQDischargeDiagnosisCodeSequence";
        dict[0x00380050UL] =  "LOSpecialNeeds";
        dict[0x00380300UL] =  "LOCurrentPatientLocation";
        dict[0x00380400UL] =  "LOPatientsInstitutionResidence";
        dict[0x00380500UL] =  "LOPatientState";
        dict[0x00384000UL] =  "LTVisitComments";
        dict[0x003A0004UL] =  "CSWaveformOriginality";
        dict[0x003A0005UL] =  "USNumberofWaveformChannels";
        dict[0x003A0010UL] =  "ULNumberofWaveformSamples";
        dict[0x003A001AUL] =  "DSSamplingFrequency";
        dict[0x003A0020UL] =  "SHMultiplexGroupLabel";
        dict[0x003A0200UL] =  "SQChannelDefinitionSequence";
        dict[0x003A0202UL] =  "ISWaveformChannelNumber";
        dict[0x003A0203UL] =  "SHChannelLabel";
        dict[0x003A0205UL] =  "CSChannelStatus";
        dict[0x003A0208UL] =  "SQChannelSourceSequence";
        dict[0x003A0209UL] =  "SQChannelSourceModifiersSequence";
        dict[0x003A020AUL] =  "SQSourceWaveformSequence";
        dict[0x003A020CUL] =  "LOChannelDerivationDescription";
        dict[0x003A0210UL] =  "DSChannelSensitivity";
        dict[0x003A0211UL] =  "SQChannelSensitivityUnitsSequence";
        dict[0x003A0212UL] =  "DSChannelSensitivityCorrectionFactor";
        dict[0x003A0213UL] =  "DSChannelBaseline";
        dict[0x003A0214UL] =  "DSChannelTimeSkew";
        dict[0x003A0215UL] =  "DSChannelSampleSkew";
        dict[0x003A0218UL] =  "DSChannelOffset";
        dict[0x003A021AUL] =  "USWaveformBitsStored";
        dict[0x003A0220UL] =  "DSFilterLowFrequency";
        dict[0x003A0221UL] =  "DSFilterHighFrequency";
        dict[0x003A0222UL] =  "DSNotchFilterFrequency";
        dict[0x003A0223UL] =  "DSNotchFilterBandwidth";
        dict[0x00400001UL] =  "AEScheduledStationAETitle";
        dict[0x00400002UL] =  "DAScheduledProcedureStepStartDate";
        dict[0x00400003UL] =  "TMScheduledProcedureStepStartTime";
        dict[0x00400004UL] =  "DAScheduledProcedureStepEndDate";
        dict[0x00400005UL] =  "TMScheduledProcedureStepEndTime";
        dict[0x00400006UL] =  "PNScheduledPerformingPhysiciansName";
        dict[0x00400007UL] =  "LOScheduledProcedureStepDescription";
        dict[0x00400008UL] =  "SQScheduledProtocolCodeSequence";
        dict[0x00400009UL] =  "SHScheduledProcedureStepID";
        dict[0x0040000AUL] =  "SQStageCodeSequence";
        dict[0x00400010UL] =  "SHScheduledStationName";
        dict[0x00400011UL] =  "SHScheduledProcedureStepLocation";
        dict[0x00400012UL] =  "LOPreMedication";
        dict[0x00400020UL] =  "CSScheduledProcedureStepStatus";
        dict[0x00400100UL] =  "SQScheduledProcedureStepSequence";
        dict[0x00400220UL] =  "SQReferencedNonImageCompositeSOPInstanceSequence";
        dict[0x00400241UL] =  "AEPerformedStationAETitle";
        dict[0x00400242UL] =  "SHPerformedStationName";
        dict[0x00400243UL] =  "SHPerformedLocation";
        dict[0x00400244UL] =  "DAPerformedProcedureStepStartDate";
        dict[0x00400245UL] =  "TMPerformedProcedureStepStartTime";
        dict[0x00400250UL] =  "DAPerformedProcedureStepEndDate";
        dict[0x00400251UL] =  "TMPerformedProcedureStepEndTime";
        dict[0x00400252UL] =  "CSPerformedProcedureStepStatus";
        dict[0x00400253UL] =  "SHPerformedProcedureStepID";
        dict[0x00400254UL] =  "LOPerformedProcedureStepDescription";
        dict[0x00400255UL] =  "LOPerformedProcedureTypeDescription";
        dict[0x00400260UL] =  "SQPerformedProtocolCodeSequence";
        dict[0x00400270UL] =  "SQScheduledStepAttributesSequence";
        dict[0x00400275UL] =  "SQRequestAttributesSequence";
        dict[0x00400280UL] =  "STCommentsonthePerformedProcedureStep";
        dict[0x00400293UL] =  "SQQuantitySequence";
        dict[0x00400294UL] =  "DSQuantity";
        dict[0x00400295UL] =  "SQMeasuringUnitsSequence";
        dict[0x00400296UL] =  "SQBillingItemSequence";
        dict[0x00400300UL] =  "USTotalTimeofFluoroscopy";
        dict[0x00400301UL] =  "USTotalNumberofExposures";
        dict[0x00400302UL] =  "USEntranceDose";
        dict[0x00400303UL] =  "USExposedArea";
        dict[0x00400306UL] =  "DSDistanceSourcetoEntrance";
        dict[0x00400307UL] =  "DSDistanceSourcetoSupport";
        dict[0x0040030EUL] =  "SQExposureDoseSequence";
        dict[0x00400310UL] =  "STCommentsonRadiationDose";
        dict[0x00400312UL] =  "DSXRayOutput";
        dict[0x00400314UL] =  "DSHalfValueLayer";
        dict[0x00400316UL] =  "DSOrganDose";
        dict[0x00400318UL] =  "CSOrganExposed";
        dict[0x00400320UL] =  "SQBillingProcedureStepSequence";
        dict[0x00400321UL] =  "SQFilmConsumptionSequence";
        dict[0x00400324UL] =  "SQBillingSuppliesandDevicesSequence";
        dict[0x00400330UL] =  "SQReferencedProcedureStepSequence";
        dict[0x00400340UL] =  "SQPerformedSeriesSequence";
        dict[0x00400400UL] =  "LTCommentsontheScheduledProcedureStep";
        dict[0x0040050AUL] =  "LOSpecimenAccessionNumber";
        dict[0x00400550UL] =  "SQSpecimenSequence";
        dict[0x00400551UL] =  "LOSpecimenIdentifier";
        dict[0x00400555UL] =  "SQAcquisitionContextSequence";
        dict[0x00400556UL] =  "STAcquisitionContextDescription";
        dict[0x0040059AUL] =  "SQSpecimenTypeCodeSequence";
        dict[0x004006FAUL] =  "LOSlideIdentifier";
        dict[0x0040071AUL] =  "SQImageCenterPointCoordinatesSequence";
        dict[0x0040072AUL] =  "DSXoffsetinSlideCoordinateSystem";
        dict[0x0040073AUL] =  "DSYoffsetinSlideCoordinateSystem";
        dict[0x0040074AUL] =  "DSZoffsetinSlideCoordinateSystem";
        dict[0x004008D8UL] =  "SQPixelSpacingSequence";
        dict[0x004008DAUL] =  "SQCoordinateSystemAxisCodeSequence";
        dict[0x004008EAUL] =  "SQMeasurementUnitsCodeSequence";
        dict[0x00401001UL] =  "SHRequestedProcedureID";
        dict[0x00401002UL] =  "LOReasonfortheRequestedProcedure";
        dict[0x00401003UL] =  "SHRequestedProcedurePriority";
        dict[0x00401004UL] =  "LOPatientTransportArrangements";
        dict[0x00401005UL] =  "LORequestedProcedureLocation";
        dict[0x00401008UL] =  "LOConfidentialityCode";
        dict[0x00401009UL] =  "SHReportingPriority";
        dict[0x00401010UL] =  "PNNamesofIntendedRecipientsofResults";
        dict[0x00401400UL] =  "LTRequestedProcedureComments";
        dict[0x00402001UL] =  "LOReasonfortheImagingServiceRequest";
        dict[0x00402004UL] =  "DAIssueDateofImagingServiceRequest";
        dict[0x00402005UL] =  "TMIssueTimeofImagingServiceRequest";
        dict[0x00402008UL] =  "PNOrderEnteredBy";
        dict[0x00402009UL] =  "SHOrderEnterersLocation";
        dict[0x00402010UL] =  "SHOrderCallbackPhoneNumber";
        dict[0x00402016UL] =  "LOPlacerOrderNumberImagingServiceRequest";
        dict[0x00402017UL] =  "LOFillerOrderNumberImagingServiceRequest";
        dict[0x00402400UL] =  "LTImagingServiceRequestComments";
        dict[0x00403001UL] =  "LOConfidentialityConstraintonPatientDataDescription";
        dict[0x00404001UL] =  "CSGeneralPurposeScheduledProcedureStepStatus";
        dict[0x00404002UL] =  "CSGeneralPurposePerformedProcedureStepStatus";
        dict[0x00404003UL] =  "CSGeneralPurposeScheduledProcedureStepPriority";
        dict[0x00404004UL] =  "SQScheduledProcessingApplicationsCodeSequence";
        dict[0x00404005UL] =  "DTScheduledProcedureStepStartDateandTime";
        dict[0x00404006UL] =  "CSMultipleCopiesFlag";
        dict[0x00404007UL] =  "SQPerformedProcessingApplicationsCodeSequence";
        dict[0x00404009UL] =  "SQHumanPerformerCodeSequence";
        dict[0x00404011UL] =  "DTExpectedCompletionDateandTime";
        dict[0x00404015UL] =  "SQResultingGeneralPurposePerformedProcedureStepsSequence";
        dict[0x00404016UL] =  "SQReferencedGeneralPurposeScheduledProcedureStepSequence";
        dict[0x00404018UL] =  "SQScheduledWorkitemCodeSequence";
        dict[0x00404019UL] =  "SQPerformedWorkitemCodeSequence";
        dict[0x00404020UL] =  "CSInputAvailabilityFlag";
        dict[0x00404021UL] =  "SQInputInformationSequence";
        dict[0x00404022UL] =  "SQRelevantInformationSequence";
        dict[0x00404023UL] =  "UIReferencedGeneralPurposeScheduledProcedureStepTransactionUID";
        dict[0x00404025UL] =  "SQScheduledStationNameCodeSequence";
        dict[0x00404026UL] =  "SQScheduledStationClassCodeSequence";
        dict[0x00404027UL] =  "SQScheduledStationGeographicLocationCodeSequence";
        dict[0x00404028UL] =  "SQPerformedStationNameCodeSequence";
        dict[0x00404029UL] =  "SQPerformedStationClassCodeSequence";
        dict[0x00404030UL] =  "SQPerformedStationGeographicLocationCodeSequence";
        dict[0x00404031UL] =  "SQRequestedSubsequentWorkitemCodeSequence";
        dict[0x00404032UL] =  "SQNonDICOMOutputCodeSequence";
        dict[0x00404033UL] =  "SQOutputInformationSequence";
        dict[0x00404034UL] =  "SQScheduledHumanPerformersSequence";
        dict[0x00404035UL] =  "SQActualHumanPerformersSequence";
        dict[0x00404036UL] =  "LOHumanPerformersOrganization";
        dict[0x00404037UL] =  "PNHumanPerformersName";
        dict[0x00408302UL] =  "DSEntranceDoseinmGy";
        dict[0x0040A010UL] =  "CSRelationshipType";
        dict[0x0040A027UL] =  "LOVerifyingOrganization";
        dict[0x0040A030UL] =  "DTVerificationDateTime";
        dict[0x0040A032UL] =  "DTObservationDateTime";
        dict[0x0040A040UL] =  "CSValueType";
        dict[0x0040A043UL] =  "SQConceptnameCodeSequence";
        dict[0x0040A050UL] =  "CSContinuityOfContent";
        dict[0x0040A073UL] =  "SQVerifyingObserverSequence";
        dict[0x0040A075UL] =  "PNVerifyingObserverName";
        dict[0x0040A088UL] =  "SQVerifyingObserverIdentificationCodeSequence";
        dict[0x0040A0B0UL] =  "USReferencedWaveformChannels";
        dict[0x0040A120UL] =  "DTDateTime";
        dict[0x0040A121UL] =  "DADate";
        dict[0x0040A122UL] =  "TMTime";
        dict[0x0040A123UL] =  "PNPersonName";
        dict[0x0040A124UL] =  "UIUID";
        dict[0x0040A130UL] =  "CSTemporalRangeType";
        dict[0x0040A132UL] =  "ULReferencedSamplePositions";
        dict[0x0040A136UL] =  "USReferencedFrameNumbers";
        dict[0x0040A138UL] =  "DSReferencedTimeOffsets";
        dict[0x0040A13AUL] =  "DTReferencedDatetime";
        dict[0x0040A160UL] =  "UTTextValue";
        dict[0x0040A168UL] =  "SQConceptCodeSequence";
        dict[0x0040A170UL] =  "SQPurposeofReferenceCodeSequence";
        dict[0x0040A180UL] =  "USAnnotationGroupNumber";
        dict[0x0040A195UL] =  "SQModifierCodeSequence";
        dict[0x0040A300UL] =  "SQMeasuredValueSequence";
        dict[0x0040A30AUL] =  "DSNumericValue";
        dict[0x0040A360UL] =  "SQPredecessorDocumentsSequence";
        dict[0x0040A370UL] =  "SQReferencedRequestSequence";
        dict[0x0040A372UL] =  "SQPerformedProcedureCodeSequence";
        dict[0x0040A375UL] =  "SQCurrentRequestedProcedureEvidenceSequence";
        dict[0x0040A385UL] =  "SQPertinentOtherEvidenceSequence";
        dict[0x0040A491UL] =  "CSCompletionFlag";
        dict[0x0040A492UL] =  "LOCompletionFlagDescription";
        dict[0x0040A493UL] =  "CSVerificationFlag";
        dict[0x0040A504UL] =  "SQContentTemplateSequence";
        dict[0x0040A525UL] =  "SQIdenticalDocumentsSequence";
        dict[0x0040A730UL] =  "SQContentSequence";
        dict[0x0040B020UL] =  "SQAnnotationSequence";
        dict[0x0040DB00UL] =  "CSTemplateIdentifier";
        dict[0x0040DB06UL] =  "DTTemplateVersion";
        dict[0x0040DB07UL] =  "DTTemplateLocalVersion";
        dict[0x0040DB0BUL] =  "CSTemplateExtensionFlag";
        dict[0x0040DB0CUL] =  "UITemplateExtensionOrganizationUID";
        dict[0x0040DB0DUL] =  "UITemplateExtensionCreatorUID";
        dict[0x0040DB73UL] =  "ULReferencedContentItemIdentifier";
        dict[0x00500004UL] =  "CSCalibrationImage";
        dict[0x00500010UL] =  "SQDeviceSequence";
        dict[0x00500014UL] =  "DSDeviceLength";
        dict[0x00500016UL] =  "DSDeviceDiameter";
        dict[0x00500017UL] =  "CSDeviceDiameterUnits";
        dict[0x00500018UL] =  "DSDeviceVolume";
        dict[0x00500019UL] =  "DSIntermarkerDistance";
        dict[0x00500020UL] =  "LODeviceDescription";
        dict[0x00540010UL] =  "USEnergyWindowVector";
        dict[0x00540011UL] =  "USNumberofEnergyWindows";
        dict[0x00540012UL] =  "SQEnergyWindowInformationSequence";
        dict[0x00540013UL] =  "SQEnergyWindowRangeSequence";
        dict[0x00540014UL] =  "DSEnergyWindowLowerLimit";
        dict[0x00540015UL] =  "DSEnergyWindowUpperLimit";
        dict[0x00540016UL] =  "SQRadiopharmaceuticalInformationSequence";
        dict[0x00540017UL] =  "ISResidualSyringeCounts";
        dict[0x00540018UL] =  "SHEnergyWindowName";
        dict[0x00540020UL] =  "USDetectorVector";
        dict[0x00540021UL] =  "USNumberofDetectors";
        dict[0x00540022UL] =  "SQDetectorInformationSequence";
        dict[0x00540030UL] =  "USPhaseVector";
        dict[0x00540031UL] =  "USNumberofPhases";
        dict[0x00540032UL] =  "SQPhaseInformationSequence";
        dict[0x00540033UL] =  "USNumberofFramesinPhase";
        dict[0x00540036UL] =  "ISPhaseDelay";
        dict[0x00540038UL] =  "ISPauseBetweenFrames";
        dict[0x00540050UL] =  "USRotationVector";
        dict[0x00540051UL] =  "USNumberofRotations";
        dict[0x00540052UL] =  "SQRotationInformationSequence";
        dict[0x00540053UL] =  "USNumberofFramesinRotation";
        dict[0x00540060UL] =  "USRRIntervalVector";
        dict[0x00540061UL] =  "USNumberofRRIntervals";
        dict[0x00540062UL] =  "SQGatedInformationSequence";
        dict[0x00540063UL] =  "SQDataInformationSequence";
        dict[0x00540070UL] =  "USTimeSlotVector";
        dict[0x00540071UL] =  "USNumberofTimeSlots";
        dict[0x00540072UL] =  "SQTimeSlotInformationSequence";
        dict[0x00540073UL] =  "DSTimeSlotTime";
        dict[0x00540080UL] =  "USSliceVector";
        dict[0x00540081UL] =  "USNumberofSlices";
        dict[0x00540090UL] =  "USAngularViewVector";
        dict[0x00540100UL] =  "USTimeSliceVector";
        dict[0x00540101UL] =  "USNumberofTimeSlices";
        dict[0x00540200UL] =  "DSStartAngle";
        dict[0x00540202UL] =  "CSTypeofDetectorMotion";
        dict[0x00540210UL] =  "ISTriggerVector";
        dict[0x00540211UL] =  "USNumberofTriggersinPhase";
        dict[0x00540220UL] =  "SQViewCodeSequence";
        dict[0x00540222UL] =  "SQViewModifierCodeSequence";
        dict[0x00540300UL] =  "SQRadionuclideCodeSequence";
        dict[0x00540302UL] =  "SQAdministrationRouteCodeSequence";
        dict[0x00540304UL] =  "SQRadiopharmaceuticalCodeSequence";
        dict[0x00540306UL] =  "SQCalibrationDataSequence";
        dict[0x00540308UL] =  "USEnergyWindowNumber";
        dict[0x00540400UL] =  "SHImageID";
        dict[0x00540410UL] =  "SQPatientOrientationCodeSequence";
        dict[0x00540412UL] =  "SQPatientOrientationModifierCodeSequence";
        dict[0x00540414UL] =  "SQPatientGantryRelationshipCodeSequence";
        dict[0x00541000UL] =  "CSSeriesType";
        dict[0x00541001UL] =  "CSUnits";
        dict[0x00541002UL] =  "CSCountsSource";
        dict[0x00541004UL] =  "CSReprojectionMethod";
        dict[0x00541100UL] =  "CSRandomsCorrectionMethod";
        dict[0x00541101UL] =  "LOAttenuationCorrectionMethod";
        dict[0x00541102UL] =  "CSDecayCorrection";
        dict[0x00541103UL] =  "LOReconstructionMethod";
        dict[0x00541104UL] =  "LODetectorLinesofResponseUsed";
        dict[0x00541105UL] =  "LOScatterCorrectionMethod";
        dict[0x00541200UL] =  "DSAxialAcceptance";
        dict[0x00541201UL] =  "ISAxialMash";
        dict[0x00541202UL] =  "ISTransverseMash";
        dict[0x00541203UL] =  "DSDetectorElementSize";
        dict[0x00541210UL] =  "DSCoincidenceWindowWidth";
        dict[0x00541220UL] =  "CSSecondaryCountsType";
        dict[0x00541300UL] =  "DSFrameReferenceTime";
        dict[0x00541310UL] =  "ISPrimaryPromptsCountsAccumulated";
        dict[0x00541311UL] =  "ISSecondaryCountsAccumulated";
        dict[0x00541320UL] =  "DSSliceSensitivityFactor";
        dict[0x00541321UL] =  "DSDecayFactor";
        dict[0x00541322UL] =  "DSDoseCalibrationFactor";
        dict[0x00541323UL] =  "DSScatterFractionFactor";
        dict[0x00541324UL] =  "DSDeadTimeFactor";
        dict[0x00541330UL] =  "USImageIndex";
        dict[0x00541400UL] =  "CSCountsIncluded";
        dict[0x00541401UL] =  "CSDeadTimeCorrectionFlag";
        dict[0x00603000UL] =  "SQHistogramSequence";
        dict[0x00603002UL] =  "USHistogramNumberofBins";
        dict[0x00603004UL] =  "USSSHistogramFirstBinValue";
        dict[0x00603006UL] =  "USSSHistogramLastBinValue";
        dict[0x00603008UL] =  "USHistogramBinWidth";
        dict[0x00603010UL] =  "LOHistogramExplanation";
        dict[0x00603020UL] =  "ULHistogramData";
        dict[0x00700001UL] =  "SQGraphicAnnotationSequence";
        dict[0x00700002UL] =  "CSGraphicLayer";
        dict[0x00700003UL] =  "CSBoundingBoxAnnotationUnits";
        dict[0x00700004UL] =  "CSAnchorPointAnnotationUnits";
        dict[0x00700005UL] =  "CSGraphicAnnotationUnits";
        dict[0x00700006UL] =  "STUnformattedTextValue";
        dict[0x00700008UL] =  "SQTextObjectSequence";
        dict[0x00700009UL] =  "SQGraphicObjectSequence";
        dict[0x00700010UL] =  "FLBoundingBoxTopLeftHandCorner";
        dict[0x00700011UL] =  "FLBoundingBoxBottomRightHandCorner";
        dict[0x00700012UL] =  "CSBoundingBoxTextHorizontalJustification";
        dict[0x00700014UL] =  "FLAnchorPoint";
        dict[0x00700015UL] =  "CSAnchorPointVisibility";
        dict[0x00700020UL] =  "USGraphicDimensions";
        dict[0x00700021UL] =  "USNumberofGraphicPoints";
        dict[0x00700022UL] =  "FLGraphicData";
        dict[0x00700023UL] =  "CSGraphicType";
        dict[0x00700024UL] =  "CSGraphicFilled";
        dict[0x00700041UL] =  "CSImageHorizontalFlip";
        dict[0x00700042UL] =  "USImageRotation";
        dict[0x00700052UL] =  "SLDisplayedAreaTopLeftHandCorner";
        dict[0x00700053UL] =  "SLDisplayedAreaBottomRightHandCorner";
        dict[0x0070005AUL] =  "SQDisplayedAreaSelectionSequence";
        dict[0x00700060UL] =  "SQGraphicLayerSequence";
        dict[0x00700062UL] =  "ISGraphicLayerOrder";
        dict[0x00700066UL] =  "USGraphicLayerRecommendedDisplayGrayscaleValue";
        dict[0x00700067UL] =  "USGraphicLayerRecommendedDisplayRGBValue";
        dict[0x00700068UL] =  "LOGraphicLayerDescription";
        dict[0x00700080UL] =  "CSPresentationLabel";
        dict[0x00700081UL] =  "LOPresentationDescription";
        dict[0x00700082UL] =  "DAPresentationCreationDate";
        dict[0x00700083UL] =  "TMPresentationCreationTime";
        dict[0x00700084UL] =  "PNPresentationCreatorsName";
        dict[0x00700100UL] =  "CSPresentationSizeMode";
        dict[0x00700101UL] =  "DSPresentationPixelSpacing";
        dict[0x00700102UL] =  "ISPresentationPixelAspectRatio";
        dict[0x00700103UL] =  "FLPresentationPixelMagnificationRatio";
        dict[0x00880130UL] =  "SHStorageMediaFilesetID";
        dict[0x00880140UL] =  "UIStorageMediaFilesetUID";
        dict[0x00880200UL] =  "SQIconImageSequence";
        dict[0x00880904UL] =  "LOTopicTitle";
        dict[0x00880906UL] =  "STTopicSubject";
        dict[0x00880910UL] =  "LOTopicAuthor";
        dict[0x00880912UL] =  "LOTopicKeyWords";
        dict[0x01000410UL] =  "CSSOPInstanceStatus";
        dict[0x01000420UL] =  "DTSOPAuthorizationDateandTime";
        dict[0x01000424UL] =  "LTSOPAuthorizationComment";
        dict[0x01000426UL] =  "LOAuthorizationEquipmentCertificationNumber";
        dict[0x04000005UL] =  "USMACIDnumber";
        dict[0x04000010UL] =  "UIMACCalculationTransferSyntaxUID";
        dict[0x04000015UL] =  "CSMACAlgorithm";
        dict[0x04000020UL] =  "ATDataElementsSigned";
        dict[0x04000100UL] =  "UIDigitalSignatureUID";
        dict[0x04000105UL] =  "DTDigitalSignatureDateTime";
        dict[0x04000110UL] =  "CSCertificateType";
        dict[0x04000115UL] =  "OBCertificateofSigner";
        dict[0x04000120UL] =  "OBSignature";
        dict[0x04000305UL] =  "CSCertifiedTimestampType";
        dict[0x04000310UL] =  "OBCertifiedTimestamp";
        dict[0x20000010UL] =  "ISNumberofCopies";
        dict[0x2000001EUL] =  "SQPrinterConfigurationSequence";
        dict[0x20000020UL] =  "CSPrintPriority";
        dict[0x20000030UL] =  "CSMediumType";
        dict[0x20000040UL] =  "CSFilmDestination";
        dict[0x20000050UL] =  "LOFilmSessionLabel";
        dict[0x20000060UL] =  "ISMemoryAllocation";
        dict[0x20000061UL] =  "ISMaximumMemoryAllocation";
        dict[0x20000062UL] =  "CSColorImagePrintingFlag";
        dict[0x20000063UL] =  "CSCollationFlag";
        dict[0x20000065UL] =  "CSAnnotationFlag";
        dict[0x20000067UL] =  "CSImageOverlayFlag";
        dict[0x20000069UL] =  "CSPresentationLUTFlag";
        dict[0x2000006AUL] =  "CSImageBoxPresentationLUTFlag";
        dict[0x200000A0UL] =  "USMemoryBitDepth";
        dict[0x200000A1UL] =  "USPrintingBitDepth";
        dict[0x200000A2UL] =  "SQMediaInstalledSequence";
        dict[0x200000A4UL] =  "SQOtherMediaAvailableSequence";
        dict[0x200000A8UL] =  "SQSupportedImageDisplayFormatsSequence";
        dict[0x20000500UL] =  "SQReferencedFilmBoxSequence";
        dict[0x20000510UL] =  "SQReferencedStoredPrintSequence";
        dict[0x20100010UL] =  "STImageDisplayFormat";
        dict[0x20100030UL] =  "CSAnnotationDisplayFormatID";
        dict[0x20100040UL] =  "CSFilmOrientation";
        dict[0x20100050UL] =  "CSFilmSizeID";
        dict[0x20100052UL] =  "CSPrinterResolutionID";
        dict[0x20100054UL] =  "CSDefaultPrinterResolutionID";
        dict[0x20100060UL] =  "CSMagnificationType";
        dict[0x20100080UL] =  "CSSmoothingType";
        dict[0x201000A6UL] =  "CSDefaultMagnificationType";
        dict[0x201000A7UL] =  "CSOtherMagnificationTypesAvailable";
        dict[0x201000A8UL] =  "CSDefaultSmoothingType";
        dict[0x201000A9UL] =  "CSOtherSmoothingTypesAvailable";
        dict[0x20100100UL] =  "CSBorderDensity";
        dict[0x20100110UL] =  "CSEmptyImageDensity";
        dict[0x20100120UL] =  "USMinDensity";
        dict[0x20100130UL] =  "USMaxDensity";
        dict[0x20100140UL] =  "CSTrim";
        dict[0x20100150UL] =  "STConfigurationInformation";
        dict[0x20100152UL] =  "LTConfigurationInformationDescription";
        dict[0x20100154UL] =  "ISMaximumCollatedFilms";
        dict[0x2010015EUL] =  "USIllumination";
        dict[0x20100160UL] =  "USReflectedAmbientLight";
        dict[0x20100376UL] =  "DSPrinterPixelSpacing";
        dict[0x20100500UL] =  "SQReferencedFilmSessionSequence";
        dict[0x20100510UL] =  "SQReferencedImageBoxSequence";
        dict[0x20100520UL] =  "SQReferencedBasicAnnotationBoxSequence";
        dict[0x20200010UL] =  "USImagePosition";
        dict[0x20200020UL] =  "CSPolarity";
        dict[0x20200030UL] =  "DSRequestedImageSize";
        dict[0x20200040UL] =  "CSRequestedDecimateCropBehavior";
        dict[0x20200050UL] =  "CSRequestedResolutionID";
        dict[0x202000A0UL] =  "CSRequestedImageSizeFlag";
        dict[0x202000A2UL] =  "CSDecimateCropResult";
        dict[0x20200110UL] =  "SQBasicGrayscaleImageSequence";
        dict[0x20200111UL] =  "SQBasicColorImageSequence";
        dict[0x20300010UL] =  "USAnnotationPosition";
        dict[0x20300020UL] =  "LOTextString";
        dict[0x20400010UL] =  "SQReferencedOverlayPlaneSequence";
        dict[0x20400011UL] =  "USReferencedOverlayPlaneGroups";
        dict[0x20400020UL] =  "SQOverlayPixelDataSequence";
        dict[0x20400060UL] =  "CSOverlayMagnificationType";
        dict[0x20400070UL] =  "CSOverlaySmoothingType";
        dict[0x20400072UL] =  "CSOverlayorImageMagnification";
        dict[0x20400074UL] =  "USMagnifytoNumberofColumns";
        dict[0x20400080UL] =  "CSOverlayForegroundDensity";
        dict[0x20400082UL] =  "CSOverlayBackgroundDensity";
        dict[0x20500010UL] =  "SQPresentationLUTSequence";
        dict[0x20500020UL] =  "CSPresentationLUTShape";
        dict[0x20500500UL] =  "SQReferencedPresentationLUTSequence";
        dict[0x21000010UL] =  "SHPrintJobID";
        dict[0x21000020UL] =  "CSExecutionStatus";
        dict[0x21000030UL] =  "CSExecutionStatusInfo";
        dict[0x21000040UL] =  "DACreationDate";
        dict[0x21000050UL] =  "TMCreationTime";
        dict[0x21000070UL] =  "AEOriginator";
        dict[0x21000140UL] =  "AEDestinationAE";
        dict[0x21000160UL] =  "SHOwnerID";
        dict[0x21000170UL] =  "ISNumberofFilms";
        dict[0x21000500UL] =  "SQReferencedPrintJobSequence";
        dict[0x21100010UL] =  "CSPrinterStatus";
        dict[0x21100020UL] =  "CSPrinterStatusInfo";
        dict[0x21100030UL] =  "LOPrinterName";
        dict[0x21100099UL] =  "SHPrintQueueID";
        dict[0x21200010UL] =  "CSQueueStatus";
        dict[0x21200050UL] =  "SQPrintJobDescriptionSequence";
        dict[0x21200070UL] =  "SQReferencedPrintJobSequence";
        dict[0x21300010UL] =  "SQPrintManagementCapabilitiesSequence";
        dict[0x21300015UL] =  "SQPrinterCharacteristicsSequence";
        dict[0x21300030UL] =  "SQFilmBoxContentSequence";
        dict[0x21300040UL] =  "SQImageBoxContentSequence";
        dict[0x21300050UL] =  "SQAnnotationContentSequence";
        dict[0x21300060UL] =  "SQImageOverlayBoxContentSequence";
        dict[0x21300080UL] =  "SQPresentationLUTContentSequence";
        dict[0x213000A0UL] =  "SQProposedStudySequence";
        dict[0x213000C0UL] =  "SQOriginalImageSequence";
        dict[0x30020002UL] =  "SHRTImageLabel";
        dict[0x30020003UL] =  "LORTImageName";
        dict[0x30020004UL] =  "STRTImageDescription";
        dict[0x3002000AUL] =  "CSReportedValuesOrigin";
        dict[0x3002000CUL] =  "CSRTImagePlane";
        dict[0x3002000DUL] =  "DSXRayImageReceptorTranslation";
        dict[0x3002000EUL] =  "DSXRayImageReceptorAngle";
        dict[0x30020010UL] =  "DSRTImageOrientation";
        dict[0x30020011UL] =  "DSImagePlanePixelSpacing";
        dict[0x30020012UL] =  "DSRTImagePosition";
        dict[0x30020020UL] =  "SHRadiationMachineName";
        dict[0x30020022UL] =  "DSRadiationMachineSAD";
        dict[0x30020024UL] =  "DSRadiationMachineSSD";
        dict[0x30020026UL] =  "DSRTImageSID";
        dict[0x30020028UL] =  "DSSourcetoReferenceObjectDistance";
        dict[0x30020029UL] =  "ISFractionNumber";
        dict[0x30020030UL] =  "SQExposureSequence";
        dict[0x30020032UL] =  "DSMetersetExposure";
        dict[0x30020034UL] =  "DSDiaphragmPosition";
        dict[0x30040001UL] =  "CSDVHType";
        dict[0x30040002UL] =  "CSDoseUnits";
        dict[0x30040004UL] =  "CSDoseType";
        dict[0x30040006UL] =  "LODoseComment";
        dict[0x30040008UL] =  "DSNormalizationPoint";
        dict[0x3004000AUL] =  "CSDoseSummationType";
        dict[0x3004000CUL] =  "DSGridFrameOffsetVector";
        dict[0x3004000EUL] =  "DSDoseGridScaling";
        dict[0x30040010UL] =  "SQRTDoseROISequence";
        dict[0x30040012UL] =  "DSDoseValue";
        dict[0x30040040UL] =  "DSDVHNormalizationPoint";
        dict[0x30040042UL] =  "DSDVHNormalizationDoseValue";
        dict[0x30040050UL] =  "SQDVHSequence";
        dict[0x30040052UL] =  "DSDVHDoseScaling";
        dict[0x30040054UL] =  "CSDVHVolumeUnits";
        dict[0x30040056UL] =  "ISDVHNumberofBins";
        dict[0x30040058UL] =  "DSDVHData";
        dict[0x30040060UL] =  "SQDVHReferencedROISequence";
        dict[0x30040062UL] =  "CSDVHROIContributionType";
        dict[0x30040070UL] =  "DSDVHMinimumDose";
        dict[0x30040072UL] =  "DSDVHMaximumDose";
        dict[0x30040074UL] =  "DSDVHMeanDose";
        dict[0x30060002UL] =  "SHStructureSetLabel";
        dict[0x30060004UL] =  "LOStructureSetName";
        dict[0x30060006UL] =  "STStructureSetDescription";
        dict[0x30060008UL] =  "DAStructureSetDate";
        dict[0x30060009UL] =  "TMStructureSetTime";
        dict[0x30060010UL] =  "SQReferencedFrameofReferenceSequence";
        dict[0x30060012UL] =  "SQRTReferencedStudySequence";
        dict[0x30060014UL] =  "SQRTReferencedSeriesSequence";
        dict[0x30060016UL] =  "SQContourImageSequence";
        dict[0x30060020UL] =  "SQStructureSetROISequence";
        dict[0x30060022UL] =  "ISROINumber";
        dict[0x30060024UL] =  "UIReferencedFrameofReferenceUID";
        dict[0x30060026UL] =  "LOROIName";
        dict[0x30060028UL] =  "STROIDescription";
        dict[0x3006002AUL] =  "ISROIDisplayColor";
        dict[0x3006002CUL] =  "DSROIVolume";
        dict[0x30060030UL] =  "SQRTRelatedROISequence";
        dict[0x30060033UL] =  "CSRTROIRelationship";
        dict[0x30060036UL] =  "CSROIGenerationAlgorithm";
        dict[0x30060038UL] =  "LOROIGenerationDescription";
        dict[0x30060039UL] =  "SQROIContourSequence";
        dict[0x30060040UL] =  "SQContourSequence";
        dict[0x30060042UL] =  "CSContourGeometricType";
        dict[0x30060044UL] =  "DSContourSlabThickness";
        dict[0x30060045UL] =  "DSContourOffsetVector";
        dict[0x30060046UL] =  "ISNumberofContourPoints";
        dict[0x30060048UL] =  "ISContourNumber";
        dict[0x30060049UL] =  "ISAttachedContours";
        dict[0x30060050UL] =  "DSContourData";
        dict[0x30060080UL] =  "SQRTROIObservationsSequence";
        dict[0x30060082UL] =  "ISObservationNumber";
        dict[0x30060084UL] =  "ISReferencedROINumber";
        dict[0x30060085UL] =  "SHROIObservationLabel";
        dict[0x30060086UL] =  "SQRTROIIdentificationCodeSequence";
        dict[0x30060088UL] =  "STROIObservationDescription";
        dict[0x300600A0UL] =  "SQRelatedRTROIObservationsSequence";
        dict[0x300600A4UL] =  "CSRTROIInterpretedType";
        dict[0x300600A6UL] =  "PNROIInterpreter";
        dict[0x300600B0UL] =  "SQROIPhysicalPropertiesSequence";
        dict[0x300600B2UL] =  "CSROIPhysicalProperty";
        dict[0x300600B4UL] =  "DSROIPhysicalPropertyValue";
        dict[0x300600C0UL] =  "SQFrameofReferenceRelationshipSequence";
        dict[0x300600C2UL] =  "UIRelatedFrameofReferenceUID";
        dict[0x300600C4UL] =  "CSFrameofReferenceTransformationType";
        dict[0x300600C6UL] =  "DSFrameofReferenceTransformationMatrix";
        dict[0x300600C8UL] =  "LOFrameofReferenceTransformationComment";
        dict[0x30080010UL] =  "SQMeasuredDoseReferenceSequence";
        dict[0x30080012UL] =  "STMeasuredDoseDescription";
        dict[0x30080014UL] =  "CSMeasuredDoseType";
        dict[0x30080016UL] =  "DSMeasuredDoseValue";
        dict[0x30080020UL] =  "SQTreatmentSessionBeamSequence";
        dict[0x30080022UL] =  "ISCurrentFractionNumber";
        dict[0x30080024UL] =  "DATreatmentControlPointDate";
        dict[0x30080025UL] =  "TMTreatmentControlPointTime";
        dict[0x3008002AUL] =  "CSTreatmentTerminationStatus";
        dict[0x3008002BUL] =  "SHTreatmentTerminationCode";
        dict[0x3008002CUL] =  "CSTreatmentVerificationStatus";
        dict[0x30080030UL] =  "SQReferencedTreatmentRecordSequence";
        dict[0x30080032UL] =  "DSSpecifiedPrimaryMeterset";
        dict[0x30080033UL] =  "DSSpecifiedSecondaryMeterset";
        dict[0x30080036UL] =  "DSDeliveredPrimaryMeterset";
        dict[0x30080037UL] =  "DSDeliveredSecondaryMeterset";
        dict[0x3008003AUL] =  "DSSpecifiedTreatmentTime";
        dict[0x3008003BUL] =  "DSDeliveredTreatmentTime";
        dict[0x30080040UL] =  "SQControlPointDeliverySequence";
        dict[0x30080042UL] =  "DSSpecifiedMeterset";
        dict[0x30080044UL] =  "DSDeliveredMeterset";
        dict[0x30080048UL] =  "DSDoseRateDelivered";
        dict[0x30080050UL] =  "SQTreatmentSummaryCalculatedDoseReferenceSequence";
        dict[0x30080052UL] =  "DSCumulativeDosetoDoseReference";
        dict[0x30080054UL] =  "DAFirstTreatmentDate";
        dict[0x30080056UL] =  "DAMostRecentTreatmentDate";
        dict[0x3008005AUL] =  "ISNumberofFractionsDelivered";
        dict[0x30080060UL] =  "SQOverrideSequence";
        dict[0x30080062UL] =  "ATOverrideParameterPointer";
        dict[0x30080064UL] =  "ISMeasuredDoseReferenceNumber";
        dict[0x30080066UL] =  "STOverrideReason";
        dict[0x30080070UL] =  "SQCalculatedDoseReferenceSequence";
        dict[0x30080072UL] =  "ISCalculatedDoseReferenceNumber";
        dict[0x30080074UL] =  "STCalculatedDoseReferenceDescription";
        dict[0x30080076UL] =  "DSCalculatedDoseReferenceDoseValue";
        dict[0x30080078UL] =  "DSStartMeterset";
        dict[0x3008007AUL] =  "DSEndMeterset";
        dict[0x30080080UL] =  "SQReferencedMeasuredDoseReferenceSequence";
        dict[0x30080082UL] =  "ISReferencedMeasuredDoseReferenceNumber";
        dict[0x30080090UL] =  "SQReferencedCalculatedDoseReferenceSequence";
        dict[0x30080092UL] =  "ISReferencedCalculatedDoseReferenceNumber";
        dict[0x300800A0UL] =  "SQBeamLimitingDeviceLeafPairsSequence";
        dict[0x300800B0UL] =  "SQRecordedWedgeSequence";
        dict[0x300800C0UL] =  "SQRecordedCompensatorSequence";
        dict[0x300800D0UL] =  "SQRecordedBlockSequence";
        dict[0x300800E0UL] =  "SQTreatmentSummaryMeasuredDoseReferenceSequence";
        dict[0x30080100UL] =  "SQRecordedSourceSequence";
        dict[0x30080105UL] =  "LOSourceSerialNumber";
        dict[0x30080110UL] =  "SQTreatmentSessionApplicationSetupSequence";
        dict[0x30080116UL] =  "CSApplicationSetupCheck";
        dict[0x30080120UL] =  "SQRecordedBrachyAccessoryDeviceSequence";
        dict[0x30080122UL] =  "ISReferencedBrachyAccessoryDeviceNumber";
        dict[0x30080130UL] =  "SQRecordedChannelSequence";
        dict[0x30080132UL] =  "DSSpecifiedChannelTotalTime";
        dict[0x30080134UL] =  "DSDeliveredChannelTotalTime";
        dict[0x30080136UL] =  "ISSpecifiedNumberofPulses";
        dict[0x30080138UL] =  "ISDeliveredNumberofPulses";
        dict[0x3008013AUL] =  "DSSpecifiedPulseRepetitionInterval";
        dict[0x3008013CUL] =  "DSDeliveredPulseRepetitionInterval";
        dict[0x30080140UL] =  "SQRecordedSourceApplicatorSequence";
        dict[0x30080142UL] =  "ISReferencedSourceApplicatorNumber";
        dict[0x30080150UL] =  "SQRecordedChannelShieldSequence";
        dict[0x30080152UL] =  "ISReferencedChannelShieldNumber";
        dict[0x30080160UL] =  "SQBrachyControlPointDeliveredSequence";
        dict[0x30080162UL] =  "DASafePositionExitDate";
        dict[0x30080164UL] =  "TMSafePositionExitTime";
        dict[0x30080166UL] =  "DASafePositionReturnDate";
        dict[0x30080168UL] =  "TMSafePositionReturnTime";
        dict[0x30080200UL] =  "CSCurrentTreatmentStatus";
        dict[0x30080202UL] =  "STTreatmentStatusComment";
        dict[0x30080220UL] =  "SQFractionGroupSummarySequence";
        dict[0x30080223UL] =  "ISReferencedFractionNumber";
        dict[0x30080224UL] =  "CSFractionGroupType";
        dict[0x30080230UL] =  "CSBeamStopperPosition";
        dict[0x30080240UL] =  "SQFractionStatusSummarySequence";
        dict[0x30080250UL] =  "DATreatmentDate";
        dict[0x30080251UL] =  "TMTreatmentTime";
        dict[0x300A0002UL] =  "SHRTPlanLabel";
        dict[0x300A0003UL] =  "LORTPlanName";
        dict[0x300A0004UL] =  "STRTPlanDescription";
        dict[0x300A0006UL] =  "DARTPlanDate";
        dict[0x300A0007UL] =  "TMRTPlanTime";
        dict[0x300A0009UL] =  "LOTreatmentProtocols";
        dict[0x300A000AUL] =  "CSTreatmentIntent";
        dict[0x300A000BUL] =  "LOTreatmentSites";
        dict[0x300A000CUL] =  "CSRTPlanGeometry";
        dict[0x300A000EUL] =  "STPrescriptionDescription";
        dict[0x300A0010UL] =  "SQDoseReferenceSequence";
        dict[0x300A0012UL] =  "ISDoseReferenceNumber";
        dict[0x300A0014UL] =  "CSDoseReferenceStructureType";
        dict[0x300A0015UL] =  "CSNominalBeamEnergyUnit";
        dict[0x300A0016UL] =  "LODoseReferenceDescription";
        dict[0x300A0018UL] =  "DSDoseReferencePointCoordinates";
        dict[0x300A001AUL] =  "DSNominalPriorDose";
        dict[0x300A0020UL] =  "CSDoseReferenceType";
        dict[0x300A0021UL] =  "DSConstraintWeight";
        dict[0x300A0022UL] =  "DSDeliveryWarningDose";
        dict[0x300A0023UL] =  "DSDeliveryMaximumDose";
        dict[0x300A0025UL] =  "DSTargetMinimumDose";
        dict[0x300A0026UL] =  "DSTargetPrescriptionDose";
        dict[0x300A0027UL] =  "DSTargetMaximumDose";
        dict[0x300A0028UL] =  "DSTargetUnderdoseVolumeFraction";
        dict[0x300A002AUL] =  "DSOrganatRiskFullvolumeDose";
        dict[0x300A002BUL] =  "DSOrganatRiskLimitDose";
        dict[0x300A002CUL] =  "DSOrganatRiskMaximumDose";
        dict[0x300A002DUL] =  "DSOrganatRiskOverdoseVolumeFraction";
        dict[0x300A0040UL] =  "SQToleranceTableSequence";
        dict[0x300A0042UL] =  "ISToleranceTableNumber";
        dict[0x300A0043UL] =  "SHToleranceTableLabel";
        dict[0x300A0044UL] =  "DSGantryAngleTolerance";
        dict[0x300A0046UL] =  "DSBeamLimitingDeviceAngleTolerance";
        dict[0x300A0048UL] =  "SQBeamLimitingDeviceToleranceSequence";
        dict[0x300A004AUL] =  "DSBeamLimitingDevicePositionTolerance";
        dict[0x300A004CUL] =  "DSPatientSupportAngleTolerance";
        dict[0x300A004EUL] =  "DSTableTopEccentricAngleTolerance";
        dict[0x300A0051UL] =  "DSTableTopVerticalPositionTolerance";
        dict[0x300A0052UL] =  "DSTableTopLongitudinalPositionTolerance";
        dict[0x300A0053UL] =  "DSTableTopLateralPositionTolerance";
        dict[0x300A0055UL] =  "CSRTPlanRelationship";
        dict[0x300A0070UL] =  "SQFractionGroupSequence";
        dict[0x300A0071UL] =  "ISFractionGroupNumber";
        dict[0x300A0078UL] =  "ISNumberofFractionsPlanned";
        dict[0x300A0079UL] =  "ISNumberofFractionPatternDigitsPerDay";
        dict[0x300A007AUL] =  "ISRepeatFractionCycleLength";
        dict[0x300A007BUL] =  "LTFractionPattern";
        dict[0x300A0080UL] =  "ISNumberofBeams";
        dict[0x300A0082UL] =  "DSBeamDoseSpecificationPoint";
        dict[0x300A0084UL] =  "DSBeamDose";
        dict[0x300A0086UL] =  "DSBeamMeterset";
        dict[0x300A00A0UL] =  "ISNumberofBrachyApplicationSetups";
        dict[0x300A00A2UL] =  "DSBrachyApplicationSetupDoseSpecificationPoint";
        dict[0x300A00A4UL] =  "DSBrachyApplicationSetupDose";
        dict[0x300A00B0UL] =  "SQBeamSequence";
        dict[0x300A00B2UL] =  "SHTreatmentMachineName";
        dict[0x300A00B3UL] =  "CSPrimaryDosimeterUnit";
        dict[0x300A00B4UL] =  "DSSourceAxisDistance";
        dict[0x300A00B6UL] =  "SQBeamLimitingDeviceSequence";
        dict[0x300A00B8UL] =  "CSRTBeamLimitingDeviceType";
        dict[0x300A00BAUL] =  "DSSourcetoBeamLimitingDeviceDistance";
        dict[0x300A00BCUL] =  "ISNumberofLeafJawPairs";
        dict[0x300A00BEUL] =  "DSLeafPositionBoundaries";
        dict[0x300A00C0UL] =  "ISBeamNumber";
        dict[0x300A00C2UL] =  "LOBeamName";
        dict[0x300A00C3UL] =  "STBeamDescription";
        dict[0x300A00C4UL] =  "CSBeamType";
        dict[0x300A00C6UL] =  "CSRadiationType";
        dict[0x300A00C7UL] =  "CSHighDoseTechniqueType";
        dict[0x300A00C8UL] =  "ISReferenceImageNumber";
        dict[0x300A00CAUL] =  "SQPlannedVerificationImageSequence";
        dict[0x300A00CCUL] =  "LOImagingDeviceSpecificAcquisitionParameters";
        dict[0x300A00CEUL] =  "CSTreatmentDeliveryType";
        dict[0x300A00D0UL] =  "ISNumberofWedges";
        dict[0x300A00D1UL] =  "SQWedgeSequence";
        dict[0x300A00D2UL] =  "ISWedgeNumber";
        dict[0x300A00D3UL] =  "CSWedgeType";
        dict[0x300A00D4UL] =  "SHWedgeID";
        dict[0x300A00D5UL] =  "ISWedgeAngle";
        dict[0x300A00D6UL] =  "DSWedgeFactor";
        dict[0x300A00D8UL] =  "DSWedgeOrientation";
        dict[0x300A00DAUL] =  "DSSourcetoWedgeTrayDistance";
        dict[0x300A00E0UL] =  "ISNumberofCompensators";
        dict[0x300A00E1UL] =  "SHMaterialID";
        dict[0x300A00E2UL] =  "DSTotalCompensatorTrayFactor";
        dict[0x300A00E3UL] =  "SQCompensatorSequence";
        dict[0x300A00E4UL] =  "ISCompensatorNumber";
        dict[0x300A00E5UL] =  "SHCompensatorID";
        dict[0x300A00E6UL] =  "DSSourcetoCompensatorTrayDistance";
        dict[0x300A00E7UL] =  "ISCompensatorRows";
        dict[0x300A00E8UL] =  "ISCompensatorColumns";
        dict[0x300A00E9UL] =  "DSCompensatorPixelSpacing";
        dict[0x300A00EAUL] =  "DSCompensatorPosition";
        dict[0x300A00EBUL] =  "DSCompensatorTransmissionData";
        dict[0x300A00ECUL] =  "DSCompensatorThicknessData";
        dict[0x300A00EDUL] =  "ISNumberofBoli";
        dict[0x300A00EEUL] =  "CSCompensatorType";
        dict[0x300A00F0UL] =  "ISNumberofBlocks";
        dict[0x300A00F2UL] =  "DSTotalBlockTrayFactor";
        dict[0x300A00F4UL] =  "SQBlockSequence";
        dict[0x300A00F5UL] =  "SHBlockTrayID";
        dict[0x300A00F6UL] =  "DSSourcetoBlockTrayDistance";
        dict[0x300A00F8UL] =  "CSBlockType";
        dict[0x300A00FAUL] =  "CSBlockDivergence";
        dict[0x300A00FCUL] =  "ISBlockNumber";
        dict[0x300A00FEUL] =  "LOBlockName";
        dict[0x300A0100UL] =  "DSBlockThickness";
        dict[0x300A0102UL] =  "DSBlockTransmission";
        dict[0x300A0104UL] =  "ISBlockNumberofPoints";
        dict[0x300A0106UL] =  "DSBlockData";
        dict[0x300A0107UL] =  "SQApplicatorSequence";
        dict[0x300A0108UL] =  "SHApplicatorID";
        dict[0x300A0109UL] =  "CSApplicatorType";
        dict[0x300A010AUL] =  "LOApplicatorDescription";
        dict[0x300A010CUL] =  "DSCumulativeDoseReferenceCoefficient";
        dict[0x300A010EUL] =  "DSFinalCumulativeMetersetWeight";
        dict[0x300A0110UL] =  "ISNumberofControlPoints";
        dict[0x300A0111UL] =  "SQControlPointSequence";
        dict[0x300A0112UL] =  "ISControlPointIndex";
        dict[0x300A0114UL] =  "DSNominalBeamEnergy";
        dict[0x300A0115UL] =  "DSDoseRateSet";
        dict[0x300A0116UL] =  "SQWedgePositionSequence";
        dict[0x300A0118UL] =  "CSWedgePosition";
        dict[0x300A011AUL] =  "SQBeamLimitingDevicePositionSequence";
        dict[0x300A011CUL] =  "DSLeafJawPositions";
        dict[0x300A011EUL] =  "DSGantryAngle";
        dict[0x300A011FUL] =  "CSGantryRotationDirection";
        dict[0x300A0120UL] =  "DSBeamLimitingDeviceAngle";
        dict[0x300A0121UL] =  "CSBeamLimitingDeviceRotationDirection";
        dict[0x300A0122UL] =  "DSPatientSupportAngle";
        dict[0x300A0123UL] =  "CSPatientSupportRotationDirection";
        dict[0x300A0124UL] =  "DSTableTopEccentricAxisDistance";
        dict[0x300A0125UL] =  "DSTableTopEccentricAngle";
        dict[0x300A0126UL] =  "CSTableTopEccentricRotationDirection";
        dict[0x300A0128UL] =  "DSTableTopVerticalPosition";
        dict[0x300A0129UL] =  "DSTableTopLongitudinalPosition";
        dict[0x300A012AUL] =  "DSTableTopLateralPosition";
        dict[0x300A012CUL] =  "DSIsocenterPosition";
        dict[0x300A012EUL] =  "DSSurfaceEntryPoint";
        dict[0x300A0130UL] =  "DSSourcetoSurfaceDistance";
        dict[0x300A0134UL] =  "DSCumulativeMetersetWeight";
        dict[0x300A0180UL] =  "SQPatientSetupSequence";
        dict[0x300A0182UL] =  "ISPatientSetupNumber";
        dict[0x300A0184UL] =  "LOPatientAdditionalPosition";
        dict[0x300A0190UL] =  "SQFixationDeviceSequence";
        dict[0x300A0192UL] =  "CSFixationDeviceType";
        dict[0x300A0194UL] =  "SHFixationDeviceLabel";
        dict[0x300A0196UL] =  "STFixationDeviceDescription";
        dict[0x300A0198UL] =  "SHFixationDevicePosition";
        dict[0x300A01A0UL] =  "SQShieldingDeviceSequence";
        dict[0x300A01A2UL] =  "CSShieldingDeviceType";
        dict[0x300A01A4UL] =  "SHShieldingDeviceLabel";
        dict[0x300A01A6UL] =  "STShieldingDeviceDescription";
        dict[0x300A01A8UL] =  "SHShieldingDevicePosition";
        dict[0x300A01B0UL] =  "CSSetupTechnique";
        dict[0x300A01B2UL] =  "STSetupTechniqueDescription";
        dict[0x300A01B4UL] =  "SQSetupDeviceSequence";
        dict[0x300A01B6UL] =  "CSSetupDeviceType";
        dict[0x300A01B8UL] =  "SHSetupDeviceLabel";
        dict[0x300A01BAUL] =  "STSetupDeviceDescription";
        dict[0x300A01BCUL] =  "DSSetupDeviceParameter";
        dict[0x300A01D0UL] =  "STSetupReferenceDescription";
        dict[0x300A01D2UL] =  "DSTableTopVerticalSetupDisplacement";
        dict[0x300A01D4UL] =  "DSTableTopLongitudinalSetupDisplacement";
        dict[0x300A01D6UL] =  "DSTableTopLateralSetupDisplacement";
        dict[0x300A0200UL] =  "CSBrachyTreatmentTechnique";
        dict[0x300A0202UL] =  "CSBrachyTreatmentType";
        dict[0x300A0206UL] =  "SQTreatmentMachineSequence";
        dict[0x300A0210UL] =  "SQSourceSequence";
        dict[0x300A0212UL] =  "ISSourceNumber";
        dict[0x300A0214UL] =  "CSSourceType";
        dict[0x300A0216UL] =  "LOSourceManufacturer";
        dict[0x300A0218UL] =  "DSActiveSourceDiameter";
        dict[0x300A021AUL] =  "DSActiveSourceLength";
        dict[0x300A0222UL] =  "DSSourceEncapsulationNominalThickness";
        dict[0x300A0224UL] =  "DSSourceEncapsulationNominalTransmission";
        dict[0x300A0226UL] =  "LOSourceIsotopeName";
        dict[0x300A0228UL] =  "DSSourceIsotopeHalfLife";
        dict[0x300A022AUL] =  "DSReferenceAirKermaRate";
        dict[0x300A022CUL] =  "DAAirKermaRateReferenceDate";
        dict[0x300A022EUL] =  "TMAirKermaRateReferenceTime";
        dict[0x300A0230UL] =  "SQApplicationSetupSequence";
        dict[0x300A0232UL] =  "CSApplicationSetupType";
        dict[0x300A0234UL] =  "ISApplicationSetupNumber";
        dict[0x300A0236UL] =  "LOApplicationSetupName";
        dict[0x300A0238UL] =  "LOApplicationSetupManufacturer";
        dict[0x300A0240UL] =  "ISTemplateNumber";
        dict[0x300A0242UL] =  "SHTemplateType";
        dict[0x300A0244UL] =  "LOTemplateName";
        dict[0x300A0250UL] =  "DSTotalReferenceAirKerma";
        dict[0x300A0260UL] =  "SQBrachyAccessoryDeviceSequence";
        dict[0x300A0262UL] =  "ISBrachyAccessoryDeviceNumber";
        dict[0x300A0263UL] =  "SHBrachyAccessoryDeviceID";
        dict[0x300A0264UL] =  "CSBrachyAccessoryDeviceType";
        dict[0x300A0266UL] =  "LOBrachyAccessoryDeviceName";
        dict[0x300A026AUL] =  "DSBrachyAccessoryDeviceNominalThickness";
        dict[0x300A026CUL] =  "DSBrachyAccessoryDeviceNominalTransmission";
        dict[0x300A0280UL] =  "SQChannelSequence";
        dict[0x300A0282UL] =  "ISChannelNumber";
        dict[0x300A0284UL] =  "DSChannelLength";
        dict[0x300A0286UL] =  "DSChannelTotalTime";
        dict[0x300A0288UL] =  "CSSourceMovementType";
        dict[0x300A028AUL] =  "ISNumberofPulses";
        dict[0x300A028CUL] =  "DSPulseRepetitionInterval";
        dict[0x300A0290UL] =  "ISSourceApplicatorNumber";
        dict[0x300A0291UL] =  "SHSourceApplicatorID";
        dict[0x300A0292UL] =  "CSSourceApplicatorType";
        dict[0x300A0294UL] =  "LOSourceApplicatorName";
        dict[0x300A0296UL] =  "DSSourceApplicatorLength";
        dict[0x300A0298UL] =  "LOSourceApplicatorManufacturer";
        dict[0x300A029CUL] =  "DSSourceApplicatorWallNominalThickness";
        dict[0x300A029EUL] =  "DSSourceApplicatorWallNominalTransmission";
        dict[0x300A02A0UL] =  "DSSourceApplicatorStepSize";
        dict[0x300A02A2UL] =  "ISTransferTubeNumber";
        dict[0x300A02A4UL] =  "DSTransferTubeLength";
        dict[0x300A02B0UL] =  "SQChannelShieldSequence";
        dict[0x300A02B2UL] =  "ISChannelShieldNumber";
        dict[0x300A02B3UL] =  "SHChannelShieldID";
        dict[0x300A02B4UL] =  "LOChannelShieldName";
        dict[0x300A02B8UL] =  "DSChannelShieldNominalThickness";
        dict[0x300A02BAUL] =  "DSChannelShieldNominalTransmission";
        dict[0x300A02C8UL] =  "DSFinalCumulativeTimeWeight";
        dict[0x300A02D0UL] =  "SQBrachyControlPointSequence";
        dict[0x300A02D2UL] =  "DSControlPointRelativePosition";
        dict[0x300A02D4UL] =  "DSControlPoint3DPosition";
        dict[0x300A02D6UL] =  "DSCumulativeTimeWeight";
        dict[0x300C0002UL] =  "SQReferencedRTPlanSequence";
        dict[0x300C0004UL] =  "SQReferencedBeamSequence";
        dict[0x300C0006UL] =  "ISReferencedBeamNumber";
        dict[0x300C0007UL] =  "ISReferencedReferenceImageNumber";
        dict[0x300C0008UL] =  "DSStartCumulativeMetersetWeight";
        dict[0x300C0009UL] =  "DSEndCumulativeMetersetWeight";
        dict[0x300C000AUL] =  "SQReferencedBrachyApplicationSetupSequence";
        dict[0x300C000CUL] =  "ISReferencedBrachyApplicationSetupNumber";
        dict[0x300C000EUL] =  "ISReferencedSourceNumber";
        dict[0x300C0020UL] =  "SQReferencedFractionGroupSequence";
        dict[0x300C0022UL] =  "ISReferencedFractionGroupNumber";
        dict[0x300C0040UL] =  "SQReferencedVerificationImageSequence";
        dict[0x300C0042UL] =  "SQReferencedReferenceImageSequence";
        dict[0x300C0050UL] =  "SQReferencedDoseReferenceSequence";
        dict[0x300C0051UL] =  "ISReferencedDoseReferenceNumber";
        dict[0x300C0055UL] =  "SQBrachyReferencedDoseReferenceSequence";
        dict[0x300C0060UL] =  "SQReferencedStructureSetSequence";
        dict[0x300C006AUL] =  "ISReferencedPatientSetupNumber";
        dict[0x300C0080UL] =  "SQReferencedDoseSequence";
        dict[0x300C00A0UL] =  "ISReferencedToleranceTableNumber";
        dict[0x300C00B0UL] =  "SQReferencedBolusSequence";
        dict[0x300C00C0UL] =  "ISReferencedWedgeNumber";
        dict[0x300C00D0UL] =  "ISReferencedCompensatorNumber";
        dict[0x300C00E0UL] =  "ISReferencedBlockNumber";
        dict[0x300C00F0UL] =  "ISReferencedControlPointIndex";
        dict[0x300E0002UL] =  "CSApprovalStatus";
        dict[0x300E0004UL] =  "DAReviewDate";
        dict[0x300E0005UL] =  "TMReviewTime";
        dict[0x300E0008UL] =  "PNReviewerName";
        dict[0x40080040UL] =  "SHResultsID";
        dict[0x40080042UL] =  "LOResultsIDIssuer";
        dict[0x40080050UL] =  "SQReferencedInterpretationSequence";
        dict[0x40080100UL] =  "DAInterpretationRecordedDate";
        dict[0x40080101UL] =  "TMInterpretationRecordedTime";
        dict[0x40080102UL] =  "PNInterpretationRecorder";
        dict[0x40080103UL] =  "LOReferencetoRecordedSound";
        dict[0x40080108UL] =  "DAInterpretationTranscriptionDate";
        dict[0x40080109UL] =  "TMInterpretationTranscriptionTime";
        dict[0x4008010AUL] =  "PNInterpretationTranscriber";
        dict[0x4008010BUL] =  "STInterpretationText";
        dict[0x4008010CUL] =  "PNInterpretationAuthor";
        dict[0x40080111UL] =  "SQInterpretationApproverSequence";
        dict[0x40080112UL] =  "DAInterpretationApprovalDate";
        dict[0x40080113UL] =  "TMInterpretationApprovalTime";
        dict[0x40080114UL] =  "PNPhysicianApprovingInterpretation";
        dict[0x40080115UL] =  "LTInterpretationDiagnosisDescription";
        dict[0x40080117UL] =  "SQInterpretationDiagnosisCodeSequence";
        dict[0x40080118UL] =  "SQResultsDistributionListSequence";
        dict[0x40080119UL] =  "PNDistributionName";
        dict[0x4008011AUL] =  "LODistributionAddress";
        dict[0x40080200UL] =  "SHInterpretationID";
        dict[0x40080202UL] =  "LOInterpretationIDIssuer";
        dict[0x40080210UL] =  "CSInterpretationTypeID";
        dict[0x40080212UL] =  "CSInterpretationStatusID";
        dict[0x40080300UL] =  "STImpressions";
        dict[0x40084000UL] =  "STResultsComments";
        dict[0x4FFE0001UL] =  "SQMACParametersSequence";
        /*  dict[0x50xx0005UL] =  "USCurveDimensions";
            dict[0x50xx0010UL] =  "USNumberofPoints";
            dict[0x50xx0020UL] =  "CSTypeofData";
            dict[0x50xx0022UL] =  "LOCurveDescription";
            dict[0x50xx0030UL] =  "SHAxisUnits";
            dict[0x50xx0040UL] =  "SHAxisLabels";
            dict[0x50xx0103UL] =  "USDataValueRepresentation";
            dict[0x50xx0104UL] =  "USMinimumCoordinateValue";
            dict[0x50xx0105UL] =  "USMaximumCoordinateValue";
            dict[0x50xx0106UL] =  "SHCurveRange";
            dict[0x50xx0110UL] =  "USCurveDataDescriptor";
            dict[0x50xx0112UL] =  "USCoordinateStartValue";
            dict[0x50xx0114UL] =  "USCoordinateStepValue";
            dict[0x50xx1001UL] =  "CSCurveActivationLayer";
            dict[0x50xx2000UL] =  "USAudioType";
            dict[0x50xx2002UL] =  "USAudioSampleFormat";
            dict[0x50xx2004UL] =  "USNumberofChannels";
            dict[0x50xx2006UL] =  "ULNumberofSamples";
            dict[0x50xx2008UL] =  "ULSampleRate";
            dict[0x50xx200AUL] =  "ULTotalTime";
            dict[0x50xx200CUL] =  "OWOBAudioSampleData";
            dict[0x50xx200EUL] =  "LTAudioComments";
            dict[0x50xx2500UL] =  "LOCurveLabel";
            dict[0x50xx2600UL] =  "SQReferencedOverlaySequence";
            dict[0x50xx2610UL] =  "USReferencedOverlayGroup";
            dict[0x50xx3000UL] =  "OWOBCurveData"; */
        dict[0x54000100UL] =  "SQWaveformSequence";
        dict[0x54000110UL] =  "OBOWChannelMinimumValue";
        dict[0x54000112UL] =  "OBOWChannelMaximumValue";
        dict[0x54001004UL] =  "USWaveformBitsAllocated";
        dict[0x54001006UL] =  "CSWaveformSampleInterpretation";
        dict[0x5400100AUL] =  "OBOWWaveformPaddingValue";
        dict[0x54001010UL] =  "OBOWWaveformData";
        /*  dict[0x60xx0010UL] =  "USOverlayRows";
            dict[0x60xx0011UL] =  "USOverlayColumns";
            dict[0x60xx0012UL] =  "USOverlayPlanes";
            dict[0x60xx0015UL] =  "ISNumberofFramesinOverlay";
            dict[0x60xx0022UL] =  "LOOverlayDescription";
            dict[0x60xx0040UL] =  "CSOverlayType";
            dict[0x60xx0045UL] =  "LOOverlaySubtype";
            dict[0x60xx0050UL] =  "SSOverlayOrigin";
            dict[0x60xx0051UL] =  "USImageFrameOrigin";
            dict[0x60xx0052UL] =  "USOverlayPlaneOrigin";
            dict[0x60xx0100UL] =  "USOverlayBitsAllocated";
            dict[0x60xx0102UL] =  "USOverlayBitPosition";
            dict[0x60xx1001UL] =  "CSOverlayActivationLayer";
            dict[0x60xx1301UL] =  "ISROIArea";
            dict[0x60xx1302UL] =  "DSROIMean";
            dict[0x60xx1303UL] =  "DSROIStandardDeviation";
            dict[0x60xx1500UL] =  "LOOverlayLabel";
            dict[0x60xx3000UL] =  "OBOWOverlayData"; */
        dict[0x7FE00010UL] =  "OWOBPixelData";
        dict[0xFFFAFFFAUL] =  "SQDigitalSignaturesSequence";
        dict[0xFFFCFFFCUL] =  "OBDataSetTrailingPadding";
        dict[0xFFFEE000UL] =  "UNItem";
        dict[0xFFFEE00DUL] =  "UNItemDelimitationItem";
        dict[0xFFFEE0DDUL] =  "UNSequenceDelimitationItem";
        dict[0x00290010UL] =  "LOPrivateCreatorCode";
        dict[0x00290011UL] =  "LOAnotherPrivateCreatorCode";
        dict[0x00291008UL] =  "CSCSAImageHeaderType";
        dict[0x00291009UL] =  "LOCSAImageHeaderVersion";
        dict[0x00291010UL] =  "OBCSAImageHeaderInfo";
        dict[0x00291018UL] =  "CSCSASeriesHeaderType";
        dict[0x00291019UL] =  "LOCSASeriesHeaderVersion";
        dict[0x00291020UL] =  "OBCSASeriesHeaderInfo";
        dict[0x00291131UL] =  "LOPMTFInformation1";
        dict[0x00291132UL] =  "ULPMTFInformation2";
        dict[0x00291133UL] =  "ULPMTFInformation3";
        dict[0x00291134UL] =  "CSPMTFInformation4";
        dict[0x7fe11010UL] =  "OBCSAData";
      }

    }
  }
}

