/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001  CodeFactory AB
 * Copyright (C) 2001  Richard Hult <rhult@codefactory.se>
 * Copyright (C) 2001  Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult <rhult@codefactory.se>
 */

#include <bonobo.h>
#include <gtk/gtk.h>
#include "libmrproject/GNOME_MrProject.h"
#include "util/corba-utils.h"
#include "file-filter.h"

static void file_filter_init	   (FileFilter	      *file_filter);
static void file_filter_class_init (FileFilterClass   *klass);
static void file_filter_destroy    (GtkObject         *object);

#define PARENT_TYPE BONOBO_X_OBJECT_TYPE
static GtkObjectClass *parent_class;

BONOBO_X_TYPE_FUNC_FULL (FileFilter,   GNOME_MrProject_FileFilter,
			 PARENT_TYPE,  file_filter);

static CORBA_boolean
impl_FileFilter_probe (PortableServer_Servant  servant,
		       const CORBA_char       *uri,
		       CORBA_Environment      *ev)
{
	FileFilter      *filter;
	FileFilterClass *klass;

	filter = FILE_FILTER (bonobo_x_object (servant));
	klass = FILE_FILTER_CLASS (GTK_OBJECT (filter)->klass);
	
	if (klass->probe) {
		return klass->probe (filter, uri, ev);
	}

	return FALSE;
}

static gboolean
reference_managers (FileFilter *filter)
{
        CORBA_Environment   ev;
        
        g_return_val_if_fail (filter != NULL, FALSE);
        g_return_val_if_fail (IS_FILE_FILTER (filter), FALSE);
        
        CORBA_exception_init (&ev);

        filter->task_mgr = Bonobo_Unknown_queryInterface (
                filter->project,
                "IDL:GNOME/MrProject/TaskManager:1.0",
                &ev);

        if (BONOBO_EX (&ev)) {
                g_warning ("Could not get TaskManager interface");
                CORBA_exception_free (&ev);
                return FALSE;
        }
        
        filter->resource_mgr = Bonobo_Unknown_queryInterface (
                filter->project,
                "IDL:GNOME/MrProject/ResourceManager:1.0",
                &ev);

        if (BONOBO_EX (&ev)) {
                g_warning ("Could not get ResourceManager interface");
                CORBA_exception_free (&ev);
                return FALSE;
        }
        
        filter->allocation_mgr = Bonobo_Unknown_queryInterface (
                filter->project,
                "IDL:GNOME/MrProject/AllocationManager:1.0",
                &ev);
                                                        
        if (BONOBO_EX (&ev)) {
                g_warning ("Could not get AllocationManager interface");
                CORBA_exception_free (&ev);
                return FALSE;
        }

        return TRUE;
}

static void
impl_FileFilter_load (PortableServer_Servant  servant,
		      const CORBA_char       *uri,
		      const GM_Project        project,
		      CORBA_Environment      *ev)
{
	FileFilter       *filter;
	FileFilterClass  *klass;

	filter = FILE_FILTER (bonobo_x_object (servant));
	klass = FILE_FILTER_CLASS (GTK_OBJECT (filter)->klass);

        filter->project = project;

        if (!reference_managers (filter)) {
		CORBA_exception_set (ev, CORBA_USER_EXCEPTION,
				     ex_GNOME_MrProject_FileFilter_Failure,
				     NULL);
                return;
        }
        
	if (klass->load) {
		klass->load (filter, uri, project, ev);
	}
}

static void
impl_FileFilter_loadSummary (PortableServer_Servant  servant,
			     const CORBA_char       *uri,
			     GNOME_MrProject_FileSummary **summary,
			     CORBA_Environment      *ev)
{
	FileFilter       *filter;
	FileFilterClass  *klass;

	filter = FILE_FILTER (bonobo_x_object (servant));
	klass = FILE_FILTER_CLASS (GTK_OBJECT (filter)->klass);
	
	if (klass->load_summary) {
		klass->load_summary (filter, uri, summary, ev);
	}
}

static void
impl_FileFilter_save (PortableServer_Servant  servant,
		      const CORBA_char       *uri,
		      const GM_Project        project,
		      CORBA_Environment      *ev)
{
	FileFilter      *filter;
	FileFilterClass *klass;

	filter = FILE_FILTER (bonobo_x_object (servant));
	klass = FILE_FILTER_CLASS (GTK_OBJECT (filter)->klass);

        filter->project = project;

	if (!reference_managers (filter)) {
		CORBA_exception_set (ev, CORBA_USER_EXCEPTION,
				     ex_GNOME_MrProject_FileFilter_Failure,
				     NULL);
		return;
	}
	
	if (klass->save) {
		klass->save (filter, uri, project, ev);
	}
}

static void
file_filter_class_init (FileFilterClass *klass)
{
	GtkObjectClass                      *object_class;
	POA_GNOME_MrProject_FileFilter__epv *epv;
	
	object_class = (GtkObjectClass *) klass;
	epv          = &klass->epv;
	parent_class = gtk_type_class (PARENT_TYPE);

	object_class->destroy = file_filter_destroy;

	epv->probe            = impl_FileFilter_probe;
	epv->load             = impl_FileFilter_load;
	epv->loadSummary      = impl_FileFilter_loadSummary;
	epv->save             = impl_FileFilter_save;
}

static void
file_filter_init (FileFilter *file_filter)
{
}

static void
file_filter_destroy (GtkObject *object) 
{
	FileFilter *filter;
	
	g_return_if_fail (object != NULL);
	g_return_if_fail (IS_FILE_FILTER (object));
	
	filter = FILE_FILTER (object);

	if (filter->task_mgr) {
		bonobo_object_release_unref (filter->task_mgr, NULL);
	}
	if (filter->resource_mgr) {
		bonobo_object_release_unref (filter->resource_mgr, NULL);
	}
	if (filter->allocation_mgr) {
		bonobo_object_release_unref (filter->allocation_mgr, NULL);
	}

	if (GTK_OBJECT_CLASS (parent_class)->destroy) {
		(* GTK_OBJECT_CLASS (parent_class)->destroy) (object);
	}
}

	
