/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __ALLOCATION_MANAGER_H__
#define __ALLOCATION_MANAGER_H__

#include <glib.h>
#include <bonobo/bonobo-xobject.h>
#include "util/corba-utils.h"
#include "libmrproject/GNOME_MrProject.h"

#define TYPE_ALLOCATION_MANAGER		      (allocation_manager_get_type ())
#define ALLOCATION_MANAGER(obj)		      (GTK_CHECK_CAST ((obj), TYPE_ALLOCATION_MANAGER, AllocationManager))
#define ALLOCATION_MANAGER_CLASS(klass)	      (GTK_CHECK_CLASS_CAST ((klass), TYPE_ALLOCATION_MANAGER, AllocationManagerClass))
#define IS_ALLOCATION_MANAGER(obj)	      (GTK_CHECK_TYPE ((obj), TYPE_ALLOCATION_MANAGER))
#define IS_ALLOCATION_MANAGER_CLASS(klass)    (GTK_CHECK_CLASS_TYPE ((obj), TYPE_ALLOCATION_MANAGER))

typedef struct _AllocationManager      AllocationManager;
typedef struct _AllocationManagerClass AllocationManagerClass;
typedef struct _AllocationManagerPriv  AllocationManagerPriv;

struct _AllocationManager
{
	BonoboXObject                                 parent;

	AllocationManagerPriv                        *priv;
};

struct _AllocationManagerClass
{
	BonoboXObjectClass                            parent_class;
	POA_GNOME_MrProject_AllocationManager__epv    epv;

	/* CORBA methods. */
	GM_Allocation *       (*allocate)    (AllocationManager   *am,
					      GM_Id                task_id,
					      GM_Id                resource_id, 
					      guint                units);
	
	void                  (*deallocate)  (AllocationManager   *am,
					      const GM_Allocation *allocation);
	
	GSList *  (*get_allocations_by_task) (AllocationManager   *am,
					      GM_Id                task_id);
	GSList * (*get_allocations_by_resource) (AllocationManager *am,
						 GM_Id              resource_id);
	GSList *      (*get_all_allocations) (AllocationManager   *am);
	GSList * (*deallocate_all_resources) (AllocationManager   *am,
					      GM_Id                task_id);
	GSList *     (*deallocate_all_tasks) (AllocationManager   *am,
					      GM_Id                resource_id);

	/* C Methods. */
	void (*foreach_allocation)           (AllocationManager   *am,
					      GFunc                func,
					      gpointer             user_data);	
};

GtkType     allocation_manager_get_type     (void);
void        allocation_manager_construct    (AllocationManager  *am,
					     BonoboEventSource  *event_source);

void        allocation_manager_start_listen (AllocationManager  *am);
void
allocation_manager_foreach_allocation       (AllocationManager  *am,
					     GFunc               func,
					     gpointer            user_data);

#endif /* __ALLOCATION_MANAGER_H__ */
